/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph.base;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.funlib.graph.base.EdgeDirectionFunction;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

public abstract class DegreeFunction
extends EdgeDirectionFunction {
    protected DegreeFunction(EdgeDirection edgeDirection) {
        super(edgeDirection, 10L, 1L, 1.0);
    }

    protected Integer evaluate(Vertex vertex) {
        return vertex.getDegree(this.direction);
    }

    protected Integer evaluate(Vertex vertex, TypeCollection typeCollection) {
        int n = 0;
        block5: for (Edge edge = vertex.getFirstIncidence(); edge != null; edge = edge.getNextIncidence()) {
            if (!typeCollection.acceptsType(edge.getAttributedElementClass())) continue;
            switch (this.direction) {
                case INOUT: {
                    ++n;
                    continue block5;
                }
                case OUT: {
                    if (!edge.isNormal()) continue block5;
                    ++n;
                    continue block5;
                }
                case IN: {
                    if (edge.isNormal()) continue block5;
                    ++n;
                }
            }
        }
        return n;
    }

    public Integer evaluate(Vertex vertex, Path path) {
        return path.degree(vertex, this.direction);
    }
}

