/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.artithmetics;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;

public class Mul
extends Function {
    @Description(params={"a", "b"}, description="Multiplies the given two numbers with the usual Java overflow semantics. Can be used as operator: a * b.", categories={Function.Category.ARITHMETICS})
    public Mul() {
        super(4L, 1L, 1.0);
    }

    public Number evaluate(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return number.doubleValue() * number2.doubleValue();
        }
        if (number instanceof Long || number2 instanceof Long) {
            return number.longValue() * number2.longValue();
        }
        return number.intValue() * number2.intValue();
    }
}

