/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VariableDeclaration;
import de.uni_koblenz.jgralab.greql.evaluator.VariableDeclarationLayer;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.SimpleDeclarationEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VariableEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.IsConstraintOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.ArrayList;
import java.util.Iterator;
import org.pcollections.PVector;

public class DeclarationEvaluator
extends VertexEvaluator<Declaration> {
    protected static final int declarationCostsFactor = 5;

    public DeclarationEvaluator(Declaration declaration, GreqlQueryImpl greqlQueryImpl) {
        super(declaration, greqlQueryImpl);
    }

    @Override
    public VariableDeclarationLayer evaluate(InternalGreqlEvaluator internalGreqlEvaluator) {
        internalGreqlEvaluator.progress(this.getOwnEvaluationCosts());
        ArrayList<VertexEvaluator<? extends Expression>> arrayList = new ArrayList<VertexEvaluator<? extends Expression>>();
        for (IsConstraintOf object2 : ((Declaration)this.vertex).getIsConstraintOfIncidences(EdgeDirection.IN)) {
            VertexEvaluator<Expression> vertexEvaluator = this.query.getVertexEvaluator(object2.getAlpha());
            if (vertexEvaluator == null) continue;
            arrayList.add(vertexEvaluator);
        }
        ArrayList arrayList2 = new ArrayList();
        for (IsSimpleDeclOf isSimpleDeclOf : ((Declaration)this.vertex).getIsSimpleDeclOfIncidences(EdgeDirection.IN)) {
            SimpleDeclaration simpleDeclaration = isSimpleDeclOf.getAlpha();
            SimpleDeclarationEvaluator simpleDeclarationEvaluator = (SimpleDeclarationEvaluator)this.query.getVertexEvaluator(simpleDeclaration);
            PVector pVector = (PVector)simpleDeclarationEvaluator.getResult(internalGreqlEvaluator);
            for (VariableDeclaration variableDeclaration : pVector) {
                arrayList2.add(variableDeclaration);
            }
        }
        VariableDeclarationLayer variableDeclarationLayer = new VariableDeclarationLayer((Declaration)this.vertex, arrayList2, arrayList);
        return variableDeclarationLayer;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        GraphElement<VertexClass, Vertex> graphElement;
        Declaration declaration = (Declaration)this.getVertex();
        long l = 0L;
        for (IsSimpleDeclOf isSimpleDeclOf = declaration.getFirstIsSimpleDeclOfIncidence(); isSimpleDeclOf != null; isSimpleDeclOf = isSimpleDeclOf.getNextIsSimpleDeclOfIncidence()) {
            graphElement = isSimpleDeclOf.getAlpha();
            SimpleDeclarationEvaluator simpleDeclarationEvaluator = (SimpleDeclarationEvaluator)this.query.getVertexEvaluator(graphElement);
            l += simpleDeclarationEvaluator.getCurrentSubtreeEvaluationCosts();
        }
        int n = 0;
        for (graphElement = declaration.getFirstIsConstraintOfIncidence(); graphElement != null; graphElement = graphElement.getNextIsConstraintOfIncidence()) {
            VertexEvaluator<Expression> vertexEvaluator = this.query.getVertexEvaluator(graphElement.getAlpha());
            n = (int)((long)n + vertexEvaluator.getCurrentSubtreeEvaluationCosts());
        }
        long l2 = this.getDefinedVariableCombinations() * 5L;
        long l3 = l2 + 2L;
        long l4 = l3 * this.getVariableCombinations();
        long l5 = l4 + (long)n + l;
        return new VertexCosts(l3, l4, l5);
    }

    public long getDefinedVariableCombinations() {
        long l = 1L;
        Iterator<Variable> iterator = this.getDefinedVariables().iterator();
        while (iterator.hasNext()) {
            VariableEvaluator variableEvaluator = (VariableEvaluator)this.query.getVertexEvaluator((GreqlVertex)iterator.next());
            l *= variableEvaluator.getVariableCombinations();
        }
        return l;
    }

    @Override
    public long calculateEstimatedCardinality() {
        Declaration declaration = (Declaration)this.getVertex();
        double d = 1.0;
        for (IsConstraintOf isConstraintOf = declaration.getFirstIsConstraintOfIncidence(EdgeDirection.IN); isConstraintOf != null; isConstraintOf = isConstraintOf.getNextIsConstraintOfIncidence(EdgeDirection.IN)) {
            VertexEvaluator<Expression> vertexEvaluator = this.query.getVertexEvaluator(isConstraintOf.getAlpha());
            d *= vertexEvaluator.getEstimatedSelectivity();
        }
        return Math.round((double)this.getDefinedVariableCombinations() * d);
    }
}

