/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphvalidator;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.graphvalidator.ConstraintViolation;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.Map;
import java.util.Set;

public class MultiplicityConstraintViolation
extends ConstraintViolation {
    private String message;
    Map<AttributedElement<?, ?>, Integer> degreeMap;

    public MultiplicityConstraintViolation(EdgeClass edgeClass, String string, Map<AttributedElement<?, ?>, Integer> map) {
        super(edgeClass);
        this.message = string;
        this.degreeMap = map;
        this.offendingElements = map.keySet();
    }

    public int hashCode() {
        return this.message.hashCode() + this.offendingElements.hashCode() + this.degreeMap.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof MultiplicityConstraintViolation) {
            MultiplicityConstraintViolation multiplicityConstraintViolation = (MultiplicityConstraintViolation)object;
            return this.compareTo(multiplicityConstraintViolation) == 0;
        }
        return false;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Set<AttributedElement<?, ?>> getOffendingElements() {
        return this.offendingElements;
    }

    public int getDegree(AttributedElement<?, ?> attributedElement) {
        return this.degreeMap.get(attributedElement);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Broken multiplicity constraint at EdgeClass ");
        stringBuilder.append(this.attributedElementClass.getQualifiedName());
        stringBuilder.append("! ");
        stringBuilder.append(this.message);
        stringBuilder.append(" Offending vertices: ");
        boolean bl = true;
        for (AttributedElement attributedElement : this.offendingElements) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(attributedElement).append(": ").append(this.degreeMap.get(attributedElement));
        }
        return stringBuilder.toString();
    }
}

