/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.eca.events;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.eca.ECARule;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import java.util.ArrayList;
import java.util.List;
import org.pcollections.PCollection;

public abstract class EventDescription<AEC extends AttributedElementClass<AEC, ?>> {
    protected List<ECARule<AEC>> activeRules;
    private final EventTime time;
    private final Context context;
    private String contextExpression;
    private AEC type;

    public EventDescription(EventTime eventTime, AEC AEC) {
        this.time = eventTime;
        this.activeRules = new ArrayList<ECARule<AEC>>();
        this.type = AEC;
        this.context = Context.TYPE;
    }

    public EventDescription(EventTime eventTime, String string) {
        this.time = eventTime;
        this.activeRules = new ArrayList<ECARule<AEC>>();
        this.contextExpression = string;
        this.context = Context.EXPRESSION;
    }

    protected boolean checkContext(AEC AEC) {
        return this.getType().equals(AEC);
    }

    protected boolean checkContext(AttributedElement<AEC, ?> attributedElement) {
        if (this.context.equals((Object)Context.TYPE)) {
            return attributedElement.getAttributedElementClass().equals(this.type);
        }
        Graph graph = this.activeRules.get(0).getECARuleManager().getGraph();
        Object object = GreqlQuery.createQuery(this.contextExpression).evaluate(graph);
        if (object instanceof PCollection) {
            PCollection pCollection = (PCollection)object;
            for (Object e : pCollection) {
                if (!(e instanceof AttributedElement) || !e.equals(attributedElement)) continue;
                return true;
            }
        }
        return false;
    }

    public EventTime getTime() {
        return this.time;
    }

    public List<ECARule<AEC>> getActiveECARules() {
        return this.activeRules;
    }

    public String getContextExpression() {
        return this.contextExpression;
    }

    public AEC getType() {
        return this.type;
    }

    public Context getContext() {
        return this.context;
    }

    public void addActiveRule(ECARule<?> eCARule) {
        this.activeRules.add(eCARule);
    }

    public static enum Context {
        TYPE,
        EXPRESSION;

    }

    public static enum EventTime {
        BEFORE,
        AFTER;

    }
}

