/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.eca;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.eca.Condition;
import de.uni_koblenz.jgralab.eca.events.Event;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;

public class GreqlCondition<AEC extends AttributedElementClass<AEC, ?>>
implements Condition<AEC> {
    private final String conditionExpression;

    public GreqlCondition(String string) {
        this.conditionExpression = string;
    }

    @Override
    public boolean evaluate(Event<AEC> event) {
        AttributedElement<AEC, ?> attributedElement = event.getElement();
        Graph graph = attributedElement.getGraph();
        GreqlQuery greqlQuery = null;
        GreqlEnvironmentAdapter greqlEnvironmentAdapter = new GreqlEnvironmentAdapter();
        if (this.conditionExpression.contains("context")) {
            greqlQuery = GreqlQuery.createQuery("using context: " + this.conditionExpression);
            greqlEnvironmentAdapter.setVariable("context", attributedElement);
        } else {
            greqlQuery = GreqlQuery.createQuery(this.conditionExpression);
        }
        return (Boolean)greqlQuery.evaluate(graph, greqlEnvironmentAdapter);
    }

    public String getConditionExpression() {
        return this.conditionExpression;
    }

    public String toString() {
        return "Condition: " + this.conditionExpression;
    }
}

