/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.xml2tg.schema;

import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.generic.GenericGraphFactoryImpl;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.impl.ConstraintImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLGraph;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.impl.std.XMLGraphFactoryImpl;
import java.lang.ref.WeakReference;

public class XMLSchema
extends SchemaImpl {
    static WeakReference<XMLSchema> theInstance = new WeakReference<Object>(null);

    public static synchronized XMLSchema instance() {
        XMLSchema xMLSchema = (XMLSchema)theInstance.get();
        if (xMLSchema != null) {
            return xMLSchema;
        }
        xMLSchema = new XMLSchema();
        theInstance = new WeakReference<XMLSchema>(xMLSchema);
        return xMLSchema;
    }

    private XMLSchema() {
        super("XMLSchema", "de.uni_koblenz.jgralab.utilities.xml2tg.schema");
        GraphClass graphClass = this.createGraphClass("XMLGraph");
        VertexClass vertexClass = graphClass.createVertexClass("Attribute");
        vertexClass.setAbstract(false);
        vertexClass.createAttribute("name", this.getDomain("String"), null);
        vertexClass.createAttribute("value", this.getDomain("String"), null);
        VertexClass vertexClass2 = graphClass.createVertexClass("Node");
        vertexClass2.setAbstract(true);
        VertexClass vertexClass3 = graphClass.createVertexClass("Text");
        vertexClass3.setAbstract(false);
        vertexClass3.addSuperClass(vertexClass2);
        vertexClass3.createAttribute("content", this.getDomain("String"), null);
        VertexClass vertexClass4 = graphClass.createVertexClass("Element");
        vertexClass4.setAbstract(false);
        vertexClass4.addSuperClass(vertexClass2);
        vertexClass4.createAttribute("name", this.getDomain("String"), null);
        vertexClass4.addConstraint(new ConstraintImpl("There must be exactly one root element", "exists! e: V{Element} @ inDegree{HasChild}(e) = 0", "from e: V{Element} with inDegree{HasChild}(e) = 0 report e end"));
        vertexClass4.addComment("Each element except the root element must have exactly one parent.");
        EdgeClass edgeClass = graphClass.createEdgeClass("HasAttribute", vertexClass4, 1, 1, "element", AggregationKind.NONE, vertexClass, 0, Integer.MAX_VALUE, "attributes", AggregationKind.COMPOSITE);
        edgeClass.setAbstract(false);
        EdgeClass edgeClass2 = graphClass.createEdgeClass("HasContent", vertexClass4, 0, 1, "parent", AggregationKind.NONE, vertexClass2, 0, Integer.MAX_VALUE, "contents", AggregationKind.COMPOSITE);
        edgeClass2.setAbstract(true);
        EdgeClass edgeClass3 = graphClass.createEdgeClass("References", vertexClass, 0, Integer.MAX_VALUE, "referent", AggregationKind.NONE, vertexClass4, 0, Integer.MAX_VALUE, "refs", AggregationKind.NONE);
        edgeClass3.setAbstract(false);
        EdgeClass edgeClass4 = graphClass.createEdgeClass("HasText", vertexClass4, 1, 1, "", AggregationKind.NONE, vertexClass3, 0, Integer.MAX_VALUE, "texts", AggregationKind.COMPOSITE);
        edgeClass4.setAbstract(false);
        edgeClass4.addSuperClass(edgeClass2);
        EdgeClass edgeClass5 = graphClass.createEdgeClass("HasChild", vertexClass4, 0, 1, "", AggregationKind.NONE, vertexClass4, 0, Integer.MAX_VALUE, "children", AggregationKind.COMPOSITE);
        edgeClass5.setAbstract(false);
        edgeClass5.addSuperClass(edgeClass2);
        this.finish();
    }

    @Override
    public GraphFactory createDefaultGraphFactory(ImplementationType implementationType) {
        switch (implementationType) {
            case GENERIC: {
                return new GenericGraphFactoryImpl(this);
            }
            case STANDARD: {
                return new XMLGraphFactoryImpl();
            }
        }
        throw new UnsupportedOperationException("No " + (Object)((Object)implementationType) + " support compiled.");
    }

    public XMLGraph createXMLGraph(ImplementationType implementationType) {
        return this.createXMLGraph(implementationType, null, 100, 100);
    }

    public XMLGraph createXMLGraph(ImplementationType implementationType, String string, int n, int n2) {
        GraphFactory graphFactory = this.createDefaultGraphFactory(implementationType);
        return (XMLGraph)graphFactory.createGraph(this.getGraphClass(), string, n, n2);
    }

    public XMLGraph createXMLGraph(GraphFactory graphFactory) {
        return (XMLGraph)graphFactory.createGraph(this.getGraphClass(), null, 100, 100);
    }

    public XMLGraph createXMLGraph(GraphFactory graphFactory, String string, int n, int n2) {
        return (XMLGraph)graphFactory.createGraph(this.getGraphClass(), string, n, n2);
    }

    public XMLGraph loadXMLGraph(String string) throws GraphIOException {
        GraphFactory graphFactory = this.createDefaultGraphFactory(ImplementationType.STANDARD);
        return this.loadXMLGraph(string, graphFactory, null);
    }

    public XMLGraph loadXMLGraph(String string, ProgressFunction progressFunction) throws GraphIOException {
        GraphFactory graphFactory = this.createDefaultGraphFactory(ImplementationType.STANDARD);
        return this.loadXMLGraph(string, graphFactory, progressFunction);
    }

    public XMLGraph loadXMLGraph(String string, ImplementationType implementationType) throws GraphIOException {
        GraphFactory graphFactory = this.createDefaultGraphFactory(implementationType);
        return this.loadXMLGraph(string, graphFactory, null);
    }

    public XMLGraph loadXMLGraph(String string, ImplementationType implementationType, ProgressFunction progressFunction) throws GraphIOException {
        GraphFactory graphFactory = this.createDefaultGraphFactory(implementationType);
        return this.loadXMLGraph(string, graphFactory, progressFunction);
    }

    public XMLGraph loadXMLGraph(String string, GraphFactory graphFactory) throws GraphIOException {
        return (XMLGraph)GraphIO.loadGraphFromFile(string, graphFactory, null);
    }

    public XMLGraph loadXMLGraph(String string, GraphFactory graphFactory, ProgressFunction progressFunction) throws GraphIOException {
        return (XMLGraph)GraphIO.loadGraphFromFile(string, graphFactory, progressFunction);
    }

    @Override
    public boolean reopen() {
        throw new UnsupportedOperationException("Cannot reopen a compiled Schema.");
    }
}

