/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.gui.xdot;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class XDotLexer {
    private int line;
    private int col;
    private int la;
    private int putBackChar;
    private BufferedReader in;

    public XDotLexer(InputStream inputStream) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        this.putBackChar = -1;
        this.line = 1;
        this.col = 0;
        this.la = this.read();
    }

    public final int getLine() {
        return this.line;
    }

    public final Token nextToken() throws IOException {
        this.skipWs();
        Type type = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.la < 0) {
            type = Type.EOF;
        } else if (this.la == 34) {
            this.readQuotedString(stringBuilder);
            type = Type.STRING;
        } else if (this.la == 60) {
            this.readHtmlString(stringBuilder);
            type = Type.STRING;
        } else if (XDotLexer.isSeparator(this.la)) {
            stringBuilder.append((char)this.la);
            type = Type.SEPARATOR;
            this.la = this.read();
        } else {
            if (this.la >= 0) {
                do {
                    stringBuilder.append((char)this.la);
                    this.la = this.read();
                } while (!XDotLexer.isWs(this.la) && !XDotLexer.isSeparator(this.la) && this.la >= 0);
            }
            type = Type.TEXT;
        }
        Token token = new Token(type, stringBuilder.toString());
        return token;
    }

    private final int read() throws IOException {
        int n;
        if (this.putBackChar >= 0) {
            n = this.putBackChar;
            this.putBackChar = -1;
        } else {
            n = this.in.read();
        }
        if (n == 10) {
            ++this.line;
            this.col = 0;
            return n;
        }
        while (n == 92) {
            n = this.in.read();
            if (n == 13) {
                n = this.in.read();
                if (n == 10) {
                    ++this.line;
                    n = this.in.read();
                    continue;
                }
                if (n == -1) continue;
                throw new IOException("Expected line end CR/LF but found CR/ASCII " + n);
            }
            if (n == 10) {
                ++this.line;
                n = this.in.read();
                continue;
            }
            this.putBackChar = n;
            n = 92;
            return n;
        }
        ++this.col;
        return n;
    }

    private final void readQuotedString(StringBuilder stringBuilder) throws IOException {
        int n = this.line;
        this.la = this.read();
        while (this.la >= 0 && this.la != 34) {
            if (this.la == 92) {
                this.la = this.read();
                if (this.la < 0) break;
                if (this.la != 34) {
                    stringBuilder.append("\\");
                }
            }
            stringBuilder.append((char)this.la);
            this.la = this.read();
        }
        if (this.la < 0) {
            throw new IOException("Unterminated quoted string starting in line " + n);
        }
        this.la = this.read();
    }

    private final void readHtmlString(StringBuilder stringBuilder) throws IOException {
        int n = this.line;
        this.la = this.read();
        while (this.la >= 0 && this.la != 62) {
            stringBuilder.append((char)this.la);
            this.la = this.read();
        }
        if (this.la < 0) {
            throw new IOException("Unterminated HTML string starting in line " + n);
        }
        this.la = this.read();
    }

    private static final boolean isWs(int n) {
        return n == 32 || n == 10 || n == 9 || n == 13;
    }

    private static final boolean isSeparator(int n) {
        return n == 59 || n == 123 || n == 125 || n == 91 || n == 93 || n == 61 || n == 44;
    }

    private final void skipWs() throws IOException {
        while (true) {
            if (XDotLexer.isWs(this.la)) {
                this.la = this.read();
                continue;
            }
            while (this.la == 47 || this.la == 35 && this.col == 1) {
                if (this.la == 35 && this.col == 1) {
                    while (this.la >= 0 && this.la != 10) {
                        this.la = this.read();
                    }
                    continue;
                }
                this.la = this.read();
                if (this.la >= 0 && this.la == 47) {
                    while (this.la >= 0 && this.la != 10) {
                        this.la = this.read();
                    }
                    continue;
                }
                if (this.la >= 0 && this.la == 42) {
                    int n = this.line;
                    while (true) {
                        if (this.la >= 0 && this.la != 42) {
                            this.la = this.read();
                            continue;
                        }
                        if (this.la >= 0) {
                            this.la = this.read();
                        }
                        if (this.la < 0 || this.la == 47) break;
                    }
                    if (this.la < 0) {
                        throw new IOException("Unterminated multi line comment starting in line " + n);
                    }
                    this.la = this.read();
                    continue;
                }
                this.putback(this.la);
                this.la = 47;
                return;
            }
            if (!XDotLexer.isWs(this.la)) break;
        }
    }

    private final void putback(int n) {
        this.putBackChar = n;
        if (n == 10) {
            --this.line;
        }
    }

    public static final class Token {
        public Type type;
        public String text;

        private Token(Type type, String string) {
            this.type = type;
            this.text = string;
        }
    }

    public static enum Type {
        TEXT,
        SEPARATOR,
        STRING,
        EOF;

    }
}

