/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl.compilation;

import de.uni_koblenz.jgralab.EclipseAdapter;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.schema.impl.compilation.ClassFileObject;
import de.uni_koblenz.jgralab.schema.impl.compilation.InMemoryClassFile;
import de.uni_koblenz.jgralab.schema.impl.compilation.ManagableArtifact;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Logger;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class ClassFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final Logger logger = null;
    private final String qualifiedSchemaName;

    public ClassFileManager(ManagableArtifact managableArtifact, JavaFileManager javaFileManager) {
        super(javaFileManager);
        this.qualifiedSchemaName = managableArtifact.getManagedName();
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return super.hasLocation(location) || location.getName().equals("CLASS_PATH");
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        if (this.logger != null && location.getName().equals("CLASS_PATH")) {
            this.logger.fine("(" + location + ", " + javaFileObject + ")");
        }
        if (location.getName().equals("CLASS_PATH") && javaFileObject instanceof ClassFileObject) {
            return ((ClassFileObject)javaFileObject).getBinaryName();
        }
        return super.inferBinaryName(location, javaFileObject);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) {
        if (this.logger != null) {
            this.logger.fine("(" + location + ", " + string + ", " + (Object)((Object)kind) + ", " + fileObject + ")");
        }
        InMemoryClassFile inMemoryClassFile = new InMemoryClassFile(string);
        SchemaClassManager.instance(this.qualifiedSchemaName).putSchemaClass(string, inMemoryClassFile);
        return inMemoryClassFile;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        EclipseAdapter eclipseAdapter;
        if (this.logger != null) {
            this.logger.fine("(" + location + ", " + string + ", " + set + ", " + bl + ")");
        }
        if ((eclipseAdapter = JGraLab.getEclipseAdapter()) == null || !location.getName().equals("CLASS_PATH") || !set.contains((Object)JavaFileObject.Kind.CLASS)) {
            return super.list(location, string, set, bl);
        }
        return eclipseAdapter.listJavaFileObjects(string, bl);
    }
}

