/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.RecordImpl;
import de.uni_koblenz.jgralab.impl.TgLexer;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.exception.CycleException;
import de.uni_koblenz.jgralab.schema.exception.SchemaClassAccessException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.CompositeDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.DomainImpl;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class RecordDomainImpl
extends CompositeDomainImpl
implements RecordDomain {
    private Class<? extends Object> schemaClass;
    private final Map<String, RecordDomain.RecordComponent> components = new TreeMap<String, RecordDomain.RecordComponent>();

    RecordDomainImpl(String string, PackageImpl packageImpl, Collection<RecordDomain.RecordComponent> collection) {
        super(string, packageImpl);
        if (collection != null) {
            for (RecordDomain.RecordComponent recordComponent : collection) {
                this.addComponent(recordComponent.getName(), recordComponent.getDomain());
            }
        }
    }

    @Override
    public void addComponent(String string, Domain domain) {
        SchemaImpl schemaImpl = (SchemaImpl)this.getSchema();
        schemaImpl.assertNotFinished();
        if (string.isEmpty()) {
            throw new SchemaException("Cannot create a record component with an empty name.");
        }
        if (this.components.containsKey(string)) {
            throw new SchemaException("Duplicate component '" + string + "' in " + this);
        }
        if (this.getSchema() != domain.getSchema()) {
            throw new SchemaException("Domain " + domain.getQualifiedName() + " belongs to a different schema.");
        }
        try {
            schemaImpl.addDomainDependency(this, domain);
        }
        catch (CycleException cycleException) {
            throw new SchemaException("Adding the component '" + string + "' of type '" + domain + "' to '" + this + "' would create a cycle of RecordDomains.");
        }
        RecordDomain.RecordComponent recordComponent = new RecordDomain.RecordComponent(string, domain);
        this.components.put(string, recordComponent);
    }

    @Override
    public Collection<RecordDomain.RecordComponent> getComponents() {
        return this.components.values();
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String string) {
        return string + "." + this.getQualifiedName();
    }

    @Override
    public String getJavaClassName(String string) {
        return this.getJavaAttributeImplementationTypeName(string);
    }

    @Override
    public Class<? extends Object> getSchemaClass() {
        if (this.schemaClass == null) {
            String string = this.getSchema().getPackagePrefix() + "." + this.getQualifiedName();
            try {
                this.schemaClass = Class.forName(string, true, SchemaClassManager.instance(this.getSchema().getQualifiedName()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SchemaClassAccessException("Can't load (generated) schema class for RecordDomain '" + this.getQualifiedName() + "'", classNotFoundException);
            }
        }
        return this.schemaClass;
    }

    @Override
    public CodeBlock getReadMethod(String string, String string2, String string3) {
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.setVariable("name", string2);
        codeSnippet.setVariable("init", "");
        this.internalGetReadMethod(codeSnippet, string, string2, string3);
        return codeSnippet;
    }

    @Override
    public String getTGTypeName(Package package_) {
        return this.getQualifiedName(package_);
    }

    @Override
    public CodeBlock getWriteMethod(String string, String string2, String string3) {
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.setVariable("name", string2);
        this.internalGetWriteMethod(codeSnippet, string, string2, string3);
        return codeSnippet;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Record " + this.getQualifiedName());
        String string = " (";
        for (RecordDomain.RecordComponent recordComponent : this.components.values()) {
            stringBuilder.append(string);
            stringBuilder.append(recordComponent.getName());
            stringBuilder.append('=');
            stringBuilder.append(recordComponent.getDomain());
            string = ", ";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void internalGetReadMethod(CodeSnippet codeSnippet, String string, String string2, String string3) {
        codeSnippet.add("#init#");
        codeSnippet.add("if (" + string3 + ".isNextToken(#token#.LBR)) {");
        codeSnippet.add("\t#name# = new " + this.getSchema().getPackagePrefix() + "." + this.getQualifiedName() + "(io);");
        codeSnippet.add("} else if (" + string3 + ".isNextToken(#token#.NULL_LITERAL)) {");
        codeSnippet.add("\t" + string3 + ".match();");
        codeSnippet.add("\t" + string2 + " = null;");
        codeSnippet.add("} else {");
        codeSnippet.add("\tthrow new GraphIOException(\"Read record: '(' or 'n' expected\");");
        codeSnippet.add("}");
    }

    private void internalGetWriteMethod(CodeSnippet codeSnippet, String string, String string2, String string3) {
        codeSnippet.add("if (#name# != null) {");
        codeSnippet.add("\t#name#.writeComponentValues(" + string3 + ");");
        codeSnippet.add("} else {");
        codeSnippet.add("\t" + string3 + ".writeIdentifier(GraphIO.NULL_LITERAL);");
        codeSnippet.add("}");
    }

    @Override
    public CodeBlock getTransactionReadMethod(String string, String string2, String string3) {
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.setVariable("name", string2);
        codeSnippet.setVariable("init", this.getJavaAttributeImplementationTypeName(string) + " #name# = null;");
        this.internalGetReadMethod(codeSnippet, string, string2, string3);
        return codeSnippet;
    }

    @Override
    public CodeBlock getTransactionWriteMethod(String string, String string2, String string3) {
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.setVariable("name", "get" + CodeGenerator.camelCase(string2) + "()");
        this.internalGetWriteMethod(codeSnippet, string, string2, string3);
        return codeSnippet;
    }

    @Override
    public String getTransactionJavaAttributeImplementationTypeName(String string) {
        return this.getJavaAttributeImplementationTypeName(string);
    }

    @Override
    public String getTransactionJavaClassName(String string) {
        return this.getJavaAttributeImplementationTypeName(string);
    }

    @Override
    public String getVersionedClass(String string) {
        return "de.uni_koblenz.jgralab.impl.trans.VersionedReferenceImpl<" + this.getTransactionJavaAttributeImplementationTypeName(string) + ">";
    }

    @Override
    public String getInitialValue() {
        return "null";
    }

    @Override
    public Boolean hasComponent(String string) {
        return this.components.containsKey(string);
    }

    @Override
    public Object parseGenericAttribute(GraphIO graphIO) throws GraphIOException {
        if (graphIO.isNextToken(TgLexer.Token.LBR)) {
            RecordImpl recordImpl = RecordImpl.empty();
            graphIO.match();
            Iterator<RecordDomain.RecordComponent> iterator = this.getComponents().iterator();
            RecordDomain.RecordComponent recordComponent = iterator.next();
            while (!graphIO.isNextToken(TgLexer.Token.RBR)) {
                Object object = null;
                object = recordComponent.getDomain().parseGenericAttribute(graphIO);
                recordImpl = recordImpl.plus(recordComponent.getName(), object);
                recordComponent = iterator.hasNext() ? iterator.next() : null;
            }
            assert (!iterator.hasNext());
            graphIO.match();
            return recordImpl;
        }
        if (graphIO.isNextToken(TgLexer.Token.NULL_LITERAL)) {
            graphIO.match();
            return null;
        }
        throw new GraphIOException("Read record: '(' or 'n' excpected");
    }

    @Override
    public void serializeGenericAttribute(GraphIO graphIO, Object object) throws IOException {
        if (object != null) {
            graphIO.write("(");
            for (RecordDomain.RecordComponent recordComponent : this.getComponents()) {
                recordComponent.getDomain().serializeGenericAttribute(graphIO, ((Record)object).getComponent(recordComponent.getName()));
            }
            graphIO.write(")");
        } else {
            graphIO.writeIdentifier(GraphIO.NULL_LITERAL);
        }
    }

    @Override
    public boolean isConformValue(Object object) {
        boolean bl;
        if (object == null) {
            return bl;
        }
        if (object instanceof RecordImpl) {
            RecordDomain.RecordComponent recordComponent;
            Iterator<RecordDomain.RecordComponent> iterator = this.getComponents().iterator();
            for (bl = true; iterator.hasNext() && bl; bl &= recordComponent.getDomain().isConformValue(((Record)object).getComponent(recordComponent.getName()))) {
                recordComponent = iterator.next();
            }
            return bl;
        }
        if (object instanceof Record) {
            return object.getClass().equals(this.getSchemaClass());
        }
        return false;
    }

    @Override
    public void setQualifiedName(String string) {
        if (this.qualifiedName.equals(string)) {
            return;
        }
        if (this.schema.knows(string)) {
            throw new SchemaException(string + " is already known to the schema.");
        }
        String[] stringArray = SchemaImpl.splitQualifiedName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (!NamedElementImpl.ATTRELEM_OR_NOCOLLDOMAIN_PATTERN.matcher(string3).matches()) {
            throw new SchemaException("Invalid record domain name '" + string3 + "'.");
        }
        this.unregister();
        this.qualifiedName = string;
        this.simpleName = string3;
        this.parentPackage = this.schema.createPackageWithParents(string2);
        this.register();
    }

    @Override
    public void delete() {
        this.schema.assertNotFinished();
        if (!this.attributes.isEmpty()) {
            throw new SchemaException("Cannot delete record domain that is still used by attributes: " + this.attributes);
        }
        this.parentPackage.domains.remove(this.simpleName);
        this.schema.namedElements.remove(this.qualifiedName);
        this.schema.domains.remove(this.qualifiedName);
    }

    @Override
    protected void registerAttribute(Attribute attribute) {
        this.attributes = this.attributes.plus(attribute);
        for (RecordDomain.RecordComponent recordComponent : this.components.values()) {
            ((DomainImpl)recordComponent.getDomain()).registerAttribute(attribute);
        }
    }
}

