/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.schema.BoolLiteral;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.IsConstraintOf;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Logger;

public class ConditionalExpressionOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(ConditionalExpressionOptimizer.class);

    public ConditionalExpressionOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof ConditionalExpressionOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery greqlQuery) throws OptimizerException {
        Object object;
        Expression expression;
        AbstractCollection abstractCollection;
        boolean bl = false;
        FunctionApplication functionApplication = this.findAndOrNotFunApp(greqlQuery.getQueryGraph().getFirstGreqlExpression());
        while (functionApplication != null) {
            Formula object2;
            abstractCollection = this.rememberConnections(functionApplication);
            Formula formula = Formula.createFormulaFromExpression(functionApplication, greqlQuery);
            if (!formula.equals(object2 = formula.simplify().optimize())) {
                bl = true;
                logger.fine(this.optimizerHeaderString() + "Transformed constraint\n    " + formula + "\nto\n    " + object2 + ".");
                expression = object2.toExpression();
                object = ((AbstractSequentialList)abstractCollection).iterator();
                while (object.hasNext()) {
                    VertexEdgeClassTuple vertexEdgeClassTuple = (VertexEdgeClassTuple)object.next();
                    greqlQuery.getQueryGraph().createEdge(vertexEdgeClassTuple.ec, expression, vertexEdgeClassTuple.v);
                }
                functionApplication.delete();
                functionApplication = this.findAndOrNotFunApp(greqlQuery.getQueryGraph().getFirstGreqlExpression());
                continue;
            }
            functionApplication = null;
        }
        abstractCollection = new HashSet();
        for (IsConstraintOf isConstraintOf : greqlQuery.getQueryGraph().getIsConstraintOfEdges()) {
            expression = isConstraintOf.getAlpha();
            if (!(expression instanceof BoolLiteral) || !(object = (BoolLiteral)expression).is_boolValue()) continue;
            abstractCollection.add(object);
        }
        for (Vertex vertex : abstractCollection) {
            vertex.delete();
        }
        OptimizerUtility.createMissingSourcePositions(greqlQuery.getQueryGraph());
        return bl;
    }

    private LinkedList<VertexEdgeClassTuple> rememberConnections(FunctionApplication functionApplication) {
        LinkedList<VertexEdgeClassTuple> linkedList = new LinkedList<VertexEdgeClassTuple>();
        assert (functionApplication.isValid());
        for (Edge edge : functionApplication.incidences(EdgeDirection.OUT)) {
            linkedList.add(new VertexEdgeClassTuple((GreqlVertex)edge.getOmega(), edge.getAttributedElementClass()));
        }
        return linkedList;
    }

    private FunctionApplication findAndOrNotFunApp(GreqlExpression greqlExpression) {
        LinkedList<GreqlVertex> linkedList = new LinkedList<GreqlVertex>();
        linkedList.add(greqlExpression);
        while (!linkedList.isEmpty()) {
            Object object;
            GreqlVertex greqlVertex = (GreqlVertex)linkedList.poll();
            if (greqlVertex instanceof FunctionApplication && (OptimizerUtility.isAnd((FunctionApplication)(object = (FunctionApplication)greqlVertex)) || OptimizerUtility.isOr((FunctionApplication)object) || OptimizerUtility.isNot((FunctionApplication)object))) {
                return object;
            }
            object = greqlVertex.incidences(EdgeDirection.IN).iterator();
            while (object.hasNext()) {
                Edge edge = (Edge)object.next();
                linkedList.offer((GreqlVertex)edge.getAlpha());
            }
        }
        return null;
    }

    private static class VertexEdgeClassTuple {
        GreqlVertex v;
        EdgeClass ec;

        public VertexEdgeClassTuple(GreqlVertex greqlVertex, EdgeClass edgeClass) {
            this.v = greqlVertex;
            this.ec = edgeClass;
        }
    }
}

