/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.statistics;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Min
extends Function {
    @Description(params={"a", "b"}, description="Returns the minimum of the given two numbers.", categories={Function.Category.STATISTICS})
    public Number evaluate(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return Math.min(number.doubleValue(), number2.doubleValue());
        }
        if (number instanceof Long || number2 instanceof Long) {
            return Math.min(number.longValue(), number2.longValue());
        }
        return Math.min(number.intValue(), number2.intValue());
    }

    @Description(params={"l"}, description="Returns the minimum of a collection of comparable things.", categories={Function.Category.STATISTICS, Function.Category.COLLECTIONS_AND_MAPS})
    public <T extends Comparable<T>> T evaluate(Collection<T> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        Iterator<T> iterator = collection.iterator();
        Comparable comparable = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable comparable2 = (Comparable)iterator.next();
            if (comparable2.compareTo(comparable) >= 0) continue;
            comparable = comparable2;
        }
        return (T)comparable;
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> arrayList) {
        return arrayList.get(0);
    }
}

