/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph.base;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.funlib.graph.base.EdgeDirectionFunction;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import org.pcollections.PVector;

public abstract class IncidencesFunction
extends EdgeDirectionFunction {
    protected IncidencesFunction(EdgeDirection edgeDirection) {
        super(edgeDirection, 10L, 10L, 1.0);
    }

    protected PVector<Edge> evaluate(Vertex vertex) {
        PVector<Edge> pVector = JGraLab.vector();
        for (Edge edge : vertex.incidences()) {
            pVector = pVector.plus(edge);
        }
        return pVector;
    }

    protected PVector<Edge> evaluate(Vertex vertex, TypeCollection typeCollection) {
        PVector<Edge> pVector = JGraLab.vector();
        block5: for (Edge edge = vertex.getFirstIncidence(); edge != null; edge = edge.getNextIncidence()) {
            if (!typeCollection.acceptsType(edge.getAttributedElementClass())) continue;
            switch (this.direction) {
                case INOUT: {
                    pVector = pVector.plus(edge);
                    continue block5;
                }
                case OUT: {
                    if (!edge.isNormal()) continue block5;
                    pVector = pVector.plus(edge);
                    continue block5;
                }
                case IN: {
                    if (edge.isNormal()) continue block5;
                    pVector = pVector.plus(edge);
                }
            }
        }
        return pVector;
    }
}

