/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;

public class IncidenceIndex
extends Function {
    @Description(params={"e", "v"}, description="Returns the index of e in the incidence sequence of v.\nReturns -1 if e is not in v's incidence sequence.", categories={Function.Category.GRAPH})
    public Integer evaluate(Edge edge, Vertex vertex) {
        return IncidenceIndex.eval(edge, vertex);
    }

    protected static Integer eval(Edge edge, Vertex vertex) {
        int n = 0;
        for (Edge edge2 : vertex.incidences()) {
            if (edge2 == edge) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

