/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.AbstractBooleanGraphMarker;
import de.uni_koblenz.jgralab.impl.GraphBaseImpl;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.impl.TgLexer;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Constraint;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.MapDomain;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.BasicDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.ConstraintImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.filechooser.FileFilter;

public final class GraphIO {
    public static final int TGFILE_VERSION = 2;
    public static final String NULL_LITERAL = TgLexer.Token.NULL_LITERAL.toString();
    public static final String TRUE_LITERAL = TgLexer.Token.TRUE_LITERAL.toString();
    public static final String FALSE_LITERAL = TgLexer.Token.FALSE_LITERAL.toString();
    public static final String TGRAPH_FILE_EXTENSION = ".tg";
    public static final String TGRAPH_COMPRESSED_FILE_EXTENSION = ".tg.gz";
    private static final int WRITE_BUFFER_SIZE = 65536;
    private OutputStream TGOut;
    private Schema schema;
    private final Map<String, Domain> domains = new TreeMap<String, Domain>();
    private String gcName;
    private TgLexer lexer;
    private TgLexer.Token lookAhead;
    private Vertex[] edgeIn;
    private Vertex[] edgeOut;
    private int[] firstIncidence;
    private int[] nextIncidence;
    private int edgeOffset;
    private final Set<EnumDomainData> enumDomainBuffer = new HashSet<EnumDomainData>();
    private List<RecordDomainData> recordDomainBuffer = new ArrayList<RecordDomainData>();
    private GraphClassData graphClass = null;
    private final Map<String, List<GraphElementClassData>> vertexClassBuffer = new TreeMap<String, List<GraphElementClassData>>();
    private final Map<String, List<GraphElementClassData>> edgeClassBuffer = new TreeMap<String, List<GraphElementClassData>>();
    private final Map<String, List<String>> commentData = new HashMap<String, List<String>>();
    private String currentPackageName;
    private ByteArrayOutputStream BAOut;
    private final HashMap<String, String> stringPool = new HashMap();
    private GraphFactory graphFactory;
    private int lastCh = 32;
    private boolean compact = true;

    private GraphIO() {
    }

    public static Schema loadSchemaFromFile(String string) throws GraphIOException {
        InputStream inputStream = null;
        try {
            inputStream = GraphIO.inputStreamForFilename(string);
            Schema schema = GraphIO.loadSchemaFromStream(inputStream, string);
            return schema;
        }
        catch (IOException iOException) {
            throw new GraphIOException("Exception while loading schema from " + string, iOException);
        }
        finally {
            GraphIO.close(inputStream);
        }
    }

    public static Schema loadSchemaFromStream(InputStream inputStream) throws GraphIOException {
        return GraphIO.loadSchemaFromStream(inputStream, null);
    }

    public static Schema loadSchemaFromStream(InputStream inputStream, String string) throws GraphIOException {
        try {
            GraphIO graphIO = new GraphIO();
            graphIO.lexer = new TgLexer(inputStream, string);
            graphIO.tgfile();
            graphIO.schema.finish();
            return graphIO.schema;
        }
        catch (GraphIOException graphIOException) {
            throw graphIOException;
        }
        catch (Exception exception) {
            throw new GraphIOException("Exception while loading schema.", exception);
        }
    }

    public static void saveSchemaToFile(Schema schema, String string) throws GraphIOException {
        OutputStream outputStream = null;
        try {
            outputStream = GraphIO.outputStreamForFilename(string);
            GraphIO.saveSchemaToStream(schema, outputStream);
        }
        catch (IOException iOException) {
            throw new GraphIOException("Exception while saving schema to " + string, iOException);
        }
        finally {
            GraphIO.close(outputStream);
        }
    }

    public static void saveSchemaToStream(Schema schema, OutputStream outputStream) throws GraphIOException {
        try {
            GraphIO graphIO = new GraphIO();
            graphIO.TGOut = outputStream;
            graphIO.compact = false;
            graphIO.saveHeader();
            graphIO.saveSchema(schema);
        }
        catch (IOException iOException) {
            throw new GraphException("Exception while saving schema", iOException);
        }
    }

    private void saveSchema(Schema schema) throws IOException {
        this.schema = schema;
        this.write("Schema");
        this.writeIdentifier(this.schema.getQualifiedName());
        this.write(";\n");
        GraphClass graphClass = this.schema.getGraphClass();
        this.write("GraphClass");
        this.writeIdentifier(graphClass.getSimpleName());
        this.writeAttributes(null, graphClass);
        this.writeConstraints(graphClass);
        this.write(";\n");
        this.writeComments(graphClass, graphClass.getSimpleName());
        LinkedList<Package> linkedList = new LinkedList<Package>();
        linkedList.offer(schema.getDefaultPackage());
        while (!linkedList.isEmpty()) {
            Package package_ = (Package)linkedList.poll();
            linkedList.addAll(package_.getSubPackages());
            if (!package_.isDefaultPackage()) {
                this.write("Package");
                this.writeIdentifier(package_.getQualifiedName());
                this.write(";\n");
            }
            for (Domain domain : package_.getDomains()) {
                Object object;
                Domain domain2;
                if (domain instanceof EnumDomain) {
                    domain2 = (EnumDomain)domain;
                    this.write("EnumDomain");
                    this.writeIdentifier(domain2.getSimpleName());
                    this.write("(");
                    object = domain2.getConsts().iterator();
                    while (object.hasNext()) {
                        this.writeIdentifier((String)object.next());
                        if (!object.hasNext()) continue;
                        this.write(",");
                    }
                    this.write(");\n");
                    this.writeComments(domain2, domain2.getSimpleName());
                    continue;
                }
                if (!(domain instanceof RecordDomain)) continue;
                domain2 = (RecordDomain)domain;
                this.write("RecordDomain");
                this.writeIdentifier(domain2.getSimpleName());
                this.write("(");
                object = "";
                for (RecordDomain.RecordComponent recordComponent : domain2.getComponents()) {
                    this.write((String)object);
                    this.writeIdentifier(recordComponent.getName());
                    this.write(":");
                    this.write(recordComponent.getDomain().getTGTypeName(package_));
                    object = ",";
                }
                this.write(");");
                this.writeComments(domain2, domain2.getSimpleName());
            }
            for (VertexClass vertexClass : package_.getVertexClasses()) {
                if (vertexClass.isAbstract()) {
                    this.write("abstract");
                }
                this.write("VertexClass");
                this.writeIdentifier(vertexClass.getSimpleName());
                this.writeHierarchy(package_, vertexClass);
                this.writeAttributes(package_, vertexClass);
                this.writeConstraints(vertexClass);
                this.write(";\n");
                this.writeComments(vertexClass, vertexClass.getSimpleName());
            }
            for (EdgeClass edgeClass : package_.getEdgeClasses()) {
                if (edgeClass.isDefaultGraphElementClass()) continue;
                if (edgeClass.isAbstract()) {
                    this.write("abstract");
                }
                this.write("EdgeClass");
                this.writeIdentifier(edgeClass.getSimpleName());
                this.writeHierarchy(package_, edgeClass);
                this.write("from");
                this.writeIdentifier(edgeClass.getFrom().getVertexClass().getQualifiedName(package_));
                this.write("(");
                this.write(edgeClass.getFrom().getMin() + ",");
                if (edgeClass.getFrom().getMax() == Integer.MAX_VALUE) {
                    this.write("*)");
                } else {
                    this.write(edgeClass.getFrom().getMax() + ")");
                }
                if (!edgeClass.getFrom().getRolename().equals("")) {
                    this.write("role");
                    this.writeIdentifier(edgeClass.getFrom().getRolename());
                }
                switch (edgeClass.getFrom().getAggregationKind()) {
                    case NONE: {
                        break;
                    }
                    case SHARED: {
                        this.write("aggregation shared");
                        break;
                    }
                    case COMPOSITE: {
                        this.write("aggregation composite");
                    }
                }
                this.write("to");
                this.writeIdentifier(edgeClass.getTo().getVertexClass().getQualifiedName(package_));
                this.write("(");
                this.write(edgeClass.getTo().getMin() + ",");
                if (edgeClass.getTo().getMax() == Integer.MAX_VALUE) {
                    this.write("*)");
                } else {
                    this.write(edgeClass.getTo().getMax() + ")");
                }
                if (!edgeClass.getTo().getRolename().equals("")) {
                    this.write("role");
                    this.writeIdentifier(edgeClass.getTo().getRolename());
                }
                switch (edgeClass.getTo().getAggregationKind()) {
                    case NONE: {
                        break;
                    }
                    case SHARED: {
                        this.write("aggregation shared");
                        break;
                    }
                    case COMPOSITE: {
                        this.write("aggregation composite");
                    }
                }
                this.writeAttributes(package_, edgeClass);
                this.writeConstraints(edgeClass);
                this.write(";\n");
                this.writeComments(edgeClass, edgeClass.getSimpleName());
            }
            this.writeComments(package_, "." + package_.getQualifiedName());
        }
    }

    private void writeComments(NamedElement namedElement, String string) throws IOException {
        if (!namedElement.getComments().isEmpty()) {
            this.write("Comment");
            this.writeIdentifier(string);
            for (String string2 : namedElement.getComments()) {
                this.writeUtfString(string2);
            }
            this.write(";\n");
        }
    }

    private void writeConstraints(AttributedElementClass<?, ?> attributedElementClass) throws IOException {
        for (Constraint constraint : attributedElementClass.getConstraints()) {
            this.write("[");
            this.writeUtfString(constraint.getMessage());
            this.writeUtfString(constraint.getPredicate());
            if (constraint.getOffendingElementsQuery() != null) {
                this.writeUtfString(constraint.getOffendingElementsQuery());
            }
            this.write("]");
        }
    }

    public static void saveGraphToFile(Graph graph, String string, ProgressFunction progressFunction) throws GraphIOException {
        OutputStream outputStream = null;
        try {
            outputStream = GraphIO.outputStreamForFilename(string);
            GraphIO.saveGraphToStream(graph, outputStream, progressFunction);
        }
        catch (IOException iOException) {
            throw new GraphIOException("Exception while saving graph to " + string, iOException);
        }
        finally {
            GraphIO.close(outputStream);
        }
    }

    public static void saveGraphToFile(AbstractBooleanGraphMarker abstractBooleanGraphMarker, String string, ProgressFunction progressFunction) throws GraphIOException {
        OutputStream outputStream = null;
        try {
            outputStream = GraphIO.outputStreamForFilename(string);
            GraphIO.saveGraphToStream(abstractBooleanGraphMarker, outputStream, progressFunction);
        }
        catch (IOException iOException) {
            throw new GraphIOException("Exception while saving graph to " + string, iOException);
        }
        finally {
            GraphIO.close(outputStream);
        }
    }

    public static void saveGraphToStream(Graph graph, OutputStream outputStream, ProgressFunction progressFunction) throws GraphIOException {
        try {
            if (GraphIO.hasTemporaryElements(graph)) {
                throw new GraphIOException("Saving graph " + graph + " is not possible. " + "It contains temporary graph elements.");
            }
            GraphIO graphIO = new GraphIO();
            graphIO.TGOut = outputStream;
            graphIO.compact = true;
            graphIO.saveGraph((InternalGraph)graph, progressFunction, null);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new GraphIOException("Exception while saving graph", iOException);
        }
    }

    public static void saveGraphToStream(AbstractBooleanGraphMarker abstractBooleanGraphMarker, OutputStream outputStream, ProgressFunction progressFunction) throws GraphIOException {
        try {
            if (GraphIO.hasTemporaryElements(abstractBooleanGraphMarker, abstractBooleanGraphMarker.getGraph())) {
                throw new GraphIOException("Saving subgraph " + abstractBooleanGraphMarker + " of " + abstractBooleanGraphMarker.getGraph() + " is not possible. " + "It contains temporary graph elements.");
            }
            GraphIO graphIO = new GraphIO();
            graphIO.TGOut = outputStream;
            graphIO.compact = true;
            graphIO.saveGraph((InternalGraph)abstractBooleanGraphMarker.getGraph(), progressFunction, abstractBooleanGraphMarker);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new GraphIOException("Exception while saving graph", iOException);
        }
    }

    private static boolean hasTemporaryElements(Graph graph) {
        if (graph.vertices(graph.getGraphClass().getTemporaryVertexClass()).iterator().hasNext()) {
            return true;
        }
        return graph.edges(graph.getGraphClass().getTemporaryEdgeClass()).iterator().hasNext();
    }

    private static boolean hasTemporaryElements(AbstractBooleanGraphMarker abstractBooleanGraphMarker, Graph graph) {
        for (Vertex graphElement : graph.vertices(graph.getGraphClass().getTemporaryVertexClass())) {
            if (!abstractBooleanGraphMarker.isMarked(graphElement)) continue;
            return true;
        }
        for (Edge edge : graph.edges(graph.getGraphClass().getTemporaryEdgeClass())) {
            if (!abstractBooleanGraphMarker.isMarked(edge)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGraph(InternalGraph internalGraph, ProgressFunction progressFunction, AbstractBooleanGraphMarker abstractBooleanGraphMarker) throws IOException, GraphIOException {
        TraversalContext traversalContext = internalGraph.setTraversalContext(null);
        try {
            Comparable<NamedElement> comparable;
            NamedElement namedElement;
            Comparable<AttributedElement<EdgeClass, Edge>> comparable2;
            AttributedElement attributedElement2;
            this.saveHeader();
            this.schema = internalGraph.getSchema();
            this.saveSchema(this.schema);
            long l = 0L;
            long l2 = 0L;
            long l3 = 1L;
            if (progressFunction != null) {
                if (abstractBooleanGraphMarker != null) {
                    progressFunction.init(abstractBooleanGraphMarker.size());
                } else {
                    progressFunction.init(internalGraph.getVCount() + internalGraph.getECount());
                }
                l3 = progressFunction.getUpdateInterval();
            }
            this.write("Graph");
            this.write(GraphIO.toUtfString(internalGraph.getId()));
            this.writeLong(internalGraph.getGraphVersion());
            this.writeIdentifier(internalGraph.getAttributedElementClass().getQualifiedName());
            int n = internalGraph.getVCount();
            int n2 = internalGraph.getECount();
            if (abstractBooleanGraphMarker != null) {
                n = 0;
                n2 = 0;
                for (AttributedElement attributedElement2 : abstractBooleanGraphMarker.getMarkedElements()) {
                    if (attributedElement2 instanceof Vertex) {
                        ++n;
                        continue;
                    }
                    if (!(attributedElement2 instanceof Edge)) continue;
                    ++n2;
                }
            }
            this.write("(");
            this.writeInteger(internalGraph.getMaxVCount());
            this.writeInteger(internalGraph.getMaxECount());
            this.writeInteger(n);
            this.writeInteger(n2);
            this.write(")");
            internalGraph.writeAttributeValues(this);
            this.write(";\n");
            Object object = null;
            attributedElement2 = internalGraph.getFirstVertex();
            while (attributedElement2 != null) {
                if (abstractBooleanGraphMarker != null && !abstractBooleanGraphMarker.isMarked(attributedElement2)) {
                    attributedElement2 = attributedElement2.getNextVertex();
                    continue;
                }
                long l4 = attributedElement2.getId();
                comparable2 = attributedElement2.getAttributedElementClass();
                namedElement = comparable2.getPackage();
                if (namedElement != object) {
                    this.write("Package");
                    this.writeIdentifier(namedElement.getQualifiedName());
                    this.write(";\n");
                    object = namedElement;
                }
                this.write(Long.toString(l4));
                this.writeIdentifier(comparable2.getSimpleName());
                comparable = attributedElement2.getFirstIncidence();
                this.write("<");
                while (comparable != null) {
                    if (abstractBooleanGraphMarker != null && !abstractBooleanGraphMarker.isMarked(comparable)) {
                        comparable = comparable.getNextIncidence();
                        continue;
                    }
                    this.writeLong(comparable.getId());
                    comparable = comparable.getNextIncidence();
                }
                this.write(">");
                attributedElement2.writeAttributeValues(this);
                this.write(";\n");
                attributedElement2 = attributedElement2.getNextVertex();
                if (progressFunction == null) continue;
                ++l;
                if (++l2 != l3) continue;
                progressFunction.progress(l);
                l2 = 0L;
            }
            comparable2 = internalGraph.getFirstEdge();
            while (comparable2 != null) {
                if (abstractBooleanGraphMarker != null && !abstractBooleanGraphMarker.isMarked(comparable2)) {
                    comparable2 = comparable2.getNextEdge();
                    continue;
                }
                long l5 = comparable2.getId();
                namedElement = comparable2.getAttributedElementClass();
                comparable = namedElement.getPackage();
                if (comparable != object) {
                    this.write("Package");
                    this.writeIdentifier(comparable.getQualifiedName());
                    this.write(";\n");
                    object = comparable;
                }
                this.write(Long.toString(l5));
                this.writeIdentifier(namedElement.getSimpleName());
                comparable2.writeAttributeValues(this);
                this.write(";\n");
                comparable2 = comparable2.getNextEdge();
                if (progressFunction == null) continue;
                ++l;
                if (++l2 != l3) continue;
                progressFunction.progress(l);
                l2 = 0L;
            }
            this.TGOut.flush();
            if (progressFunction != null) {
                progressFunction.finished();
            }
        }
        finally {
            internalGraph.setTraversalContext(traversalContext);
        }
    }

    private void saveHeader() throws IOException {
        this.write(JGraLab.getVersionInfo(true));
        this.write("TGraph");
        this.writeInteger(2);
        this.write(";\n");
    }

    private void writeHierarchy(Package package_, GraphElementClass<?, ?> graphElementClass) throws IOException {
        String string = ":";
        for (GraphElementClass graphElementClass2 : graphElementClass.getDirectSuperClasses()) {
            this.write(string);
            this.writeIdentifier(graphElementClass2.getQualifiedName(package_));
            string = ",";
        }
    }

    private void writeAttributes(Package package_, AttributedElementClass<?, ?> attributedElementClass) throws IOException {
        List<Attribute> list = attributedElementClass.getOwnAttributeList();
        if (list.isEmpty()) {
            return;
        }
        String string = "{";
        for (Attribute attribute : list) {
            this.write(string);
            string = ",";
            this.writeIdentifier(attribute.getName());
            this.write(":");
            String string2 = attribute.getDomain().getTGTypeName(package_);
            this.write(string2);
            if (attribute.getDefaultValueAsString() == null || attribute.getDefaultValueAsString().equals("n")) continue;
            this.write("=");
            this.writeUtfString(attribute.getDefaultValueAsString());
        }
        this.write("}");
    }

    public final void write(String string) throws IOException {
        int n = string.length();
        if (n > 0) {
            char c = string.charAt(0);
            if (this.compact) {
                if (!TgLexer.isDelimiter(this.lastCh) && !TgLexer.isDelimiter(c)) {
                    this.TGOut.write(32);
                }
            } else if (!TgLexer.isWs(this.lastCh) && this.lastCh != 40 && this.lastCh != 91 && this.lastCh != 123 && this.lastCh != 60 && c != ')' && c != ']' && c != '}' && c != '>' && c != ':' && c != ',' && c != ';') {
                this.TGOut.write(32);
            }
            this.TGOut.write(c);
            this.lastCh = c;
            for (int i = 1; i < n; ++i) {
                this.lastCh = string.charAt(i);
                this.TGOut.write((byte)this.lastCh);
            }
        }
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? TRUE_LITERAL : FALSE_LITERAL);
    }

    public final void writeInteger(int n) throws IOException {
        this.write(Integer.toString(n));
    }

    public final void writeLong(long l) throws IOException {
        this.write(Long.toString(l));
    }

    public final void writeDouble(double d) throws IOException {
        this.write(Double.toString(d));
    }

    public final void writeUtfString(String string) throws IOException {
        this.write(string == null ? NULL_LITERAL : GraphIO.toUtfString(string));
    }

    public final void writeIdentifier(String string) throws IOException {
        this.write(string);
    }

    public static GraphIO createStringReader(String string, Schema schema) throws GraphIOException {
        GraphIO graphIO = new GraphIO();
        graphIO.lexer = new TgLexer(string);
        graphIO.schema = schema;
        graphIO.match();
        return graphIO;
    }

    public static GraphIO createStringWriter(Schema schema) {
        GraphIO graphIO = new GraphIO();
        graphIO.BAOut = new ByteArrayOutputStream();
        graphIO.TGOut = graphIO.BAOut;
        graphIO.schema = schema;
        return graphIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringWriterResult() throws GraphIOException, IOException {
        if (this.BAOut == null) {
            throw new GraphIOException("GraphIO did not write to a String.");
        }
        try {
            String string;
            this.BAOut.flush();
            String string2 = string = this.BAOut.toString("US-ASCII");
            return string2;
        }
        finally {
            GraphIO.close(this.BAOut);
        }
    }

    public static Graph loadGraphFromFile(String string, ProgressFunction progressFunction) throws GraphIOException {
        return GraphIO.loadGraphFromFile(string, ImplementationType.STANDARD, progressFunction);
    }

    public static Graph loadGraphFromFile(String string, ImplementationType implementationType, ProgressFunction progressFunction) throws GraphIOException {
        if (implementationType == null) {
            throw new IllegalArgumentException("ImplementationType must be != null");
        }
        InputStream inputStream = null;
        try {
            inputStream = GraphIO.inputStreamForFilename(string);
            Object g = GraphIO.loadGraphFromStream(inputStream, string, null, null, implementationType, progressFunction);
            return g;
        }
        catch (IOException iOException) {
            throw new GraphIOException("Exception while loading graph from file " + string, iOException);
        }
        finally {
            GraphIO.close(inputStream);
        }
    }

    public static <G extends Graph> G loadGraphFromFile(String string, Schema schema, ImplementationType implementationType, ProgressFunction progressFunction) throws GraphIOException {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must be != null");
        }
        if (implementationType == null) {
            throw new IllegalArgumentException("ImplementationType must be != null");
        }
        GraphFactory graphFactory = schema.createDefaultGraphFactory(implementationType);
        return GraphIO.loadGraphFromFile(string, graphFactory, progressFunction);
    }

    public static <G extends Graph> G loadGraphFromFile(String string, GraphFactory graphFactory, ProgressFunction progressFunction) throws GraphIOException {
        if (graphFactory == null) {
            throw new IllegalArgumentException("GraphFactory must be != null");
        }
        InputStream inputStream = null;
        try {
            inputStream = GraphIO.inputStreamForFilename(string);
            G g = GraphIO.loadGraphFromStream(inputStream, string, graphFactory.getSchema(), graphFactory, graphFactory.getImplementationType(), progressFunction);
            return g;
        }
        catch (IOException iOException) {
            throw new GraphIOException("Exception while loading graph from file " + string, iOException);
        }
        finally {
            GraphIO.close(inputStream);
        }
    }

    private static InputStream inputStreamForFilename(String string) throws IOException {
        InputStream inputStream = new FileInputStream(string);
        if (string.toLowerCase().endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    private static OutputStream outputStreamForFilename(String string) throws IOException {
        OutputStream outputStream = new FileOutputStream(string);
        outputStream = string.toLowerCase().endsWith(".gz") ? new BufferedOutputStream(new GZIPOutputStream(outputStream), 65536) : new BufferedOutputStream(outputStream, 65536);
        return outputStream;
    }

    private static void close(Closeable closeable) throws GraphIOException {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            throw new GraphIOException("Exception while closing stream.", iOException);
        }
    }

    public static <G extends Graph> G loadGraphFromStream(InputStream inputStream, String string, Schema schema, GraphFactory graphFactory, ImplementationType implementationType, ProgressFunction progressFunction) throws GraphIOException {
        try {
            Object object;
            GraphIO graphIO = new GraphIO();
            graphIO.lexer = new TgLexer(inputStream, string);
            graphIO.schema = schema;
            graphIO.tgfile();
            if (implementationType != ImplementationType.GENERIC) {
                object = graphIO.schema.getQualifiedName();
                Class<?> clazz = null;
                try {
                    clazz = Class.forName((String)object, true, SchemaClassManager.instance((String)object));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    graphIO.schema.finish();
                    graphIO.schema.compile(CodeGeneratorConfiguration.MINIMAL);
                    try {
                        clazz = Class.forName((String)object, true, SchemaClassManager.instance((String)object));
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        throw new GraphIOException("Unable to load a graph which belongs to the schema because the Java-classes for this schema can not be created.", classNotFoundException2);
                    }
                }
                Method method = clazz.getMethod("instance", null);
                graphIO.schema = (Schema)method.invoke(null, new Object[0]);
            }
            graphIO.schema.finish();
            if (graphFactory == null) {
                graphFactory = graphIO.schema.createDefaultGraphFactory(implementationType);
            }
            if (graphFactory.getSchema() != graphIO.schema) {
                throw new GraphIOException("Incompatible in graph factory: Expected '" + graphIO.schema.getQualifiedName() + "', found '" + graphFactory.getSchema().getQualifiedName() + "'.");
            }
            if (implementationType != null && graphFactory.getImplementationType() != implementationType) {
                throw new GraphIOException("Graph factory has wrong implementation type: Expected '" + (Object)((Object)implementationType) + "', found '" + (Object)((Object)graphFactory.getImplementationType()) + "'.");
            }
            graphIO.graphFactory = graphFactory;
            object = graphIO.graph(progressFunction);
            return (G)object;
        }
        catch (GraphIOException graphIOException) {
            throw graphIOException;
        }
        catch (Exception exception) {
            throw new GraphIOException("Exception while loading graph.", exception);
        }
    }

    private void tgfile() throws GraphIOException {
        this.match();
        this.header();
        this.schema();
        if (this.lookAhead == TgLexer.Token.EOF || this.lookAhead == TgLexer.Token.GRAPH) {
            return;
        }
        throw new GraphIOException(this.lexer.getLocation() + "Unexpected symbol '" + this.lexer.getText() + "'");
    }

    private void header() throws GraphIOException {
        this.match(TgLexer.Token.TGRAPH);
        int n = this.matchInteger();
        if (n != 2) {
            throw new GraphIOException("Can't read TGFile version " + n + ". Expected version " + 2);
        }
        this.match(TgLexer.Token.SEMICOLON);
    }

    private void schema() throws GraphIOException {
        this.currentPackageName = "";
        this.match(TgLexer.Token.SCHEMA);
        String[] stringArray = this.matchAndSplitQualifiedName();
        if (stringArray[0].isEmpty()) {
            throw new GraphIOException(this.lexer.getLocation() + "Invalid schema name '" + (Object)((Object)this.lookAhead) + "', package prefix must not be empty.");
        }
        this.match(TgLexer.Token.SEMICOLON);
        if (this.schema != null) {
            if (this.schema.getQualifiedName().equals(stringArray[0] + "." + stringArray[1])) {
                TgLexer.Token token = null;
                while (this.lookAhead != TgLexer.Token.EOF && (token != TgLexer.Token.SEMICOLON || this.lookAhead != TgLexer.Token.GRAPH)) {
                    token = this.lookAhead;
                    this.match();
                }
                return;
            }
            throw new GraphIOException("Trying to load a graph with wrong schema. Expected: " + this.schema.getQualifiedName() + ", but found " + stringArray[0] + "." + stringArray[1]);
        }
        this.schema = new SchemaImpl(stringArray[1], stringArray[0]);
        this.parseSchema();
        if (this.lookAhead != TgLexer.Token.EOF && this.lookAhead != TgLexer.Token.GRAPH) {
            throw new GraphIOException(this.lexer.getLocation() + "Unexpected symbol '" + this.lexer.getText() + "'");
        }
        this.checkFromToVertexClasses();
        this.sortRecordDomains();
        this.sortVertexClasses();
        this.sortEdgeClasses();
        this.createDomains();
        this.completeGraphClass();
        this.buildHierarchy();
        this.processComments();
    }

    private void processComments() throws GraphIOException {
        for (Map.Entry<String, List<String>> entry : this.commentData.entrySet()) {
            if (!this.schema.knows(entry.getKey())) {
                throw new GraphIOException("Annotated element '" + entry.getKey() + "' not found in schema " + this.schema.getQualifiedName());
            }
            NamedElement namedElement = this.schema.getNamedElement(entry.getKey());
            if (namedElement instanceof Domain && !(namedElement instanceof EnumDomain) && !(namedElement instanceof RecordDomain)) {
                throw new GraphIOException("Default domains can not have comments. Offending domain is '" + entry.getKey() + "'");
            }
            for (String string : entry.getValue()) {
                namedElement.addComment(string);
            }
        }
    }

    private Map<String, Domain> createDomains() throws GraphIOException {
        this.createEnumDomains();
        this.createRecordDomains();
        return this.domains;
    }

    private void parseEnumDomain() throws GraphIOException {
        this.match(TgLexer.Token.ENUMDOMAIN);
        String[] stringArray = this.matchAndSplitQualifiedName();
        this.enumDomainBuffer.add(new EnumDomainData(stringArray[0], stringArray[1], this.parseEnumConstants()));
        this.match(TgLexer.Token.SEMICOLON);
    }

    private void createEnumDomains() {
        for (EnumDomainData enumDomainData : this.enumDomainBuffer) {
            String string = this.toQNameString(enumDomainData.packageName, enumDomainData.simpleName);
            EnumDomain enumDomain = this.schema.createEnumDomain(string, enumDomainData.enumConstants);
            this.domains.put(string, enumDomain);
        }
    }

    private void parseRecordDomain() throws GraphIOException {
        this.match(TgLexer.Token.RECORDDOMAIN);
        String[] stringArray = this.matchAndSplitQualifiedName();
        this.recordDomainBuffer.add(new RecordDomainData(stringArray[0], stringArray[1], this.parseRecordComponents()));
        this.match(TgLexer.Token.SEMICOLON);
    }

    private void createRecordDomains() throws GraphIOException {
        for (RecordDomainData recordDomainData : this.recordDomainBuffer) {
            String string = this.toQNameString(recordDomainData.packageName, recordDomainData.simpleName);
            RecordDomain recordDomain = this.schema.createRecordDomain(string, this.getComponents(recordDomainData.components));
            this.domains.put(string, recordDomain);
        }
    }

    private List<RecordDomain.RecordComponent> getComponents(List<ComponentData> list) throws GraphIOException {
        ArrayList<RecordDomain.RecordComponent> arrayList = new ArrayList<RecordDomain.RecordComponent>(list.size());
        for (ComponentData componentData : list) {
            RecordDomain.RecordComponent recordComponent = new RecordDomain.RecordComponent(componentData.name, this.attrDomain(componentData.domainDescription));
            arrayList.add(recordComponent);
        }
        return arrayList;
    }

    private void parseSchema() throws GraphIOException {
        while (this.lookAhead == TgLexer.Token.COMMENT) {
            this.parseComment();
        }
        String string = this.parseGraphClass();
        while (this.lookAhead == TgLexer.Token.PACKAGE || this.lookAhead == TgLexer.Token.RECORDDOMAIN || this.lookAhead == TgLexer.Token.ENUMDOMAIN || this.lookAhead == TgLexer.Token.ABSTRACT || this.lookAhead == TgLexer.Token.VERTEXCLASS || this.lookAhead == TgLexer.Token.EDGECLASS || this.lookAhead == TgLexer.Token.COMMENT) {
            if (this.lookAhead == TgLexer.Token.PACKAGE) {
                this.parsePackage();
                continue;
            }
            if (this.lookAhead == TgLexer.Token.RECORDDOMAIN) {
                this.parseRecordDomain();
                continue;
            }
            if (this.lookAhead == TgLexer.Token.ENUMDOMAIN) {
                this.parseEnumDomain();
                continue;
            }
            if (this.lookAhead == TgLexer.Token.COMMENT) {
                this.parseComment();
                continue;
            }
            this.parseGraphElementClass(string);
        }
    }

    private void parseComment() throws GraphIOException {
        this.match(TgLexer.Token.COMMENT);
        String string = this.matchQualifiedName(true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.matchUtfString());
        while (this.lookAhead != TgLexer.Token.SEMICOLON) {
            arrayList.add(this.matchUtfString());
        }
        this.match(TgLexer.Token.SEMICOLON);
        if (this.commentData.containsKey(string)) {
            this.commentData.get(string).addAll(arrayList);
        } else {
            this.commentData.put(string, arrayList);
        }
    }

    private void parsePackage() throws GraphIOException {
        this.match(TgLexer.Token.PACKAGE);
        this.currentPackageName = "";
        this.currentPackageName = this.lookAhead == TgLexer.Token.SEMICOLON ? "" : this.matchPackageName() + ".";
        this.match(TgLexer.Token.SEMICOLON);
    }

    private void completeGraphClass() throws GraphIOException {
        GraphClass graphClass = this.createGraphClass(this.graphClass);
        for (GraphElementClassData graphElementClassData : this.vertexClassBuffer.get(this.graphClass.name)) {
            this.createVertexClass(graphElementClassData, graphClass);
        }
        for (GraphElementClassData graphElementClassData : this.edgeClassBuffer.get(this.graphClass.name)) {
            this.createEdgeClass(graphElementClassData, graphClass);
        }
    }

    private String parseGraphClass() throws GraphIOException {
        this.match(TgLexer.Token.GRAPHCLASS);
        this.graphClass = new GraphClassData();
        this.graphClass.name = this.matchSimpleName(true);
        if (this.lookAhead == TgLexer.Token.LCRL) {
            this.graphClass.attributes = this.parseAttributes();
        }
        if (this.lookAhead == TgLexer.Token.LSQ) {
            this.graphClass.constraints = this.parseConstraints();
        }
        this.match(TgLexer.Token.SEMICOLON);
        this.vertexClassBuffer.put(this.graphClass.name, new ArrayList());
        this.edgeClassBuffer.put(this.graphClass.name, new ArrayList());
        return this.graphClass.name;
    }

    private GraphClass createGraphClass(GraphClassData graphClassData) throws GraphIOException {
        GraphClass graphClass = this.schema.createGraphClass(graphClassData.name);
        graphClass.setAbstract(graphClassData.isAbstract);
        this.addAttributes(graphClassData.attributes, graphClass);
        for (Constraint constraint : graphClassData.constraints) {
            graphClass.addConstraint(constraint);
        }
        return graphClass;
    }

    private List<String> parseHierarchy() throws GraphIOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        this.match(TgLexer.Token.COLON);
        String string = this.matchQualifiedName();
        linkedList.add(string);
        while (this.lookAhead == TgLexer.Token.COMMA) {
            this.match();
            string = this.matchQualifiedName();
            linkedList.add(string);
        }
        return linkedList;
    }

    private List<AttributeData> parseAttributes() throws GraphIOException {
        ArrayList<AttributeData> arrayList = new ArrayList<AttributeData>();
        TreeSet<String> treeSet = new TreeSet<String>();
        this.match(TgLexer.Token.LCRL);
        AttributeData attributeData = new AttributeData();
        attributeData.name = this.matchSimpleName(false);
        this.match(TgLexer.Token.COLON);
        attributeData.domainDescription = this.parseAttrDomain();
        if (this.lookAhead == TgLexer.Token.EQ) {
            this.match();
            attributeData.defaultValue = this.matchUtfString();
        }
        arrayList.add(attributeData);
        treeSet.add(attributeData.name);
        while (this.lookAhead == TgLexer.Token.COMMA) {
            this.match();
            attributeData = new AttributeData();
            attributeData.name = this.matchSimpleName(false);
            this.match(TgLexer.Token.COLON);
            attributeData.domainDescription = this.parseAttrDomain();
            if (this.lookAhead == TgLexer.Token.EQ) {
                this.match();
                attributeData.defaultValue = this.matchUtfString();
            }
            if (treeSet.contains(attributeData.name)) {
                throw new GraphIOException(this.lexer.getLocation() + "Duplicate attribute name '" + attributeData.name + "'");
            }
            arrayList.add(attributeData);
            treeSet.add(attributeData.name);
        }
        this.match(TgLexer.Token.RCRL);
        return arrayList;
    }

    private void addAttributes(List<AttributeData> list, AttributedElementClass<?, ?> attributedElementClass) throws GraphIOException {
        for (AttributeData attributeData : list) {
            attributedElementClass.createAttribute(attributeData.name, this.attrDomain(attributeData.domainDescription), attributeData.defaultValue);
        }
    }

    private List<String> parseAttrDomain() throws GraphIOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.parseAttrDomain(arrayList);
        return arrayList;
    }

    private void parseAttrDomain(List<String> list) throws GraphIOException {
        if (this.lookAhead == TgLexer.Token.LIST || this.lookAhead == TgLexer.Token.LIST2) {
            this.match();
            this.match(TgLexer.Token.LT);
            list.add("List<");
            this.parseAttrDomain(list);
            this.match(TgLexer.Token.GT);
        } else if (this.lookAhead == TgLexer.Token.SET || this.lookAhead == TgLexer.Token.SET2) {
            this.match();
            this.match(TgLexer.Token.LT);
            list.add("Set<");
            this.parseAttrDomain(list);
            this.match(TgLexer.Token.GT);
        } else if (this.lookAhead == TgLexer.Token.MAP || this.lookAhead == TgLexer.Token.MAP2) {
            this.match();
            this.match(TgLexer.Token.LT);
            list.add("Map<");
            this.parseAttrDomain(list);
            this.match(TgLexer.Token.COMMA);
            this.parseAttrDomain(list);
            this.match(TgLexer.Token.GT);
        } else {
            String string = this.lexer.getText();
            if (this.isBasicDomainName(string)) {
                list.add(string);
                this.match();
            } else {
                String string2 = this.matchQualifiedName();
                list.add(string2);
            }
        }
    }

    private boolean isBasicDomainName(String string) {
        return BasicDomainImpl.isBasicDomain(string.startsWith(".") ? string.substring(1) : string);
    }

    private Domain attrDomain(List<String> list) throws GraphIOException {
        Iterator<String> iterator = list.iterator();
        if (iterator.hasNext()) {
            String string = iterator.next();
            iterator.remove();
            if (string.equals("List<")) {
                try {
                    return this.schema.createListDomain(this.attrDomain(list));
                }
                catch (SchemaException schemaException) {
                    throw new GraphIOException(this.lexer.getLocation() + "Can't create list domain.", schemaException);
                }
            }
            if (string.equals("Set<")) {
                try {
                    return this.schema.createSetDomain(this.attrDomain(list));
                }
                catch (SchemaException schemaException) {
                    throw new GraphIOException(this.lexer.getLocation() + "Can't create set domain.", schemaException);
                }
            }
            if (string.equals("Map<")) {
                try {
                    Domain domain = this.attrDomain(list);
                    Domain domain2 = this.attrDomain(list);
                    if (domain == null) {
                        throw new GraphIOException(this.lexer.getLocation() + "Can't create map domain, because no key domain was specified.");
                    }
                    MapDomain mapDomain = this.schema.createMapDomain(domain, domain2);
                    return mapDomain;
                }
                catch (SchemaException schemaException) {
                    throw new GraphIOException(this.lexer.getLocation() + "Can't create map domain.", schemaException);
                }
            }
            Domain domain = this.schema.getDomain(string);
            if (domain == null) {
                throw new GraphIOException(this.lexer.getLocation() + "Undefined domain '" + string + "'");
            }
            return domain;
        }
        throw new GraphIOException(this.lexer.getLocation() + "Couldn't create domain for '" + list + "'");
    }

    public final String matchEnumConstant() throws GraphIOException {
        if (this.lookAhead == TgLexer.Token.NULL_LITERAL) {
            this.match();
            return null;
        }
        String string = this.lexer.getText();
        if (this.schema.isValidEnumConstant(string)) {
            this.match();
            return string;
        }
        throw new GraphIOException(this.lexer.getLocation() + "Invalid enumeration constant '" + this.lexer.getText() + "'");
    }

    private void parseGraphElementClass(String string) throws GraphIOException {
        GraphElementClassData graphElementClassData = new GraphElementClassData();
        if (this.lookAhead == TgLexer.Token.ABSTRACT) {
            this.match();
            graphElementClassData.isAbstract = true;
        }
        if (this.lookAhead == TgLexer.Token.VERTEXCLASS) {
            this.match();
            String[] stringArray = this.matchAndSplitQualifiedName();
            graphElementClassData.packageName = stringArray[0];
            graphElementClassData.simpleName = stringArray[1];
            if (this.lookAhead == TgLexer.Token.COLON) {
                graphElementClassData.directSuperClasses = this.parseHierarchy();
            }
            this.vertexClassBuffer.get(string).add(graphElementClassData);
        } else if (this.lookAhead == TgLexer.Token.EDGECLASS) {
            this.match();
            String[] stringArray = this.matchAndSplitQualifiedName();
            graphElementClassData.packageName = stringArray[0];
            graphElementClassData.simpleName = stringArray[1];
            if (this.lookAhead == TgLexer.Token.COLON) {
                graphElementClassData.directSuperClasses = this.parseHierarchy();
            }
            this.match(TgLexer.Token.FROM);
            graphElementClassData.fromVertexClassName = this.matchQualifiedName();
            graphElementClassData.fromMultiplicity = this.parseMultiplicity();
            graphElementClassData.fromRoleName = this.parseRoleName();
            graphElementClassData.fromAggregation = this.parseAggregation();
            this.match(TgLexer.Token.TO);
            graphElementClassData.toVertexClassName = this.matchQualifiedName();
            graphElementClassData.toMultiplicity = this.parseMultiplicity();
            graphElementClassData.toRoleName = this.parseRoleName();
            graphElementClassData.toAggregation = this.parseAggregation();
            this.edgeClassBuffer.get(string).add(graphElementClassData);
        } else {
            throw new GraphIOException(this.lexer.getLocation() + "Unexpected symbol '" + this.lexer.getText() + "'");
        }
        if (this.lookAhead == TgLexer.Token.LCRL) {
            graphElementClassData.attributes = this.parseAttributes();
        }
        if (this.lookAhead == TgLexer.Token.LSQ) {
            graphElementClassData.constraints = this.parseConstraints();
        }
        this.match(TgLexer.Token.SEMICOLON);
    }

    private Set<Constraint> parseConstraints() throws GraphIOException {
        TreeSet<Constraint> treeSet = new TreeSet<Constraint>();
        do {
            this.match(TgLexer.Token.LSQ);
            String string = this.matchUtfString();
            String string2 = this.matchUtfString();
            String string3 = null;
            if (this.lookAhead != TgLexer.Token.RSQ) {
                string3 = this.matchUtfString();
            }
            treeSet.add(new ConstraintImpl(string, string2, string3));
            this.match(TgLexer.Token.RSQ);
        } while (this.lookAhead == TgLexer.Token.LSQ);
        return treeSet;
    }

    private VertexClass createVertexClass(GraphElementClassData graphElementClassData, GraphClass graphClass) throws GraphIOException {
        VertexClass vertexClass = graphClass.createVertexClass(graphElementClassData.getQualifiedName());
        vertexClass.setAbstract(graphElementClassData.isAbstract);
        this.addAttributes(graphElementClassData.attributes, vertexClass);
        for (Constraint constraint : graphElementClassData.constraints) {
            vertexClass.addConstraint(constraint);
        }
        return vertexClass;
    }

    private EdgeClass createEdgeClass(GraphElementClassData graphElementClassData, GraphClass graphClass) throws GraphIOException {
        EdgeClass edgeClass = graphClass.createEdgeClass(graphElementClassData.getQualifiedName(), graphClass.getVertexClass(graphElementClassData.fromVertexClassName), graphElementClassData.fromMultiplicity[0], graphElementClassData.fromMultiplicity[1], graphElementClassData.fromRoleName, graphElementClassData.fromAggregation, graphClass.getVertexClass(graphElementClassData.toVertexClassName), graphElementClassData.toMultiplicity[0], graphElementClassData.toMultiplicity[1], graphElementClassData.toRoleName, graphElementClassData.toAggregation);
        this.addAttributes(graphElementClassData.attributes, edgeClass);
        for (Constraint constraint : graphElementClassData.constraints) {
            edgeClass.addConstraint(constraint);
        }
        edgeClass.setAbstract(graphElementClassData.isAbstract);
        return edgeClass;
    }

    private int[] parseMultiplicity() throws GraphIOException {
        int n;
        int[] nArray = new int[2];
        this.match(TgLexer.Token.LBR);
        int n2 = this.matchInteger();
        if (n2 < 0) {
            throw new GraphIOException(this.lexer.getLocation() + "Minimum multiplicity '" + n2 + "' must be >=0");
        }
        this.match(TgLexer.Token.COMMA);
        if (this.lookAhead == TgLexer.Token.ASTERISK) {
            n = Integer.MAX_VALUE;
            this.match();
        } else {
            n = this.matchInteger();
            if (n < n2) {
                throw new GraphIOException(this.lexer.getLocation() + "Maximum multiplicity '" + n + "' must be * or >=" + n2);
            }
        }
        this.match(TgLexer.Token.RBR);
        nArray[0] = n2;
        nArray[1] = n;
        return nArray;
    }

    private String parseRoleName() throws GraphIOException {
        if (this.lookAhead == TgLexer.Token.ROLE) {
            this.match();
            String string = this.matchSimpleName(false);
            return string;
        }
        return "";
    }

    private AggregationKind parseAggregation() throws GraphIOException {
        if (this.lookAhead != TgLexer.Token.AGGREGATION) {
            return AggregationKind.NONE;
        }
        this.match();
        if (this.lookAhead == TgLexer.Token.NONE) {
            this.match();
            return AggregationKind.NONE;
        }
        if (this.lookAhead == TgLexer.Token.SHARED) {
            this.match();
            return AggregationKind.SHARED;
        }
        if (this.lookAhead == TgLexer.Token.COMPOSITE) {
            this.match();
            return AggregationKind.COMPOSITE;
        }
        throw new GraphIOException(this.lexer.getLocation() + "Invalid aggregation: expected 'none', 'shared', or 'composite', but found '" + this.lexer.getText() + "'");
    }

    private static boolean isValidIdentifier(String string, boolean bl) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (bl ? c < 'A' || c > 'Z' : c < 'a' || c > 'z') {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') continue;
            return false;
        }
        return true;
    }

    private List<ComponentData> parseRecordComponents() throws GraphIOException {
        ArrayList<ComponentData> arrayList = new ArrayList<ComponentData>();
        TreeSet<String> treeSet = new TreeSet<String>();
        this.match(TgLexer.Token.LBR);
        ComponentData componentData = new ComponentData();
        componentData.name = this.matchSimpleName(false);
        this.match(TgLexer.Token.COLON);
        componentData.domainDescription = this.parseAttrDomain();
        arrayList.add(componentData);
        treeSet.add(componentData.name);
        while (this.lookAhead == TgLexer.Token.COMMA) {
            this.match();
            componentData = new ComponentData();
            componentData.name = this.matchSimpleName(false);
            this.match(TgLexer.Token.COLON);
            componentData.domainDescription = this.parseAttrDomain();
            if (treeSet.contains(componentData.name)) {
                throw new GraphIOException(this.lexer.getLocation() + "Duplicate record component name '" + componentData.name + "'");
            }
            arrayList.add(componentData);
            treeSet.add(componentData.name);
        }
        this.match(TgLexer.Token.RBR);
        return arrayList;
    }

    private List<String> parseEnumConstants() throws GraphIOException {
        this.match(TgLexer.Token.LBR);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.matchEnumConstant();
        if (string == null) {
            throw new GraphIOException(this.lexer.getLocation() + "'" + NULL_LITERAL + "' can not be used as enumeration constant");
        }
        arrayList.add(string);
        while (this.lookAhead == TgLexer.Token.COMMA) {
            this.match();
            String string2 = this.matchEnumConstant();
            if (arrayList.contains(string2)) {
                throw new GraphIOException(this.lexer.getLocation() + "Duplicate enumeration constant name '" + (Object)((Object)this.lookAhead) + "'");
            }
            arrayList.add(string2);
        }
        this.match(TgLexer.Token.RBR);
        return arrayList;
    }

    private void buildVertexClassHierarchy() throws GraphIOException {
        for (Map.Entry<String, List<GraphElementClassData>> entry : this.vertexClassBuffer.entrySet()) {
            for (GraphElementClassData graphElementClassData : entry.getValue()) {
                Object t = this.schema.getAttributedElementClass(graphElementClassData.getQualifiedName());
                if (t == null) {
                    throw new GraphIOException("Undefined AttributedElementClass '" + graphElementClassData.getQualifiedName() + "'");
                }
                if (!(t instanceof VertexClass)) continue;
                VertexClass vertexClass = (VertexClass)t;
                for (String string : graphElementClassData.directSuperClasses) {
                    VertexClass vertexClass2 = vertexClass.getGraphClass().getVertexClass(string);
                    if (vertexClass2 == null) {
                        throw new GraphIOException("Undefined VertexClass '" + string + "'");
                    }
                    vertexClass.addSuperClass(vertexClass2);
                }
            }
        }
    }

    private void buildEdgeClassHierarchy() throws GraphIOException {
        for (Map.Entry<String, List<GraphElementClassData>> entry : this.edgeClassBuffer.entrySet()) {
            for (GraphElementClassData graphElementClassData : entry.getValue()) {
                Object t = this.schema.getAttributedElementClass(graphElementClassData.getQualifiedName());
                if (t == null) {
                    throw new GraphIOException("Undefined AttributedElementClass '" + graphElementClassData.getQualifiedName() + "'");
                }
                if (!(t instanceof EdgeClass)) {
                    throw new GraphIOException("Expected EdgeClass '" + graphElementClassData.getQualifiedName() + "', but it's a " + t.getSchemaClass().getSimpleName());
                }
                EdgeClass edgeClass = (EdgeClass)t;
                for (String string : graphElementClassData.directSuperClasses) {
                    EdgeClass edgeClass2 = edgeClass.getGraphClass().getEdgeClass(string);
                    if (edgeClass2 == null) {
                        throw new GraphIOException("Undefined EdgeClass '" + string + "'");
                    }
                    edgeClass.addSuperClass(edgeClass2);
                }
            }
        }
    }

    private void buildHierarchy() throws GraphIOException {
        this.buildVertexClassHierarchy();
        this.buildEdgeClassHierarchy();
    }

    public final boolean isNextToken(TgLexer.Token token) {
        return this.lookAhead == token;
    }

    public final void match() throws GraphIOException {
        this.lookAhead = this.lexer.nextToken();
    }

    public final void match(TgLexer.Token token) throws GraphIOException {
        if (this.lookAhead != token) {
            throw new GraphIOException(this.lexer.getLocation() + "Expected " + (Object)((Object)token) + " but found " + this.lexer.getText() + "'");
        }
        this.lookAhead = this.lexer.nextToken();
    }

    public final String matchGetText(TgLexer.Token token) throws GraphIOException {
        if (this.lookAhead == token) {
            String string = this.lexer.getText();
            this.lookAhead = this.lexer.nextToken();
            return string;
        }
        throw new GraphIOException(this.lexer.getLocation() + "Expected " + (Object)((Object)token) + " but found " + this.lexer.getText() + "'");
    }

    public final int matchInteger() throws GraphIOException {
        int n = this.lookAhead == TgLexer.Token.INT ? this.lexer.getInt() : 0;
        this.match(TgLexer.Token.INT);
        return n;
    }

    public final long matchLong() throws GraphIOException {
        long l = this.lookAhead == TgLexer.Token.INT ? this.lexer.getLong() : 0L;
        this.match(TgLexer.Token.INT);
        return l;
    }

    public final String matchSimpleName(boolean bl) throws GraphIOException {
        String string = this.lexer.getText();
        if (!GraphIO.isValidIdentifier(string, bl)) {
            throw new GraphIOException(this.lexer.getLocation() + "Invalid simple name '" + this.lexer.getText() + "'");
        }
        this.match();
        return string;
    }

    public final String matchQualifiedName() throws GraphIOException {
        return this.matchQualifiedName(false);
    }

    public final String matchQualifiedName(boolean bl) throws GraphIOException {
        String string = this.lexer.getText();
        int n = string.length();
        String string2 = null;
        if (n > 0 && string.charAt(n - 1) != '.') {
            int n2 = string.indexOf(46);
            if (n2 < 0) {
                if (GraphIO.isValidIdentifier(string, true) || bl && GraphIO.isValidIdentifier(string, false)) {
                    string2 = this.currentPackageName + string;
                }
            } else if (n2 == 0) {
                String string3 = string.substring(1);
                if (GraphIO.isValidIdentifier(string3, true) || bl && GraphIO.isValidIdentifier(string3, false)) {
                    string2 = string3;
                }
            } else {
                int n3 = 0;
                boolean bl2 = true;
                while (bl2 && n2 >= 0) {
                    String string4 = string.substring(n3, n2);
                    if (!(bl2 = bl2 && GraphIO.isValidIdentifier(string4, false))) continue;
                    n3 = n2 + 1;
                    n2 = string.indexOf(46, n3);
                }
                boolean bl3 = bl2 = bl2 && (GraphIO.isValidIdentifier(string.substring(n3), true) || bl && GraphIO.isValidIdentifier(string.substring(n3), false));
                if (bl2) {
                    string2 = string;
                }
            }
        }
        if (string2 == null) {
            throw new GraphIOException(this.lexer.getLocation() + "Invalid qualified name '" + string + "'");
        }
        this.match();
        return string2;
    }

    public final String[] matchAndSplitQualifiedName() throws GraphIOException {
        String string = this.matchQualifiedName();
        int n = string.lastIndexOf(46);
        return new String[]{n <= 0 ? "" : string.substring(0, n), string.substring(n + 1)};
    }

    public final String matchPackageName() throws GraphIOException {
        boolean bl;
        String string = this.lexer.getText();
        int n = string.length();
        boolean bl2 = bl = n > 0 && string.charAt(0) != '.' && string.charAt(n - 1) != '.';
        if (bl) {
            int n2 = 0;
            int n3 = string.indexOf(46);
            while (bl && n3 >= 0) {
                bl = bl && GraphIO.isValidIdentifier(string.substring(n2, n3), false);
                n2 = n3 + 1;
                n3 = string.indexOf(46, n2);
            }
            boolean bl3 = bl = bl && GraphIO.isValidIdentifier(string.substring(n2), false);
        }
        if (!bl) {
            throw new GraphIOException(this.lexer.getLocation() + "Invalid package name '" + string + "'");
        }
        this.match();
        return string;
    }

    private final String toQNameString(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return string2;
        }
        return string + "." + string2;
    }

    public final String matchUtfString() throws GraphIOException {
        if (this.lookAhead == TgLexer.Token.NULL_LITERAL) {
            this.match();
            return null;
        }
        String string = this.lookAhead == TgLexer.Token.STRING ? this.lexer.getText() : null;
        this.match(TgLexer.Token.STRING);
        String string2 = this.stringPool.get(string);
        if (string2 == null) {
            this.stringPool.put(string, string);
        } else {
            string = string2;
        }
        return string;
    }

    public final boolean matchBoolean() throws GraphIOException {
        if (this.lookAhead != TgLexer.Token.TRUE_LITERAL && this.lookAhead != TgLexer.Token.FALSE_LITERAL) {
            throw new GraphIOException(this.lexer.getLocation() + "Expected a boolean constant ('f' or 't') but found '" + this.lexer.getText() + "'");
        }
        boolean bl = this.lookAhead == TgLexer.Token.TRUE_LITERAL;
        this.match();
        return bl;
    }

    private GraphBaseImpl graph(ProgressFunction progressFunction) throws GraphIOException {
        this.currentPackageName = "";
        this.match(TgLexer.Token.GRAPH);
        String string = this.matchUtfString();
        long l = this.matchLong();
        this.gcName = this.matchSimpleName(true);
        if (!this.schema.getGraphClass().getQualifiedName().equals(this.gcName)) {
            throw new GraphIOException(this.lexer.getLocation() + "Graph Class " + this.gcName + "does not exist in " + this.schema.getQualifiedName());
        }
        this.match(TgLexer.Token.LBR);
        int n = this.matchInteger();
        int n2 = this.matchInteger();
        int n3 = this.matchInteger();
        int n4 = this.matchInteger();
        this.match(TgLexer.Token.RBR);
        if (n3 > n) {
            throw new GraphIOException(this.lexer.getLocation() + "Number of vertices in graph (" + n3 + ") exceeds maximum number of vertices (" + n + ")");
        }
        if (n4 > n2) {
            throw new GraphIOException(this.lexer.getLocation() + "Number of edges in graph (" + n4 + ") exceeds maximum number of edges (" + n2 + ")");
        }
        this.edgeIn = new Vertex[n2 + 1];
        this.edgeOut = new Vertex[n2 + 1];
        this.firstIncidence = new int[n + 1];
        this.nextIncidence = new int[2 * n2 + 1];
        this.edgeOffset = n2;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 1L;
        if (progressFunction != null) {
            progressFunction.init(n3 + n4);
            l4 = progressFunction.getUpdateInterval();
        }
        GraphBaseImpl graphBaseImpl = (GraphBaseImpl)this.graphFactory.createGraph(this.schema.getGraphClass(), string, n, n2);
        graphBaseImpl.setLoading(true);
        graphBaseImpl.readAttributeValues(this);
        this.match(TgLexer.Token.SEMICOLON);
        int n5 = 1;
        while (n5 <= n3) {
            if (this.lookAhead == TgLexer.Token.PACKAGE) {
                this.parsePackage();
                continue;
            }
            this.vertexDesc(graphBaseImpl);
            if (progressFunction != null) {
                ++l2;
                if (++l3 == l4) {
                    progressFunction.progress(l2);
                    l3 = 0L;
                }
            }
            ++n5;
        }
        int n6 = 1;
        while (n6 <= n4) {
            if (this.lookAhead == TgLexer.Token.PACKAGE) {
                this.parsePackage();
                continue;
            }
            this.edgeDesc(graphBaseImpl);
            if (progressFunction != null) {
                ++l2;
                if (++l3 == l4) {
                    progressFunction.progress(l2);
                    l3 = 0L;
                }
            }
            ++n6;
        }
        graphBaseImpl.setGraphVersion(l);
        graphBaseImpl.internalLoadingCompleted(this.firstIncidence, this.nextIncidence);
        this.firstIncidence = null;
        this.nextIncidence = null;
        graphBaseImpl.setLoading(false);
        if (progressFunction != null) {
            progressFunction.finished();
        }
        graphBaseImpl.loadingCompleted();
        return graphBaseImpl;
    }

    public final double matchDouble() throws GraphIOException {
        try {
            double d = Double.parseDouble(this.lexer.getText());
            this.match();
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new GraphIOException(this.lexer.getLocation() + "Expected double value but found '" + this.lexer.getText() + "'", numberFormatException);
        }
    }

    private void vertexDesc(Graph graph) throws GraphIOException {
        int n = this.vId();
        String string = this.matchQualifiedName();
        VertexClass vertexClass = (VertexClass)this.schema.getAttributedElementClass(string);
        Object v = this.graphFactory.createVertex(vertexClass, n, graph);
        this.parseIncidentEdges((Vertex)v);
        v.readAttributeValues(this);
        this.match(TgLexer.Token.SEMICOLON);
    }

    private void edgeDesc(Graph graph) throws GraphIOException {
        int n = this.eId();
        String string = this.matchQualifiedName();
        EdgeClass edgeClass = (EdgeClass)this.schema.getAttributedElementClass(string);
        Object e = this.graphFactory.createEdge(edgeClass, n, graph, this.edgeOut[n], this.edgeIn[n]);
        e.readAttributeValues(this);
        this.match(TgLexer.Token.SEMICOLON);
    }

    private int eId() throws GraphIOException {
        int n = this.matchInteger();
        if (n == 0) {
            throw new GraphIOException(this.lexer.getLocation() + "Invalid edge id " + n + ".");
        }
        return n;
    }

    private int vId() throws GraphIOException {
        int n = this.matchInteger();
        if (n <= 0) {
            throw new GraphIOException(this.lexer.getLocation() + "Invalid vertex id " + n + ".");
        }
        return n;
    }

    private void parseIncidentEdges(Vertex vertex) throws GraphIOException {
        int n = 0;
        int n2 = 0;
        int n3 = vertex.getId();
        this.match(TgLexer.Token.LT);
        if (this.lookAhead != TgLexer.Token.GT) {
            this.firstIncidence[n3] = n = this.eId();
            if (n < 0) {
                this.edgeIn[-n] = vertex;
            } else {
                this.edgeOut[n] = vertex;
            }
        }
        while (this.lookAhead != TgLexer.Token.GT) {
            n2 = n;
            this.nextIncidence[this.edgeOffset + n2] = n = this.eId();
            if (n < 0) {
                this.edgeIn[-n] = vertex;
                continue;
            }
            this.edgeOut[n] = vertex;
        }
        this.match();
    }

    public static String toUtfString(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("\"");
        CharBuffer charBuffer = CharBuffer.wrap(string);
        block12: while (charBuffer.hasRemaining()) {
            char c = charBuffer.get();
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block12;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block12;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block12;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block12;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block12;
                }
            }
            if (c >= ' ' && c <= '\u007f') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append("\\u");
            String string2 = Integer.toHexString(c);
            switch (string2.length()) {
                case 1: {
                    stringBuilder.append("000");
                    break;
                }
                case 2: {
                    stringBuilder.append("00");
                    break;
                }
                case 3: {
                    stringBuilder.append("0");
                }
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private void sortRecordDomains() throws GraphIOException {
        ArrayList<RecordDomainData> arrayList = new ArrayList<RecordDomainData>();
        boolean bl = true;
        while (!this.recordDomainBuffer.isEmpty()) {
            Iterator<RecordDomainData> iterator = this.recordDomainBuffer.iterator();
            while (iterator.hasNext()) {
                RecordDomainData recordDomainData = iterator.next();
                bl = true;
                for (ComponentData componentData : recordDomainData.components) {
                    for (String string : componentData.domainDescription) {
                        String string2;
                        if (string.equals("String") || string.equals("Integer") || string.equals("Boolean") || string.equals("Long") || string.equals("Double") || string.equals("Set<") || string.equals("List<") || string.equals("Map<")) continue;
                        bl = false;
                        for (RecordDomainData recordDomainData2 : arrayList) {
                            string2 = this.toQNameString(recordDomainData2.packageName, recordDomainData2.simpleName);
                            if (!string.equals(string2)) continue;
                            bl = true;
                            break;
                        }
                        for (EnumDomainData enumDomainData : this.enumDomainBuffer) {
                            string2 = this.toQNameString(enumDomainData.packageName, enumDomainData.simpleName);
                            if (!string.equals(string2)) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        boolean bl2 = false;
                        for (RecordDomainData recordDomainData3 : this.recordDomainBuffer) {
                            string2 = this.toQNameString(recordDomainData3.packageName, recordDomainData3.simpleName);
                            if (!string2.equals(string)) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) break;
                        throw new GraphIOException("Domain " + string + " does not exist");
                    }
                    if (bl) continue;
                    break;
                }
                if (!bl) continue;
                arrayList.add(recordDomainData);
                iterator.remove();
            }
        }
        this.recordDomainBuffer = arrayList;
    }

    private void sortVertexClasses() throws GraphIOException {
        TreeSet<String> treeSet = new TreeSet<String>();
        List<GraphElementClassData> list = this.vertexClassBuffer.get(this.graphClass.name);
        ArrayList<GraphElementClassData> arrayList = new ArrayList<GraphElementClassData>();
        while (!list.isEmpty()) {
            Iterator<GraphElementClassData> iterator = list.iterator();
            while (iterator.hasNext()) {
                GraphElementClassData graphElementClassData = iterator.next();
                if (treeSet.containsAll(graphElementClassData.directSuperClasses)) {
                    treeSet.add(graphElementClassData.getQualifiedName());
                    arrayList.add(graphElementClassData);
                    iterator.remove();
                    continue;
                }
                for (String string : graphElementClassData.directSuperClasses) {
                    if (treeSet.contains(string)) continue;
                    boolean bl = false;
                    for (GraphElementClassData graphElementClassData2 : list) {
                        if (!graphElementClassData2.getQualifiedName().equals(string)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    throw new GraphIOException("VertexClass " + string + " does not exist");
                }
            }
        }
        this.vertexClassBuffer.put(this.graphClass.name, arrayList);
    }

    private void sortEdgeClasses() throws GraphIOException {
        TreeSet<String> treeSet = new TreeSet<String>();
        List<GraphElementClassData> list = this.edgeClassBuffer.get(this.graphClass.name);
        ArrayList<GraphElementClassData> arrayList = new ArrayList<GraphElementClassData>();
        while (!list.isEmpty()) {
            Iterator<GraphElementClassData> iterator = list.iterator();
            while (iterator.hasNext()) {
                GraphElementClassData graphElementClassData = iterator.next();
                if (treeSet.containsAll(graphElementClassData.directSuperClasses)) {
                    treeSet.add(graphElementClassData.getQualifiedName());
                    arrayList.add(graphElementClassData);
                    iterator.remove();
                    continue;
                }
                for (String string : graphElementClassData.directSuperClasses) {
                    if (treeSet.contains(string)) continue;
                    boolean bl = false;
                    for (GraphElementClassData graphElementClassData2 : list) {
                        if (!graphElementClassData2.getQualifiedName().equals(string)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    throw new GraphIOException("EdgeClass " + string + " does not exist");
                }
            }
        }
        this.edgeClassBuffer.put(this.graphClass.name, arrayList);
    }

    private void checkFromToVertexClasses() throws GraphIOException {
        for (Map.Entry<String, List<GraphElementClassData>> entry : this.edgeClassBuffer.entrySet()) {
            for (GraphElementClassData graphElementClassData : entry.getValue()) {
                boolean bl = false;
                boolean bl2 = false;
                for (Map.Entry<String, List<GraphElementClassData>> entry2 : this.vertexClassBuffer.entrySet()) {
                    for (GraphElementClassData graphElementClassData2 : entry2.getValue()) {
                        if (graphElementClassData.fromVertexClassName.equals(graphElementClassData2.getQualifiedName())) {
                            bl = true;
                        }
                        if (graphElementClassData.toVertexClassName.equals(graphElementClassData2.getQualifiedName())) {
                            bl2 = true;
                        }
                        if (!bl || !bl2) continue;
                        break;
                    }
                    if (!bl || !bl2) continue;
                    break;
                }
                if (!bl) {
                    throw new GraphIOException("From-VertexClass " + graphElementClassData.fromVertexClassName + " at EdgeClass " + graphElementClassData.getQualifiedName() + " does not exist.");
                }
                if (bl2) continue;
                throw new GraphIOException("To-VertexClass " + graphElementClassData.toVertexClassName + " at EdgeClass " + graphElementClassData.getQualifiedName() + " does not exist.");
            }
        }
    }

    private class GraphElementClassData {
        String simpleName;
        String packageName;
        boolean isAbstract = false;
        List<String> directSuperClasses = new LinkedList<String>();
        String fromVertexClassName;
        int[] fromMultiplicity = new int[]{1, Integer.MAX_VALUE};
        String fromRoleName = "";
        AggregationKind fromAggregation;
        String toVertexClassName;
        int[] toMultiplicity = new int[]{1, Integer.MAX_VALUE};
        String toRoleName = "";
        AggregationKind toAggregation;
        List<AttributeData> attributes = new ArrayList<AttributeData>();
        Set<Constraint> constraints = new HashSet<Constraint>(1);

        private GraphElementClassData() {
        }

        String getQualifiedName() {
            return GraphIO.this.toQNameString(this.packageName, this.simpleName);
        }
    }

    private static class GraphClassData {
        Set<Constraint> constraints = new HashSet<Constraint>(1);
        String name;
        boolean isAbstract = false;
        List<AttributeData> attributes = new ArrayList<AttributeData>();

        private GraphClassData() {
        }
    }

    private static class AttributeData {
        String name;
        List<String> domainDescription;
        String defaultValue;

        private AttributeData() {
        }
    }

    private static class ComponentData {
        String name;
        List<String> domainDescription;

        private ComponentData() {
        }
    }

    private static class RecordDomainData {
        String simpleName;
        String packageName;
        List<ComponentData> components;

        RecordDomainData(String string, String string2, List<ComponentData> list) {
            this.packageName = string;
            this.simpleName = string2;
            this.components = list;
        }
    }

    private static class EnumDomainData {
        String simpleName;
        String packageName;
        List<String> enumConstants;

        EnumDomainData(String string, String string2, List<String> list) {
            this.packageName = string;
            this.simpleName = string2;
            this.enumConstants = list;
        }
    }

    public static class TGFilenameFilter
    extends FileFilter
    implements FilenameFilter {
        private static TGFilenameFilter instance;

        private TGFilenameFilter() {
        }

        public static TGFilenameFilter instance() {
            if (instance == null) {
                instance = new TGFilenameFilter();
            }
            return instance;
        }

        @Override
        public boolean accept(File file, String string) {
            return string.matches(".+\\.[Tt][Gg](\\.[Gg][Zz])?$");
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || this.accept(file, file.getName());
        }

        @Override
        public String getDescription() {
            return "TG Files";
        }
    }
}

