/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.xml2tg;

import de.uni_koblenz.ist.utilities.xml.XmlProcessor;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.TemporaryVertex;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Attribute;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Element;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.References;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Text;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLGraph;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLSchema;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;

public class Xml2Tg
extends XmlProcessor {
    private Set<String> idAttributes = new HashSet<String>();
    private Set<String> idRefAttributes = new HashSet<String>();
    private Set<String> idRefsAttributes = new HashSet<String>();
    private boolean ignoreCharacters;
    private XMLGraph xmlGraph;
    private Map<String, Vertex> idMap = new HashMap<String, Vertex>();
    private Stack<Element> elementStack = new Stack();
    private boolean finished;
    private String fileName;

    public XMLGraph getXmlGraph() {
        if (!this.finished) {
            throw new IllegalStateException("getXmlGraph can only be called after the XML document was fully processed");
        }
        return this.xmlGraph;
    }

    public Element getElementById(String string) {
        if (!this.finished) {
            throw new IllegalStateException("getElementById can only be called after the XML document was fully processed");
        }
        return (Element)this.idMap.get(string);
    }

    public void addIdAttributes(String ... stringArray) {
        for (String string : stringArray) {
            if ((string = string.trim()).isEmpty()) continue;
            this.idAttributes.add(string);
        }
    }

    public void addIdRefAttributes(String ... stringArray) {
        for (String string : stringArray) {
            if ((string = string.trim()).isEmpty()) continue;
            this.idRefAttributes.add(string);
        }
    }

    public void addIdRefsAttributes(String ... stringArray) {
        for (String string : stringArray) {
            if ((string = string.trim()).isEmpty()) continue;
            this.idRefsAttributes.add(string);
        }
    }

    public boolean isIgnoreCharacters() {
        return this.ignoreCharacters;
    }

    public void setIgnoreCharacters(boolean bl) {
        this.ignoreCharacters = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void startElement(String string) throws XMLStreamException {
        Object object2;
        Element element = null;
        Set<String> set = this.getAttributeNames();
        for (String string2 : set) {
            if (!this.idAttributes.contains("*/" + string2) && !this.idAttributes.contains(string + "/" + string2)) continue;
            object2 = this.getAttribute(string2);
            Vertex object = this.idMap.get(object2);
            element = object != null ? (object.isTemporary() ? (Element)((TemporaryVertex)object).bless(Element.VC) : (Element)object) : this.xmlGraph.createElement();
            this.idMap.put((String)object2, element);
        }
        if (element == null) {
            element = this.xmlGraph.createElement();
        }
        assert (element != null);
        element.set_name(string);
        if (this.getNestingDepth() > 1) {
            this.elementStack.peek().add_children(element);
        }
        this.elementStack.push(element);
        for (String string2 : set) {
            object2 = this.xmlGraph.createAttribute();
            object2.set_name(string2);
            object2.set_value(this.getAttribute(string2));
            element.add_attributes((Attribute)object2);
            if (this.idRefAttributes.contains("*/" + string2) || this.idRefAttributes.contains(string + "/" + string2)) {
                void var7_11;
                Vertex vertex = this.idMap.get(object2.get_value());
                if (vertex == null) {
                    TemporaryVertex temporaryVertex = this.xmlGraph.createTemporaryVertex();
                    this.idMap.put(object2.get_value(), temporaryVertex);
                }
                if (var7_11.isTemporary()) {
                    this.xmlGraph.createTemporaryEdge(References.EC, (Vertex)object2, (Vertex)var7_11);
                    continue;
                }
                this.xmlGraph.createEdge(References.EC, (Vertex)object2, (Vertex)var7_11);
                continue;
            }
            if (!this.idRefsAttributes.contains("*/" + string2) && !this.idRefsAttributes.contains(string + "/" + string2)) continue;
            for (String string3 : object2.get_value().split("\\s+")) {
                if ((string3 = string3.trim()).isEmpty()) continue;
                Vertex vertex = this.idMap.get(string3);
                if (vertex == null) {
                    vertex = this.xmlGraph.createTemporaryVertex();
                    this.idMap.put(string3, vertex);
                }
                if (vertex.isTemporary()) {
                    this.xmlGraph.createTemporaryEdge(References.EC, (Vertex)object2, vertex);
                    continue;
                }
                this.xmlGraph.createEdge(References.EC, (Vertex)object2, vertex);
            }
        }
    }

    @Override
    protected void characters(String string) {
        if (this.ignoreCharacters) {
            return;
        }
        super.characters(string);
        Element element = this.elementStack.peek();
        assert (element != null);
        Text text = this.xmlGraph.createText();
        text.set_content(string);
        element.add_texts(text);
    }

    @Override
    protected void endElement(String string, StringBuilder stringBuilder) throws XMLStreamException {
        Element element = this.elementStack.pop();
        assert (element != null);
        assert (element.get_name().equals(string));
    }

    @Override
    public void process(String string) throws FileNotFoundException, XMLStreamException {
        this.fileName = string;
        super.process(string);
    }

    @Override
    protected void startDocument() throws XMLStreamException {
        this.xmlGraph = XMLSchema.instance().createXMLGraph(ImplementationType.STANDARD, this.fileName, 100, 100);
        this.idMap.clear();
        this.elementStack.clear();
        this.finished = false;
    }

    @Override
    protected void endDocument() throws XMLStreamException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.elementStack.size() > 0) {
            throw new RuntimeException("XML document is malformed");
        }
        for (String string : this.idMap.keySet()) {
            if (!this.idMap.get(string).isTemporary()) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            string = "There are undefined references in the XML document: ";
            for (String string2 : arrayList) {
                stringBuilder.append(string).append(string2);
                string = ", ";
            }
            throw new RuntimeException(stringBuilder.toString());
        }
        this.finished = true;
    }
}

