/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2graphml;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.utilities.tg2whatever.Tg2Whatever;
import java.io.PrintStream;
import java.util.Map;

public class Tg2GraphML
extends Tg2Whatever {
    private static final String NODE_GRAPHICS_ATTR = "nodeGraphics";
    private static final String EDGE_GRAPHICS_ATTR = "edgeGraphics";

    private String id(GraphElement<?, ?> graphElement) {
        return (graphElement instanceof Vertex ? "v" : "e") + graphElement.getId();
    }

    private String label(GraphElement<?, ?> graphElement) {
        return this.id(graphElement) + ": " + ((GraphElementClass)graphElement.getAttributedElementClass()).getSimpleName();
    }

    private String attrs(GraphElement<?, ?> graphElement) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        for (Attribute attribute : ((GraphElementClass)graphElement.getAttributedElementClass()).getAttributeList()) {
            stringBuilder.append(attribute.getName());
            stringBuilder.append(" = ");
            stringBuilder.append(this.formatAttrValue(graphElement.getAttribute(attribute.getName())));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private String formatAttrValue(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            stringBuilder.append('\"');
            stringBuilder.append(object);
            stringBuilder.append('\"');
        } else if (object instanceof Map) {
            Map map = (Map)object;
            stringBuilder.append("{");
            boolean bl = true;
            for (Map.Entry entry : map.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.formatAttrValue(entry.getKey()));
                stringBuilder.append(" -&gt; ");
                stringBuilder.append(this.formatAttrValue(entry.getValue()));
            }
            stringBuilder.append("}");
        } else if (object instanceof Record) {
            Record record = (Record)object;
            stringBuilder.append("[");
            boolean bl = true;
            for (String string : record.getComponentNames()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
                stringBuilder.append(" = ");
                stringBuilder.append(this.formatAttrValue(record.getComponent(string)));
            }
            stringBuilder.append("]");
        } else {
            return object.toString();
        }
        return stringBuilder.toString();
    }

    @Override
    protected void graphStart(PrintStream printStream) {
        if (this.isReversedEdges()) {
            throw new RuntimeException("Reversed edges not supported.");
        }
        printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printStream.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:y=\"http://www.yworks.com/xml/graphml\" xmlns:yed=\"http://www.yworks.com/xml/yed/3\" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://www.yworks.com/xml/schema/graphml/1.1/ygraphml.xsd\">");
        printStream.printf("<key for=\"node\" id=\"%s\" yfiles.type=\"nodegraphics\"/>\n", NODE_GRAPHICS_ATTR);
        printStream.printf("<key for=\"edge\" id=\"%s\" yfiles.type=\"edgegraphics\"/>\n", EDGE_GRAPHICS_ATTR);
        printStream.printf(" <graph id=\"%s\" edgedefault=\"directed\">\n", this.graph.getId());
    }

    @Override
    protected void graphEnd(PrintStream printStream) {
        printStream.println(" </graph>");
        printStream.println("</graphml>");
    }

    @Override
    protected void printVertex(PrintStream printStream, Vertex vertex) {
        printStream.printf("  <node id=\"%s\">\n", this.id(vertex));
        printStream.printf("   <data key=\"%s\">\n", NODE_GRAPHICS_ATTR);
        printStream.println("    <y:GenericNode configuration=\"com.yworks.entityRelationship.big_entity\">");
        printStream.printf("     <y:NodeLabel alignment=\"center\" autoSizePolicy=\"content\" backgroundColor=\"#B7C9E3\" configuration=\"com.yworks.entityRelationship.label.name\" fontFamily=\"Dialog\" fontSize=\"12\" fontStyle=\"plain\" textColor=\"#000000\" underlinedText=\"true\" visible=\"true\"  modelName=\"internal\" modelPosition=\"t\">%s</y:NodeLabel>\n", this.label(vertex));
        if (vertex.getAttributedElementClass().hasAttributes()) {
            printStream.printf("     <y:NodeLabel alignment=\"left\" autoSizePolicy=\"content\" configuration=\"com.yworks.entityRelationship.label.attributes\" fontFamily=\"Dialog\" fontSize=\"12\" fontStyle=\"plain\" hasBackgroundColor=\"false\" hasLineColor=\"false\" modelName=\"internal\" modelPosition=\"bl\" textColor=\"#000000\" visible=\"true\">%s</y:NodeLabel>", this.attrs(vertex));
        }
        printStream.println("    </y:GenericNode>");
        printStream.println("   </data>");
        printStream.println("  </node>");
    }

    @Override
    protected void printEdge(PrintStream printStream, Edge edge) {
        printStream.printf("    <edge id=\"%s\" source=\"%s\" target=\"%s\">\n", this.id(edge), this.id(edge.getAlpha()), this.id(edge.getOmega()));
        printStream.printf("   <data key=\"%s\">\n", EDGE_GRAPHICS_ATTR);
        printStream.println("    <y:PolyLineEdge>");
        printStream.println("     <y:LineStyle color=\"#000000\" type=\"line\" width=\"1.0\"/>");
        printStream.println("     <y:Arrows source=\"none\" target=\"standard\"/>");
        printStream.printf("     <y:EdgeLabel alignment=\"center\" distance=\"2.0\" fontFamily=\"Dialog\" fontSize=\"12\" fontStyle=\"plain\" hasBackgroundColor=\"false\" hasLineColor=\"false\" modelName=\"centered\" modelPosition=\"center\" ratio=\"0.5\" underlinedText=\"true\" textColor=\"#000000\" visible=\"true\">%s</y:EdgeLabel>", this.label(edge));
        if (this.edgeAttributes) {
            printStream.printf("     <y:EdgeLabel alignment=\"center\" distance=\"2.0\" fontFamily=\"Dialog\" fontSize=\"12\" fontStyle=\"plain\" hasBackgroundColor=\"false\" hasLineColor=\"false\" modelName=\"centered\" modelPosition=\"center\" ratio=\"0.5\" textColor=\"#000000\" visible=\"true\">%s</y:EdgeLabel>", this.attrs(edge));
        }
        printStream.println("    </y:PolyLineEdge>");
        printStream.println("   </data>");
        printStream.println("  </edge>");
    }

    @Override
    protected String stringQuote(String string) {
        return string;
    }
}

