/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.exception.SchemaClassAccessException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.DomainImpl;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.IOException;
import java.util.List;
import org.pcollections.PVector;

public final class EnumDomainImpl
extends DomainImpl
implements EnumDomain {
    private PVector<String> constants = JGraLab.vector();
    private Class<? extends Object> schemaClass;

    EnumDomainImpl(String string, PackageImpl packageImpl, List<String> list) {
        super(string, packageImpl);
        for (String string2 : list) {
            this.addConst(string2);
        }
    }

    @Override
    public void addConst(String string) {
        SchemaImpl schemaImpl = (SchemaImpl)this.getSchema();
        schemaImpl.assertNotFinished();
        if (this.constants.contains(string)) {
            throw new SchemaException("Try to add duplicate constant '" + string + "' to EnumDomain" + this.getQualifiedName());
        }
        if (!schemaImpl.isValidEnumConstant(string)) {
            throw new SchemaException(string + " is not a valid enumeration constant.");
        }
        this.constants = this.constants.plus(string);
    }

    @Override
    public PVector<String> getConsts() {
        return this.constants;
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String string) {
        return string + "." + this.getQualifiedName();
    }

    @Override
    public String getJavaClassName(String string) {
        return this.getJavaAttributeImplementationTypeName(string);
    }

    @Override
    public CodeBlock getReadMethod(String string, String string2, String string3) {
        return new CodeSnippet(string2 + " = " + this.getJavaAttributeImplementationTypeName(string) + ".valueOfPermitNull(" + string3 + ".matchEnumConstant());");
    }

    @Override
    public String getTGTypeName(Package package_) {
        return this.getQualifiedName(package_);
    }

    @Override
    public CodeBlock getWriteMethod(String string, String string2, String string3) {
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("if (" + string2 + " != null) {");
        codeSnippet.add("\t" + string3 + ".writeIdentifier(" + string2 + ".toString());");
        codeSnippet.add("} else {");
        codeSnippet.add("\t" + string3 + ".writeIdentifier(GraphIO.NULL_LITERAL);");
        codeSnippet.add("}");
        return codeSnippet;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("domain Enum " + this.getQualifiedName() + " (");
        String string = "";
        int n = 0;
        for (String string2 : this.constants) {
            stringBuilder.append(string + n++ + ": " + string2);
            string = ", ";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public CodeBlock getTransactionReadMethod(String string, String string2, String string3) {
        return new CodeSnippet(this.getJavaAttributeImplementationTypeName(string) + " " + string2 + " = " + this.getJavaAttributeImplementationTypeName(string) + ".valueOfPermitNull(" + string3 + ".matchEnumConstant());");
    }

    @Override
    public CodeBlock getTransactionWriteMethod(String string, String string2, String string3) {
        return this.getWriteMethod(string, "get" + CodeGenerator.camelCase(string2) + "()", string3);
    }

    @Override
    public String getTransactionJavaAttributeImplementationTypeName(String string) {
        return this.getJavaAttributeImplementationTypeName(string);
    }

    @Override
    public String getTransactionJavaClassName(String string) {
        return this.getJavaClassName(string);
    }

    @Override
    public String getVersionedClass(String string) {
        return "de.uni_koblenz.jgralab.impl.trans.VersionedReferenceImpl<" + this.getTransactionJavaAttributeImplementationTypeName(string) + ">";
    }

    @Override
    public String getInitialValue() {
        return "null";
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Class<? extends Object> getSchemaClass() {
        if (this.schemaClass == null) {
            String string = this.getSchema().getPackagePrefix() + "." + this.getQualifiedName();
            try {
                this.schemaClass = Class.forName(string, true, SchemaClassManager.instance(this.getSchema().getQualifiedName()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SchemaClassAccessException("Can't load (generated) schema class for EnumDomain '" + this.getQualifiedName() + "'", classNotFoundException);
            }
        }
        return this.schemaClass;
    }

    @Override
    public Object parseGenericAttribute(GraphIO graphIO) throws GraphIOException {
        String string = graphIO.matchEnumConstant();
        return string;
    }

    @Override
    public void serializeGenericAttribute(GraphIO graphIO, Object object) throws IOException {
        if (object != null) {
            graphIO.writeIdentifier((String)object);
        } else {
            graphIO.writeIdentifier(GraphIO.NULL_LITERAL);
        }
    }

    @Override
    public void setQualifiedName(String string) {
        if (this.qualifiedName.equals(string)) {
            return;
        }
        if (this.schema.knows(string)) {
            throw new SchemaException(string + " is already known to the schema.");
        }
        String[] stringArray = SchemaImpl.splitQualifiedName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (!NamedElementImpl.ATTRELEM_OR_NOCOLLDOMAIN_PATTERN.matcher(string3).matches()) {
            throw new SchemaException("Invalid enum domain name '" + string3 + "'.");
        }
        this.unregister();
        this.qualifiedName = string;
        this.simpleName = string3;
        this.parentPackage = this.schema.createPackageWithParents(string2);
        this.register();
    }

    @Override
    public void delete() {
        this.schema.assertNotFinished();
        if (!this.attributes.isEmpty()) {
            throw new SchemaException("Cannot delete enum domain that is still used by attributes: " + this.attributes);
        }
        this.parentPackage.domains.remove(this.simpleName);
        this.schema.namedElements.remove(this.qualifiedName);
        this.schema.domains.remove(this.qualifiedName);
    }

    @Override
    public boolean isConformValue(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Enum) {
            return this.getSchemaClass().isInstance(object);
        }
        return object instanceof String && this.getConsts().contains(object);
    }
}

