/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.TgTokenRecognizer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class TgLexer {
    private InputStream in;
    private String filename;
    private int line;
    private int la;
    private int putBackChar;
    private static TgTokenRecognizer rec = new TgTokenRecognizer();
    private static final int TEXT_SIZE = 1024;
    private char[] text;
    private int textPos;
    private StringBuilder textBuilder;
    private static final int BUFFER_SIZE = 65536;
    private byte[] buffer;
    private int bufferSize;
    private int bufferPos;

    public TgLexer(InputStream inputStream, String string) throws GraphIOException {
        this.filename = string;
        this.in = inputStream;
        this.buffer = new byte[65536];
        this.text = new char[1024];
        this.putBackChar = -1;
        this.line = 1;
        this.la = this.read();
    }

    public TgLexer(String string) throws GraphIOException {
        this.buffer = string.getBytes(Charset.forName("US-ASCII"));
        this.bufferSize = this.buffer.length;
        this.text = new char[1024];
        this.putBackChar = -1;
        this.line = 1;
        this.la = this.read();
    }

    public String getLocation() {
        if (this.filename == null) {
            return "line " + this.getLine() + ": ";
        }
        return this.getFilename() + " line " + this.getLine() + ": ";
    }

    public int getLine() {
        return this.line;
    }

    public String getFilename() {
        return this.filename;
    }

    private final int read() throws GraphIOException {
        int n;
        if (this.putBackChar >= 0) {
            n = this.putBackChar;
            this.putBackChar = -1;
        } else if (this.bufferPos < this.bufferSize) {
            n = this.buffer[this.bufferPos++];
        } else {
            if (this.in != null) {
                try {
                    this.bufferSize = this.in.read(this.buffer);
                }
                catch (IOException iOException) {
                    throw new GraphIOException(this.getLocation() + "Caught IOException", iOException);
                }
                this.bufferPos = 0;
            }
            n = this.bufferPos < this.bufferSize ? this.buffer[this.bufferPos++] : -1;
        }
        if (n == 10) {
            ++this.line;
        }
        return n;
    }

    public static final boolean isWs(int n) {
        return n == 32 || n == 10 || n == 13 || n == 9;
    }

    public static final boolean isSeparator(int n) {
        return n == 59 || n == 60 || n == 62 || n == 40 || n == 41 || n == 123 || n == 125 || n == 58 || n == 91 || n == 93 || n == 44 || n == 61;
    }

    public static final boolean isDelimiter(int n) {
        return n == 32 || n == 59 || n == 10 || n == 13 || n == 60 || n == 62 || n == 34 || n == 40 || n == 41 || n == 123 || n == 125 || n == 58 || n == 91 || n == 93 || n == 44 || n == 61 || n == 9 || n == -1;
    }

    /*
     * Unable to fully structure code
     */
    public final Token nextToken() throws GraphIOException {
        block10: {
            block0: while (true) {
                if (TgLexer.isWs(this.la)) {
                    this.la = this.read();
                    continue;
                }
                if (this.la != 47) break block10;
                this.la = this.read();
                if (this.la < 0 || this.la != 47) break;
                while (true) {
                    if (this.la >= 0 && this.la != 10) ** break;
                    continue block0;
                    this.la = this.read();
                }
                break;
            }
            this.putBackChar = this.la;
            if (this.la == 10) {
                --this.line;
            }
            this.la = 47;
        }
        this.textPos = 0;
        this.textBuilder = null;
        TgLexer.rec.reset();
        if (TgLexer.isSeparator(this.la)) {
            TgLexer.rec.next(this.la);
            this.append(this.la);
            this.la = this.read();
        } else {
            if (this.la == 34) {
                this.readUtfString();
                return Token.STRING;
            }
            if (this.la >= 0) {
                while (!TgLexer.isDelimiter(this.la)) {
                    TgLexer.rec.next(this.la);
                    this.append(this.la);
                    this.la = this.read();
                }
            } else {
                return Token.EOF;
            }
        }
        return TgLexer.rec.getToken();
    }

    private final void append(int n) {
        if (this.textPos < 1024) {
            this.text[this.textPos++] = (char)n;
        } else {
            if (this.textBuilder == null) {
                this.textBuilder = new StringBuilder();
            }
            this.textBuilder.append(new String(this.text, 0, this.textPos));
            this.text[0] = (char)n;
            this.textPos = 1;
        }
    }

    public final String getText() {
        if (this.textBuilder != null) {
            if (this.textPos > 0) {
                this.textBuilder.append(new String(this.text, 0, this.textPos));
                this.textPos = 0;
            }
            return this.textBuilder.toString();
        }
        return new String(this.text, 0, this.textPos);
    }

    public final long getLong() {
        assert (rec.getToken() == Token.INT);
        return rec.getValue();
    }

    public final int getInt() {
        assert (rec.getToken() == Token.INT);
        return (int)rec.getValue();
    }

    private final void readUtfString() throws GraphIOException {
        int n = this.line;
        this.la = this.read();
        block10: while (this.la >= 0 && this.la != 34) {
            if (this.la < 32 || this.la > 127) {
                throw new GraphIOException(this.getLocation() + "Invalid character '" + (char)this.la + "' in string in line " + this.line);
            }
            if (this.la == 92) {
                this.la = this.read();
                if (this.la < 0) break;
                switch (this.la) {
                    case 92: {
                        this.la = 92;
                        break;
                    }
                    case 34: {
                        this.la = 34;
                        break;
                    }
                    case 110: {
                        this.la = 10;
                        break;
                    }
                    case 114: {
                        this.la = 13;
                        break;
                    }
                    case 116: {
                        this.la = 9;
                        break;
                    }
                    case 117: {
                        this.la = this.read();
                        if (this.la < 0) break block10;
                        String string = "" + (char)this.la;
                        this.la = this.read();
                        if (this.la < 0) break block10;
                        string = string + (char)this.la;
                        this.la = this.read();
                        if (this.la < 0) break block10;
                        string = string + (char)this.la;
                        this.la = this.read();
                        if (this.la < 0) break block10;
                        string = string + (char)this.la;
                        try {
                            this.la = Integer.parseInt(string, 16);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new GraphIOException(this.getLocation() + "Invalid unicode escape sequence '\\u" + string + "' in line " + this.line);
                        }
                    }
                    default: {
                        throw new GraphIOException(this.getLocation() + "Invalid escape sequence in string in line " + this.line);
                    }
                }
            }
            this.append(this.la);
            this.la = this.read();
        }
        if (this.la < 0) {
            throw new GraphIOException(this.getLocation() + "Unterminated string starting in line " + n);
        }
        this.la = this.read();
    }

    public static enum Token {
        NULL_LITERAL("n"),
        TRUE_LITERAL("t"),
        FALSE_LITERAL("f"),
        COMMA(","),
        LT("<"),
        GT(">"),
        LBR("("),
        RBR(")"),
        LSQ("["),
        RSQ("]"),
        LCRL("{"),
        RCRL("}"),
        HYPHEN("-"),
        EQ("="),
        ASTERISK("*"),
        COLON(":"),
        SEMICOLON(";"),
        TGRAPH("TGraph"),
        SCHEMA("Schema"),
        GRAPHCLASS("GraphClass"),
        ABSTRACT("abstract"),
        VERTEXCLASS("VertexClass"),
        EDGECLASS("EdgeClass"),
        FROM("from"),
        TO("to"),
        ROLE("role"),
        AGGREGATION("aggregation"),
        NONE("none"),
        SHARED("shared"),
        COMPOSITE("composite"),
        ENUMDOMAIN("EnumDomain"),
        RECORDDOMAIN("RecordDomain"),
        COMMENT("Comment"),
        PACKAGE("Package"),
        GRAPH("Graph"),
        LIST("List"),
        LIST2(".LIST"),
        SET("Set"),
        SET2(".Set"),
        MAP("Map"),
        MAP2(".Map"),
        TEXT(null),
        INT(null),
        STRING(null),
        EOF(null);

        String lexeme;

        private Token(String string2) {
            this.lexeme = string2;
        }

        public String toString() {
            return this.lexeme == null ? super.toString() : this.lexeme;
        }
    }
}

