/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.VertexFilter;
import de.uni_koblenz.jgralab.impl.IncidenceIterable;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class NeighbourIterable<E extends Edge, V extends Vertex>
implements Iterable<V> {
    private IncidenceIterable<E> it;
    private VertexFilter<V> filter;

    public NeighbourIterable(Vertex vertex, EdgeClass edgeClass, EdgeDirection edgeDirection, VertexFilter<V> vertexFilter) {
        assert (vertex != null && vertex.isValid());
        this.filter = vertexFilter;
        this.it = new IncidenceIterable(vertex, edgeClass, edgeDirection);
    }

    @Override
    public Iterator<V> iterator() {
        return new NeigbourIterator(this.it.iterator());
    }

    class NeigbourIterator
    implements Iterator<V> {
        Iterator<E> incidenceIterator;
        V current;

        public NeigbourIterator(Iterator<E> iterator) {
            this.incidenceIterator = iterator;
            this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public V next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object v = this.current;
            this.getNext();
            return v;
        }

        private void getNext() {
            while (this.incidenceIterator.hasNext()) {
                this.current = ((Edge)this.incidenceIterator.next()).getThat();
                if (NeighbourIterable.this.filter != null && !NeighbourIterable.this.filter.accepts(this.current)) continue;
                return;
            }
            this.current = null;
        }

        @Override
        public void remove() {
            this.incidenceIterator.remove();
        }
    }
}

