/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;

public class AddSourceGraph
extends Transformation<Graph> {
    private String alias = null;
    private String graphFile = null;

    public AddSourceGraph(Context context, String string, String string2) {
        super(context);
        this.alias = string;
        this.graphFile = string2;
    }

    public AddSourceGraph(Context context, String string) {
        this(context, null, string);
    }

    public static AddSourceGraph parseAndCreate(ExecuteTransformation executeTransformation) {
        String string = null;
        if (executeTransformation.tryMatchGraphAlias()) {
            string = executeTransformation.matchGraphAlias();
        }
        String string2 = executeTransformation.match((TokenTypes)TokenTypes.STRING).value;
        return new AddSourceGraph(executeTransformation.context, string, string2);
    }

    @Override
    protected Graph transform() {
        Graph graph;
        if (this.alias != null) {
            if (this.context.getSourceGraph(this.alias) != null) {
                return this.context.getSourceGraph(this.alias);
            }
        } else if (this.context.getSourceGraph() != null) {
            return this.context.getSourceGraph();
        }
        try {
            graph = GraphIO.loadGraphFromFile(this.graphFile, new ConsoleProgressFunction());
        }
        catch (Exception exception) {
            throw new GReTLException("Something went wrong loading source graph from " + this.graphFile, exception);
        }
        if (this.alias == null) {
            this.context.setSourceGraph(graph);
        } else {
            this.context.addSourceGraph(this.alias, graph);
        }
        return graph;
    }
}

