/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.types;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.schema.impl.DirectedAcyclicGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.pcollections.PSet;

public class PathSystem {
    private final DirectedAcyclicGraph<PathSystemNode> dag = new DirectedAcyclicGraph();
    private final Map<Vertex, PathSystemNode> vertex2node;
    private PathSystemNode root;
    private boolean finished = false;
    private Set<PathSystemNode> leafNodes = new HashSet<PathSystemNode>();
    private static Logger logger = JGraLab.getLogger(PathSystem.class);

    public Vertex getRootVertex() {
        return this.root.currentVertex;
    }

    public PathSystemNode getRoot() {
        return this.root;
    }

    public int hashCode() {
        this.assertFinished();
        return this.extractPaths().hashCode();
    }

    public boolean equals(Object object) {
        this.assertFinished();
        if (object == null || !(object instanceof PathSystem)) {
            return false;
        }
        return this.extractPaths().equals(((PathSystem)object).extractPaths());
    }

    public PathSystem() {
        this.vertex2node = new HashMap<Vertex, PathSystemNode>();
    }

    public PathSystemNode setRootVertex(Vertex vertex, int n, boolean bl) {
        this.assertUnfinished();
        this.root = new PathSystemNode(vertex, null, n);
        this.dag.createNode(this.root);
        if (bl) {
            assert (this.root != null);
            this.leafNodes.add(this.root);
        }
        this.vertex2node.put(vertex, this.root);
        return this.root;
    }

    public PathSystemNode addVertex(Vertex vertex, int n, boolean bl) {
        this.assertUnfinished();
        PathSystemNode pathSystemNode = new PathSystemNode(vertex, n);
        this.dag.createNode(pathSystemNode);
        if (bl) {
            assert (pathSystemNode != null);
            this.leafNodes.add(pathSystemNode);
        }
        if (!this.vertex2node.containsKey(vertex)) {
            this.vertex2node.put(vertex, pathSystemNode);
        }
        return pathSystemNode;
    }

    public void addEdge(PathSystemNode pathSystemNode, PathSystemNode pathSystemNode2, Edge edge) {
        this.assertUnfinished();
        assert (pathSystemNode.edge2parent == null || pathSystemNode.edge2parent == edge);
        pathSystemNode.edge2parent = edge;
        if (!this.dag.getDirectSuccessors(pathSystemNode2).contains(pathSystemNode)) {
            this.dag.createEdge(pathSystemNode2, pathSystemNode);
        }
    }

    public void addLeaf(PathSystemNode pathSystemNode) {
        this.assertUnfinished();
        assert (pathSystemNode != null);
        if (!this.leafNodes.contains(pathSystemNode)) {
            this.leafNodes.add(pathSystemNode);
        }
    }

    public boolean isLeaf(PathSystemNode pathSystemNode) {
        return this.leafNodes.contains(pathSystemNode);
    }

    public Set<PathSystemNode> getParents(PathSystemNode pathSystemNode) {
        return this.dag.getDirectPredecessors(pathSystemNode);
    }

    public void finish() {
        this.dag.finish();
        this.finished = true;
    }

    public boolean contains(GraphElement<?, ?> graphElement) {
        this.assertFinished();
        for (PathSystemNode pathSystemNode : this.vertex2node.values()) {
            if (pathSystemNode.edge2parent == graphElement) {
                return true;
            }
            if (pathSystemNode.currentVertex != graphElement) continue;
            return true;
        }
        return false;
    }

    public PSet<Vertex> getLeaves() {
        this.assertFinished();
        PSet<Vertex> pSet = JGraLab.set();
        for (PathSystemNode pathSystemNode : this.leafNodes) {
            pSet = pSet.plus(pathSystemNode.currentVertex);
        }
        return pSet;
    }

    public PSet<PathSystemNode> getChildren(PathSystemNode pathSystemNode) {
        this.assertFinished();
        return this.dag.getDirectSuccessors(pathSystemNode);
    }

    public Path extractPath(Vertex vertex) {
        this.assertFinished();
        PathSystemNode pathSystemNode = this.vertex2node.get(vertex);
        if (pathSystemNode == null || this.leafNodes.contains(pathSystemNode)) {
            return null;
        }
        return this.extractPath(pathSystemNode);
    }

    private Path extractPath(PathSystemNode pathSystemNode) {
        this.assertFinished();
        Path path = Path.start(pathSystemNode.currentVertex);
        while (pathSystemNode != null) {
            if (pathSystemNode.edge2parent != null) {
                PSet<PathSystemNode> pSet = this.dag.getDirectPredecessors(pathSystemNode);
                assert (pSet.size() == 1) : pathSystemNode + " has precessors: " + pSet;
                path = path.append(pathSystemNode.edge2parent.getReversedEdge());
                pathSystemNode = pSet.toArray(new PathSystemNode[1])[0];
                continue;
            }
            pathSystemNode = null;
        }
        return path.reverse();
    }

    public PSet<Path> extractPaths() {
        this.assertFinished();
        PSet<Path> pSet = JGraLab.set();
        for (PathSystemNode pathSystemNode : this.leafNodes) {
            pSet = pSet.plus(this.extractPath(pathSystemNode));
        }
        return pSet;
    }

    public int getDepth() {
        this.assertFinished();
        int n = 0;
        HashMap<PathSystemNode, Integer> hashMap = new HashMap<PathSystemNode, Integer>();
        LinkedList<PathSystemNode> linkedList = new LinkedList<PathSystemNode>();
        linkedList.add(this.root);
        hashMap.put(this.root, 0);
        while (!linkedList.isEmpty()) {
            PathSystemNode pathSystemNode = (PathSystemNode)linkedList.poll();
            int n2 = (Integer)hashMap.get(pathSystemNode);
            if (n2 > n) {
                n = n2;
            }
            for (PathSystemNode pathSystemNode2 : this.dag.getDirectSuccessors(pathSystemNode)) {
                hashMap.put(pathSystemNode2, n2 + 1);
                linkedList.add(pathSystemNode2);
            }
        }
        return n;
    }

    public int distance(Vertex vertex) {
        this.assertFinished();
        PathSystemNode pathSystemNode = this.vertex2node.get(vertex);
        if (pathSystemNode == null) {
            return -1;
        }
        int n = 0;
        while (pathSystemNode != null && pathSystemNode.edge2parent != null) {
            PSet<PathSystemNode> pSet = this.dag.getDirectPredecessors(pathSystemNode);
            assert (pSet.size() == 1);
            pathSystemNode = pSet.toArray(new PathSystemNode[1])[0];
            ++n;
        }
        return n;
    }

    public void printAscii() {
        this.assertFinished();
        PSet<Path> pSet = this.extractPaths();
        for (Path path : pSet) {
            logger.info(path.toString());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("PathSystem:\n");
        PSet<Path> pSet = this.extractPaths();
        for (Path path : pSet) {
            stringBuilder.append(path.toString());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private void assertUnfinished() {
        if (this.finished) {
            throw new IllegalStateException("Cannot modify a finished path system");
        }
    }

    private void assertFinished() {
        if (!this.finished) {
            throw new IllegalStateException("Path System needs to be finished before it can be used. Use PathSystem.finish()");
        }
    }

    public PSet<Vertex> getVertices() {
        this.assertFinished();
        PSet pSet = JGraLab.set();
        return pSet.plusAll(this.vertex2node.keySet());
    }

    public PSet<Edge> getEdges() {
        this.assertFinished();
        PSet<Edge> pSet = JGraLab.set();
        for (PathSystemNode pathSystemNode : this.dag.getNodesInTopologicalOrder()) {
            if (pathSystemNode.edge2parent == null) continue;
            pSet = pSet.plus(pathSystemNode.edge2parent);
        }
        return pSet;
    }

    public class PathSystemNode {
        public Vertex currentVertex;
        public Edge edge2parent;
        public int state = -1;

        PathSystemNode(Vertex vertex, Edge edge, int n) {
            this.currentVertex = vertex;
            this.edge2parent = edge;
            this.state = n;
        }

        PathSystemNode(Vertex vertex, int n) {
            this.currentVertex = vertex;
            this.state = n;
        }

        public String toString() {
            return "(" + this.currentVertex + ", " + this.state + ") " + this.edge2parent;
        }
    }
}

