/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.types;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import java.util.HashSet;
import org.pcollections.PVector;

public class Path {
    private final PVector<Vertex> vertices;
    private final PVector<Edge> edges;

    private Path(PVector<Vertex> pVector, PVector<Edge> pVector2) {
        this.vertices = pVector;
        this.edges = pVector2;
    }

    public static Path start(Vertex vertex) {
        if (vertex == null || !vertex.isValid()) {
            throw new IllegalArgumentException("The vertex must be != null and valid");
        }
        PVector pVector = JGraLab.vector();
        PVector<Edge> pVector2 = JGraLab.vector();
        return new Path(pVector.plus(vertex), pVector2);
    }

    public Path reverse() {
        int n;
        PVector<Vertex> pVector = JGraLab.vector();
        PVector<Edge> pVector2 = JGraLab.vector();
        for (n = this.vertices.size() - 1; n >= 0; --n) {
            pVector = pVector.plus((Vertex)this.vertices.get(n));
        }
        for (n = this.edges.size() - 1; n >= 0; --n) {
            pVector2 = pVector2.plus(((Edge)this.edges.get(n)).getReversedEdge());
        }
        return new Path(pVector, pVector2);
    }

    public Path append(Edge edge) {
        if (edge.getThis() != this.getEndVertex()) {
            throw new IllegalArgumentException("Can't append " + edge + " to this Path (e.getThis() (" + edge.getThis() + ") !=" + this.getEndVertex() + ")");
        }
        return new Path(this.vertices.plus(edge.getThat()), this.edges.plus(edge));
    }

    public Vertex getStartVertex() {
        return (Vertex)this.vertices.get(0);
    }

    public Vertex getEndVertex() {
        return (Vertex)this.vertices.get(this.vertices.size() - 1);
    }

    public int getLength() {
        return this.edges.size();
    }

    public Vertex getVertexAt(int n) {
        return (Vertex)this.vertices.get(n);
    }

    public Edge getEdgeAt(int n) {
        return (Edge)this.edges.get(n);
    }

    public boolean isTrail() {
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        hashSet.add(this.getStartVertex());
        for (Edge edge : this.edges) {
            if (hashSet.contains(edge.getThat())) {
                return false;
            }
            hashSet.add(edge.getThat());
        }
        return true;
    }

    public PVector<Edge> getEdgeTrace() {
        return this.edges;
    }

    public PVector<Vertex> getVertexTrace() {
        return this.vertices;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Path)) {
            return false;
        }
        Path path = (Path)object;
        return this.vertices.equals(path.vertices) && this.edges.equals(path.edges);
    }

    public int hashCode() {
        return this.vertices.hashCode() + this.edges.hashCode();
    }

    public int degree(Vertex vertex, EdgeDirection edgeDirection) {
        int n = 0;
        switch (edgeDirection) {
            case IN: {
                for (Edge edge : this.edges) {
                    if (edge.getOmega() != vertex) continue;
                    ++n;
                }
                return n;
            }
            case OUT: {
                for (Edge edge : this.edges) {
                    if (edge.getAlpha() != vertex) continue;
                    ++n;
                }
                return n;
            }
            case INOUT: {
                for (Edge edge : this.edges) {
                    if (edge.getOmega() == vertex) {
                        ++n;
                        continue;
                    }
                    if (edge.getAlpha() != vertex) continue;
                    ++n;
                }
                return n;
            }
        }
        throw new RuntimeException("FIXME: Unhandled EdgeDirection " + (Object)((Object)edgeDirection));
    }

    public boolean contains(GraphElement<?, ?> graphElement) {
        return graphElement instanceof Vertex ? this.containsVertex((Vertex)graphElement) : this.containsEdge((Edge)graphElement);
    }

    public boolean containsVertex(Vertex vertex) {
        return this.vertices.contains(vertex);
    }

    public boolean containsEdge(Edge edge) {
        return this.edges.contains(edge);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Path: ");
        if (this.vertices.isEmpty()) {
            stringBuilder.append("empty");
        } else {
            stringBuilder.append(this.vertices.get(0));
            for (Edge edge : this.edges) {
                stringBuilder.append(" ").append(edge).append(" ").append(edge.getThat());
            }
        }
        return stringBuilder.toString();
    }
}

