/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.And;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.ConditionalExpressionUnit;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.False;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.NonConstantTerm;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Not;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Or;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.True;
import de.uni_koblenz.jgralab.greql.schema.BoolLiteral;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.IsArgumentOf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

public abstract class Formula {
    private static final int MAX_NON_CONSTANT_TERM_NUMBER = 3;
    protected static Logger logger = JGraLab.getLogger(Formula.class);
    protected GreqlQuery query;

    public abstract String toString();

    public abstract Expression toExpression();

    public static Formula createFormulaFromExpression(Expression expression, GreqlQuery greqlQuery) {
        Formula formula = Formula.createFormulaFromExpressionInternal(greqlQuery, expression);
        OptimizerUtility.deleteOrphanedVerticesBelow(expression, new HashSet<Vertex>(formula.getNonConstantTermExpressions()));
        return formula;
    }

    public Formula(GreqlQuery greqlQuery) {
        this.query = greqlQuery;
    }

    private static Formula createFormulaFromExpressionInternal(GreqlQuery greqlQuery, Expression expression) {
        assert (expression.isValid()) : expression + " is not valid!";
        if (expression instanceof BoolLiteral) {
            BoolLiteral boolLiteral = (BoolLiteral)expression;
            if (boolLiteral.is_boolValue()) {
                return new True(greqlQuery);
            }
            return new False(greqlQuery);
        }
        if (expression instanceof FunctionApplication) {
            FunctionApplication functionApplication = (FunctionApplication)expression;
            if (OptimizerUtility.isAnd(functionApplication)) {
                IsArgumentOf isArgumentOf = functionApplication.getFirstIsArgumentOfIncidence(EdgeDirection.IN);
                Expression expression2 = isArgumentOf.getAlpha();
                Expression expression3 = isArgumentOf.getNextIsArgumentOfIncidence(EdgeDirection.IN).getAlpha();
                return new And(greqlQuery, Formula.createFormulaFromExpressionInternal(greqlQuery, expression2), Formula.createFormulaFromExpressionInternal(greqlQuery, expression3));
            }
            if (OptimizerUtility.isOr(functionApplication)) {
                IsArgumentOf isArgumentOf = functionApplication.getFirstIsArgumentOfIncidence(EdgeDirection.IN);
                Expression expression4 = isArgumentOf.getAlpha();
                Expression expression5 = isArgumentOf.getNextIsArgumentOfIncidence(EdgeDirection.IN).getAlpha();
                return new Or(greqlQuery, Formula.createFormulaFromExpressionInternal(greqlQuery, expression4), Formula.createFormulaFromExpressionInternal(greqlQuery, expression5));
            }
            if (OptimizerUtility.isNot(functionApplication)) {
                IsArgumentOf isArgumentOf = functionApplication.getFirstIsArgumentOfIncidence(EdgeDirection.IN);
                Expression expression6 = isArgumentOf.getAlpha();
                return new Not(greqlQuery, Formula.createFormulaFromExpressionInternal(greqlQuery, expression6));
            }
        }
        return new NonConstantTerm(greqlQuery, expression);
    }

    public Formula optimize() {
        ArrayList<Expression> arrayList = this.getNonConstantTermExpressions();
        if (arrayList.size() < 2) {
            return this;
        }
        ConditionalExpressionUnit conditionalExpressionUnit = this.calculateBestConditionalExpressionUnit(arrayList);
        return conditionalExpressionUnit.toConditionalExpression();
    }

    private ConditionalExpressionUnit calculateBestConditionalExpressionUnit(ArrayList<Expression> arrayList) {
        if (arrayList.size() > 3) {
            logger.fine("Formula: " + arrayList.size() + " NCTEs ==> shortcutting...");
            return new ConditionalExpressionUnit(arrayList.get(0), this);
        }
        ConditionalExpressionUnit conditionalExpressionUnit = null;
        for (Expression expression : arrayList) {
            ConditionalExpressionUnit conditionalExpressionUnit2 = new ConditionalExpressionUnit(expression, this);
            if (conditionalExpressionUnit == null) {
                conditionalExpressionUnit = conditionalExpressionUnit2;
            }
            if (conditionalExpressionUnit != null && !(conditionalExpressionUnit.getInfluenceCostRatio() < conditionalExpressionUnit2.getInfluenceCostRatio())) continue;
            conditionalExpressionUnit = conditionalExpressionUnit2;
        }
        return conditionalExpressionUnit;
    }

    protected abstract ArrayList<Expression> getNonConstantTermExpressions();

    protected abstract Formula calculateReplacementFormula(Expression var1, Literal var2);

    public abstract Formula simplify();

    public abstract double getSelectivity();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

