/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.schema;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.schema.GraphElementClass;

public class HasType
extends Function {
    @Description(params={"el", "qn"}, description="Returns true, iff the given attributed element has an attributed element class with the given qualified name.", categories={Function.Category.SCHEMA_ACCESS})
    public <SC extends GraphElementClass<SC, IC>, IC extends GraphElement<SC, IC>> Boolean evaluate(IC IC, String string) {
        GraphElementClass graphElementClass = (GraphElementClass)IC.getSchema().getAttributedElementClass(string);
        if (graphElementClass == null) {
            throw new GreqlException("hasType: Schema doesn't contain a type '");
        }
        return this.evaluate(IC, graphElementClass);
    }

    @Description(params={"el", "aec"}, description="Returns true, iff the given attributed element has the given attributed element class", categories={Function.Category.SCHEMA_ACCESS})
    private <SC extends GraphElementClass<SC, IC>, IC extends GraphElement<SC, IC>> Boolean evaluate(IC IC, SC SC) {
        GraphElementClass graphElementClass = (GraphElementClass)IC.getAttributedElementClass();
        return graphElementClass.equals(SC) || graphElementClass.isSubClassOf(SC);
    }

    @Description(params={"el", "tc"}, description="Returns true, iff the given attributed element has an attributed element class accepted by the given type collection.", categories={Function.Category.SCHEMA_ACCESS})
    public <SC extends GraphElementClass<SC, IC>, IC extends GraphElement<SC, IC>> Boolean evaluate(IC IC, TypeCollection typeCollection) {
        GraphElementClass graphElementClass = (GraphElementClass)IC.getAttributedElementClass();
        return typeCollection.acceptsType(graphElementClass);
    }
}

