/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsGraphArgument;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

@NeedsGraphArgument
public class FirstEdge
extends Function {
    public FirstEdge() {
        super(4L, 1L, 1.0);
    }

    @Description(params={"g"}, description="Returns the first edge of the graph g.", categories={Function.Category.GRAPH})
    public Edge evaluate(Graph graph) {
        return graph.getFirstEdge();
    }

    @Description(params={"g", "c"}, description="Returns the first edge of the graph g.\nThe scope is limited by a type collection.", categories={Function.Category.GRAPH})
    public Edge evaluate(Graph graph, TypeCollection typeCollection) {
        Edge edge;
        for (edge = graph.getFirstEdge(); edge != null && !typeCollection.acceptsType(edge.getAttributedElementClass()); edge = edge.getNextEdge()) {
        }
        return edge;
    }
}

