/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VariableDeclarationLayer;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.DeclarationEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.QuantificationType;
import de.uni_koblenz.jgralab.greql.schema.QuantifiedExpression;
import de.uni_koblenz.jgralab.greql.schema.Quantifier;

public class QuantifiedExpressionEvaluator
extends VertexEvaluator<QuantifiedExpression> {
    private QuantificationType quantificationType = null;
    private boolean initialized = false;
    private VertexEvaluator<? extends Expression> predicateEvaluator = null;

    public QuantifiedExpressionEvaluator(QuantifiedExpression quantifiedExpression, GreqlQueryImpl greqlQueryImpl) {
        super(quantifiedExpression, greqlQueryImpl);
    }

    private void initialize(InternalGreqlEvaluator internalGreqlEvaluator) {
        Quantifier quantifier = ((QuantifiedExpression)this.vertex).getFirstIsQuantifierOfIncidence(EdgeDirection.IN).getAlpha();
        this.quantificationType = quantifier.get_type();
        Expression expression = ((QuantifiedExpression)this.vertex).getFirstIsBoundExprOfIncidence(EdgeDirection.IN).getAlpha();
        this.predicateEvaluator = this.query.getVertexEvaluator(expression);
        this.initialized = true;
    }

    @Override
    public Boolean evaluate(InternalGreqlEvaluator internalGreqlEvaluator) {
        if (!this.initialized) {
            this.initialize(internalGreqlEvaluator);
        }
        internalGreqlEvaluator.progress(this.getOwnEvaluationCosts());
        boolean bl = false;
        Declaration declaration = ((QuantifiedExpression)this.vertex).getFirstIsQuantifiedDeclOfIncidence(EdgeDirection.IN).getAlpha();
        DeclarationEvaluator declarationEvaluator = (DeclarationEvaluator)this.query.getVertexEvaluator(declaration);
        VariableDeclarationLayer variableDeclarationLayer = (VariableDeclarationLayer)declarationEvaluator.getResult(internalGreqlEvaluator);
        variableDeclarationLayer.reset();
        switch (this.quantificationType) {
            case EXISTS: {
                while (variableDeclarationLayer.iterate(internalGreqlEvaluator)) {
                    Object object = this.predicateEvaluator.getResult(internalGreqlEvaluator);
                    if (object instanceof Boolean) {
                        if (!((Boolean)object).booleanValue()) continue;
                        return Boolean.TRUE;
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case EXISTSONE: {
                while (variableDeclarationLayer.iterate(internalGreqlEvaluator)) {
                    Object object = this.predicateEvaluator.getResult(internalGreqlEvaluator);
                    if (object instanceof Boolean) {
                        if (!((Boolean)object).booleanValue()) continue;
                        if (bl) {
                            return Boolean.FALSE;
                        }
                        bl = true;
                        continue;
                    }
                    if (bl) {
                        return Boolean.FALSE;
                    }
                    bl = true;
                }
                if (bl) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case FORALL: {
                while (variableDeclarationLayer.iterate(internalGreqlEvaluator)) {
                    Object object = this.predicateEvaluator.getResult(internalGreqlEvaluator);
                    if (!(object instanceof Boolean) || ((Boolean)object).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        throw new RuntimeException("FIXME: Unhandled quantification type " + (Object)((Object)this.quantificationType));
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        QuantifiedExpression quantifiedExpression = (QuantifiedExpression)this.getVertex();
        VertexEvaluator<Declaration> vertexEvaluator = this.query.getVertexEvaluator(quantifiedExpression.getFirstIsQuantifiedDeclOfIncidence().getAlpha());
        long l = vertexEvaluator.getCurrentSubtreeEvaluationCosts();
        VertexEvaluator<Expression> vertexEvaluator2 = this.query.getVertexEvaluator(quantifiedExpression.getFirstIsBoundExprOfQuantifiedExpressionIncidence().getAlpha());
        long l2 = vertexEvaluator2.getCurrentSubtreeEvaluationCosts();
        long l3 = 20L;
        long l4 = l3 * this.getVariableCombinations();
        long l5 = l4 + l + l2;
        return new VertexCosts(l3, l4, l5);
    }
}

