/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.IncidenceDirection;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.DirectedSchemaEdgeClass;
import de.uni_koblenz.jgralab.schema.impl.GraphClassImpl;
import de.uni_koblenz.jgralab.schema.impl.GraphElementClassImpl;
import de.uni_koblenz.jgralab.schema.impl.IncidenceClassImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VertexClassImpl
extends GraphElementClassImpl<VertexClass, Vertex>
implements VertexClass {
    private Set<IncidenceClass> inIncidenceClasses = new HashSet<IncidenceClass>();
    private Set<IncidenceClass> allInIncidenceClasses;
    private Set<IncidenceClass> outIncidenceClasses = new HashSet<IncidenceClass>();
    private Set<IncidenceClass> allOutIncidenceClasses;
    private Set<IncidenceClass> validFromFarIncidenceClasses;
    private Set<EdgeClass> validFromEdgeClasses;
    private Set<EdgeClass> validToEdgeClasses;
    private Set<IncidenceClass> validToFarIncidenceClasses;
    private Map<String, DirectedSchemaEdgeClass> farRoleNameToEdgeClass;

    protected VertexClassImpl(String string, PackageImpl packageImpl, GraphClassImpl graphClassImpl) {
        super(string, packageImpl, graphClassImpl, graphClassImpl.vertexClassDag);
        this.parentPackage.addVertexClass(this);
        this.graphClass.addVertexClass(this);
    }

    void addInIncidenceClass(IncidenceClass incidenceClass) {
        if (incidenceClass.getVertexClass() != this) {
            this.throwSchemaException(incidenceClass);
        }
        this.checkDuplicateRolenames(incidenceClass);
        this.inIncidenceClasses.add(incidenceClass);
    }

    void addOutIncidenceClass(IncidenceClass incidenceClass) {
        if (incidenceClass.getVertexClass() != this) {
            this.throwSchemaException(incidenceClass);
        }
        this.checkDuplicateRolenames(incidenceClass);
        this.outIncidenceClasses.add(incidenceClass);
    }

    private void checkDuplicateRolenames(IncidenceClass incidenceClass) {
        String string = incidenceClass.getOpposite().getRolename();
        if (string.isEmpty()) {
            return;
        }
        this.checkDuplicatedRolenameForACyclicIncidence(incidenceClass);
        this.checkDuplicatedRolenameForAllIncidences(incidenceClass, this.getAllInIncidenceClasses());
        this.checkDuplicatedRolenameForAllIncidences(incidenceClass, this.getAllOutIncidenceClasses());
    }

    private void checkDuplicatedRolenameForACyclicIncidence(IncidenceClass incidenceClass) {
        boolean bl;
        String string = incidenceClass.getOpposite().getRolename();
        VertexClass vertexClass = incidenceClass.getOpposite().getVertexClass();
        boolean bl2 = incidenceClass.getRolename().equals(string);
        boolean bl3 = bl = this == vertexClass;
        if (bl2 && bl) {
            throw new SchemaException("The rolename " + incidenceClass.getRolename() + " may be not used at both ends of the reflexive edge class " + incidenceClass.getEdgeClass().getQualifiedName());
        }
    }

    private void checkDuplicatedRolenameForAllIncidences(IncidenceClass incidenceClass, Set<IncidenceClass> set) {
        String string = incidenceClass.getOpposite().getRolename();
        if (string.isEmpty()) {
            return;
        }
        for (IncidenceClass incidenceClass2 : set) {
            if (incidenceClass2 == incidenceClass || !incidenceClass2.getOpposite().getRolename().equals(string)) continue;
            throw new SchemaException("The rolename " + incidenceClass2.getOpposite().getRolename() + " is used twice at class " + this.getQualifiedName() + ". Concerning edge classes are " + incidenceClass.getEdgeClass().getQualifiedName() + " and " + incidenceClass2.getEdgeClass().getQualifiedName());
        }
    }

    private void throwSchemaException(IncidenceClass incidenceClass) {
        throw new SchemaException("Try to add IncidenceClass ending at '" + incidenceClass.getVertexClass().getQualifiedName() + "' to VertexClass '" + this.getQualifiedName() + "'.IncidenceClasses may be added only to VertexClasses they are connected to.");
    }

    @Override
    public void addSuperClass(VertexClass vertexClass) {
        this.assertNotFinished();
        if (vertexClass == this) {
            return;
        }
        this.checkDuplicateRolenames(vertexClass);
        super.addSuperClass(vertexClass);
    }

    private void checkDuplicateRolenames(VertexClass vertexClass) {
        this.checkDuplicatedRolenamesAgainstAllIncidences(vertexClass.getAllInIncidenceClasses());
        this.checkDuplicatedRolenamesAgainstAllIncidences(vertexClass.getAllOutIncidenceClasses());
    }

    private void checkDuplicatedRolenamesAgainstAllIncidences(Set<IncidenceClass> set) {
        for (IncidenceClass incidenceClass : set) {
            this.checkDuplicateRolenames(incidenceClass);
        }
    }

    @Override
    public Set<IncidenceClass> getValidFromFarIncidenceClasses() {
        if (this.isFinished()) {
            return this.validFromFarIncidenceClasses;
        }
        HashSet<IncidenceClass> hashSet = new HashSet<IncidenceClass>();
        for (IncidenceClass object : this.getAllOutIncidenceClasses()) {
            IncidenceClass incidenceClass = object.getEdgeClass().getTo();
            hashSet.add(incidenceClass);
        }
        for (VertexClass vertexClass : this.getAllSuperClasses()) {
            for (IncidenceClass incidenceClass : vertexClass.getAllOutIncidenceClasses()) {
                IncidenceClass incidenceClass2 = incidenceClass.getEdgeClass().getTo();
                hashSet.add(incidenceClass2);
            }
        }
        return hashSet;
    }

    @Override
    public Set<IncidenceClass> getValidToFarIncidenceClasses() {
        if (this.isFinished()) {
            return this.validToFarIncidenceClasses;
        }
        HashSet<IncidenceClass> hashSet = new HashSet<IncidenceClass>();
        for (IncidenceClass object : this.getAllInIncidenceClasses()) {
            IncidenceClass incidenceClass = object.getEdgeClass().getFrom();
            hashSet.add(incidenceClass);
        }
        for (VertexClass vertexClass : this.getAllSuperClasses()) {
            for (IncidenceClass incidenceClass : vertexClass.getAllInIncidenceClasses()) {
                IncidenceClass incidenceClass2 = incidenceClass.getEdgeClass().getFrom();
                hashSet.add(incidenceClass2);
            }
        }
        return hashSet;
    }

    @Override
    public Set<EdgeClass> getValidFromEdgeClasses() {
        if (this.isFinished()) {
            return this.validFromEdgeClasses;
        }
        HashSet<EdgeClass> hashSet = new HashSet<EdgeClass>();
        for (IncidenceClass incidenceClass : this.getValidFromFarIncidenceClasses()) {
            if (incidenceClass.getEdgeClass().isDefaultGraphElementClass()) continue;
            hashSet.add(incidenceClass.getEdgeClass());
        }
        return hashSet;
    }

    @Override
    public Set<EdgeClass> getValidToEdgeClasses() {
        if (this.isFinished()) {
            return this.validToEdgeClasses;
        }
        HashSet<EdgeClass> hashSet = new HashSet<EdgeClass>();
        for (IncidenceClass incidenceClass : this.getValidToFarIncidenceClasses()) {
            if (incidenceClass.getEdgeClass().isDefaultGraphElementClass()) continue;
            hashSet.add(incidenceClass.getEdgeClass());
        }
        return hashSet;
    }

    public Set<IncidenceClass> getOwnInIncidenceClasses() {
        return this.inIncidenceClasses;
    }

    public Set<IncidenceClass> getOwnOutIncidenceClasses() {
        return this.outIncidenceClasses;
    }

    @Override
    public Set<IncidenceClass> getAllInIncidenceClasses() {
        if (this.isFinished()) {
            return this.allInIncidenceClasses;
        }
        HashSet<IncidenceClass> hashSet = new HashSet<IncidenceClass>();
        hashSet.addAll(this.inIncidenceClasses);
        for (VertexClass vertexClass : this.getDirectSuperClasses()) {
            hashSet.addAll(vertexClass.getAllInIncidenceClasses());
        }
        return hashSet;
    }

    @Override
    public Set<IncidenceClass> getAllOutIncidenceClasses() {
        if (this.isFinished()) {
            return this.allOutIncidenceClasses;
        }
        HashSet<IncidenceClass> hashSet = new HashSet<IncidenceClass>();
        hashSet.addAll(this.outIncidenceClasses);
        for (VertexClass vertexClass : this.getDirectSuperClasses()) {
            hashSet.addAll(vertexClass.getAllOutIncidenceClasses());
        }
        return hashSet;
    }

    @Override
    public Set<IncidenceClass> getOwnAndInheritedFarIncidenceClasses() {
        HashSet<IncidenceClass> hashSet = new HashSet<IncidenceClass>();
        for (IncidenceClass incidenceClass : this.getAllInIncidenceClasses()) {
            hashSet.add(incidenceClass.getEdgeClass().getFrom());
            for (IncidenceClass incidenceClass2 : incidenceClass.getSubsettedIncidenceClasses()) {
                hashSet.add(incidenceClass2.getEdgeClass().getFrom());
            }
        }
        for (IncidenceClass incidenceClass : this.getAllOutIncidenceClasses()) {
            hashSet.add(incidenceClass.getEdgeClass().getTo());
            for (IncidenceClass incidenceClass2 : incidenceClass.getSubsettedIncidenceClasses()) {
                hashSet.add(incidenceClass2.getEdgeClass().getTo());
            }
        }
        return hashSet;
    }

    @Override
    public Set<EdgeClass> getConnectedEdgeClasses() {
        HashSet<EdgeClass> hashSet = new HashSet<EdgeClass>();
        for (IncidenceClass incidenceClass : this.getAllInIncidenceClasses()) {
            hashSet.add(incidenceClass.getEdgeClass());
        }
        for (IncidenceClass incidenceClass : this.getAllOutIncidenceClasses()) {
            hashSet.add(incidenceClass.getEdgeClass());
        }
        return hashSet;
    }

    @Override
    public Set<EdgeClass> getOwnConnectedEdgeClasses() {
        HashSet<EdgeClass> hashSet = new HashSet<EdgeClass>();
        for (IncidenceClass incidenceClass : this.getOwnInIncidenceClasses()) {
            hashSet.add(incidenceClass.getEdgeClass());
        }
        for (IncidenceClass incidenceClass : this.getOwnOutIncidenceClasses()) {
            hashSet.add(incidenceClass.getEdgeClass());
        }
        return hashSet;
    }

    @Override
    protected void finish() {
        this.allInIncidenceClasses = new HashSet<IncidenceClass>();
        this.allInIncidenceClasses.addAll(this.inIncidenceClasses);
        this.allOutIncidenceClasses = new HashSet<IncidenceClass>();
        this.allOutIncidenceClasses.addAll(this.outIncidenceClasses);
        for (VertexClass object : this.getDirectSuperClasses()) {
            this.allInIncidenceClasses.addAll(object.getAllInIncidenceClasses());
            this.allOutIncidenceClasses.addAll(object.getAllOutIncidenceClasses());
        }
        this.allInIncidenceClasses = Collections.unmodifiableSet(this.allInIncidenceClasses);
        this.allOutIncidenceClasses = Collections.unmodifiableSet(this.allOutIncidenceClasses);
        this.validFromFarIncidenceClasses = Collections.unmodifiableSet(this.getValidFromFarIncidenceClasses());
        this.validToFarIncidenceClasses = Collections.unmodifiableSet(this.getValidToFarIncidenceClasses());
        this.validFromEdgeClasses = Collections.unmodifiableSet(this.getValidFromEdgeClasses());
        this.validToEdgeClasses = Collections.unmodifiableSet(this.getValidToEdgeClasses());
        this.farRoleNameToEdgeClass = new HashMap<String, DirectedSchemaEdgeClass>();
        for (IncidenceClass incidenceClass : this.getOwnAndInheritedFarIncidenceClasses()) {
            String string = incidenceClass.getRolename();
            if (string.length() == 0) continue;
            this.farRoleNameToEdgeClass.put(string, this.getDirectedEdgeClassForFarEndRole(string));
        }
        this.farRoleNameToEdgeClass = Collections.unmodifiableMap(this.farRoleNameToEdgeClass);
        this.inIncidenceClasses = Collections.unmodifiableSet(this.inIncidenceClasses);
        this.outIncidenceClasses = Collections.unmodifiableSet(this.outIncidenceClasses);
        for (IncidenceClass incidenceClass : this.inIncidenceClasses) {
            ((IncidenceClassImpl)incidenceClass).finish();
        }
        for (IncidenceClass incidenceClass : this.outIncidenceClasses) {
            ((IncidenceClassImpl)incidenceClass).finish();
        }
        super.finish();
    }

    @Override
    public boolean isValidFromFor(EdgeClass edgeClass) {
        if (edgeClass.equals(this.graphClass.getTemporaryEdgeClass())) {
            return true;
        }
        return this.getValidFromEdgeClasses().contains(edgeClass);
    }

    @Override
    public boolean isValidToFor(EdgeClass edgeClass) {
        if (edgeClass.equals(this.graphClass.getTemporaryEdgeClass())) {
            return true;
        }
        return this.getValidToEdgeClasses().contains(edgeClass);
    }

    @Override
    public DirectedSchemaEdgeClass getDirectedEdgeClassForFarEndRole(String string) {
        if (this.isFinished()) {
            return this.farRoleNameToEdgeClass.get(string);
        }
        for (IncidenceClass incidenceClass : this.getOwnAndInheritedFarIncidenceClasses()) {
            if (!string.equals(incidenceClass.getRolename())) continue;
            EdgeClass edgeClass = incidenceClass.getEdgeClass();
            return new DirectedSchemaEdgeClass(edgeClass, incidenceClass.getDirection() == IncidenceDirection.IN ? EdgeDirection.OUT : EdgeDirection.IN);
        }
        return null;
    }

    @Override
    protected void reopen() {
        this.allInIncidenceClasses = null;
        this.allOutIncidenceClasses = null;
        this.validFromFarIncidenceClasses = null;
        this.validToFarIncidenceClasses = null;
        this.validFromEdgeClasses = null;
        this.validToEdgeClasses = null;
        this.farRoleNameToEdgeClass = null;
        for (IncidenceClass incidenceClass : this.inIncidenceClasses) {
            ((IncidenceClassImpl)incidenceClass).reopen();
        }
        for (IncidenceClass incidenceClass : this.outIncidenceClasses) {
            ((IncidenceClassImpl)incidenceClass).reopen();
        }
        this.inIncidenceClasses = new HashSet<IncidenceClass>(this.inIncidenceClasses);
        this.outIncidenceClasses = new HashSet<IncidenceClass>(this.outIncidenceClasses);
        super.reopen();
    }

    @Override
    protected final void register() {
        super.register();
        this.graphClass.vertexClasses.put(this.qualifiedName, this);
        this.parentPackage.vertexClasses.put(this.simpleName, this);
    }

    @Override
    protected final void unregister() {
        super.unregister();
        this.graphClass.vertexClasses.remove(this.qualifiedName);
        this.parentPackage.vertexClasses.remove(this.simpleName);
    }

    @Override
    public void delete() {
        this.schema.assertNotFinished();
        if (this == this.graphClass.getDefaultVertexClass()) {
            throw new SchemaException("The default vertex class cannot be deleted.");
        }
        if (!this.getConnectedEdgeClasses().isEmpty()) {
            throw new SchemaException("Cannot delete vertex class " + this.qualifiedName + " because there are still connected edge classes: " + this.getConnectedEdgeClasses());
        }
        super.delete();
        this.graphClass.vertexClasses.remove(this.qualifiedName);
        this.graphClass.vertexClassDag.delete(this);
        this.parentPackage.vertexClasses.remove(this.simpleName);
    }

    void unlink(IncidenceClass incidenceClass) {
        this.schema.assertNotFinished();
        this.outIncidenceClasses.remove(incidenceClass);
        this.inIncidenceClasses.remove(incidenceClass);
    }

    @Override
    protected VertexClass getDefaultClass() {
        return this.graphClass.getDefaultVertexClass();
    }

    @Override
    public boolean isDefaultGraphElementClass() {
        return this == this.graphClass.getDefaultVertexClass();
    }
}

