/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl.generic;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.impl.RecordImpl;
import de.uni_koblenz.jgralab.impl.ReversedEdgeBaseImpl;
import de.uni_koblenz.jgralab.impl.generic.GenericGraphImpl;
import de.uni_koblenz.jgralab.impl.generic.GenericReversedEdgeImpl;
import de.uni_koblenz.jgralab.impl.generic.InternalAttributesArrayAccess;
import de.uni_koblenz.jgralab.impl.std.EdgeImpl;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import java.io.IOException;

public class GenericEdgeImpl
extends EdgeImpl
implements InternalAttributesArrayAccess {
    private EdgeClass type;
    private Object[] attributes;

    public GenericEdgeImpl(EdgeClass edgeClass, int n, Graph graph, Vertex vertex, Vertex vertex2) {
        super(n, graph, vertex, vertex2);
        if (edgeClass.isAbstract()) {
            throw new GraphException("Cannot create instances of abstract type " + edgeClass);
        }
        this.type = edgeClass;
        if (edgeClass.hasAttributes()) {
            this.attributes = new Object[edgeClass.getAttributeCount()];
            if (!((InternalGraph)graph).isLoading()) {
                GenericGraphImpl.initializeGenericAttributeValues(this);
            }
        }
        ((GenericGraphImpl)graph).addEdge(this, vertex, vertex2);
    }

    @Override
    protected ReversedEdgeBaseImpl createReversedEdge() {
        return new GenericReversedEdgeImpl(this, (Graph)this.graph);
    }

    @Override
    public EdgeClass getAttributedElementClass() {
        return this.type;
    }

    @Override
    public void readAttributeValueFromString(String string, String string2) throws GraphIOException, NoSuchAttributeException {
        int n = this.type.getAttributeIndex(string);
        this.attributes[n] = this.type.getAttribute(string).getDomain().parseGenericAttribute(GraphIO.createStringReader(string2, this.getSchema()));
    }

    @Override
    public void readAttributeValues(GraphIO graphIO) throws GraphIOException {
        for (Attribute attribute : this.type.getAttributeList()) {
            this.attributes[this.type.getAttributeIndex((String)attribute.getName())] = attribute.getDomain().parseGenericAttribute(graphIO);
        }
    }

    @Override
    public String writeAttributeValueToString(String string) throws IOException, GraphIOException, NoSuchAttributeException {
        GraphIO graphIO = GraphIO.createStringWriter(this.getSchema());
        this.type.getAttribute(string).getDomain().serializeGenericAttribute(graphIO, this.getAttribute(string));
        return graphIO.getStringWriterResult();
    }

    @Override
    public void writeAttributeValues(GraphIO graphIO) throws IOException, GraphIOException {
        for (Attribute attribute : this.type.getAttributeList()) {
            attribute.getDomain().serializeGenericAttribute(graphIO, this.getAttribute(attribute.getName()));
        }
    }

    @Override
    public AggregationKind getAggregationKind() {
        AggregationKind aggregationKind = this.getAttributedElementClass().getFrom().getAggregationKind();
        AggregationKind aggregationKind2 = this.getAttributedElementClass().getTo().getAggregationKind();
        return aggregationKind != AggregationKind.NONE ? aggregationKind : (aggregationKind2 != AggregationKind.NONE ? aggregationKind2 : AggregationKind.NONE);
    }

    @Override
    public AggregationKind getAlphaAggregationKind() {
        return this.getAttributedElementClass().getFrom().getAggregationKind();
    }

    @Override
    public AggregationKind getOmegaAggregationKind() {
        return this.getAttributedElementClass().getTo().getAggregationKind();
    }

    @Override
    public <T> T getAttribute(String string) {
        int n = this.type.getAttributeIndex(string);
        return (T)this.attributes[n];
    }

    @Override
    public <T> void setAttribute(String string, T t) {
        int n = this.type.getAttributeIndex(string);
        if (!this.getAttributedElementClass().getAttribute(string).getDomain().isConformValue(t)) {
            Domain domain = this.type.getAttribute(string).getDomain();
            throw new ClassCastException("Expected " + (domain instanceof RecordDomain ? RecordImpl.class.getName() : domain.getJavaAttributeImplementationTypeName(domain.getPackageName())) + " object, but received " + t == null ? t.getClass().getName() + " object instead" : t + " instead");
        }
        T t2 = this.getAttribute(string);
        this.graph.fireBeforeChangeAttribute(this, string, t2, t);
        this.attributes[n] = t;
        this.graph.fireAfterChangeAttribute(this, string, t2, t);
    }

    @Override
    public Edge getNextIncidence(EdgeClass edgeClass) {
        return this.getNextIncidence(edgeClass, EdgeDirection.INOUT, false);
    }

    @Override
    public Edge getNextIncidence(EdgeClass edgeClass, EdgeDirection edgeDirection) {
        return this.getNextIncidence(edgeClass, edgeDirection, false);
    }

    @Override
    public Edge getNextIncidence(EdgeClass edgeClass, boolean bl) {
        return this.getNextIncidence(edgeClass, EdgeDirection.INOUT, bl);
    }

    @Override
    public Edge getNextIncidence(EdgeClass edgeClass, EdgeDirection edgeDirection, boolean bl) {
        Edge edge;
        for (edge = this.getNextIncidence(edgeDirection); edge != null; edge = edge.getNextIncidence(edgeDirection)) {
            if (!(bl ? edge.getAttributedElementClass().equals(edgeClass) : edgeClass.equals(edge.getAttributedElementClass()) || edgeClass.getAllSubClasses().contains(edge.getAttributedElementClass()))) continue;
            return edge;
        }
        return edge;
    }

    @Override
    public void initializeAttributesWithDefaultValues() {
        GenericGraphImpl.initializeGenericAttributeValues(this);
    }

    @Override
    public Class<? extends Edge> getSchemaClass() {
        throw new UnsupportedOperationException("This method is not supported by the generic implementation");
    }

    @Override
    public boolean isInstanceOf(EdgeClass edgeClass) {
        return this.type == edgeClass || this.type.isSubClassOf(edgeClass);
    }

    @Override
    public void invokeOnAttributesArray(InternalAttributesArrayAccess.OnAttributesFunction onAttributesFunction) {
        this.attributes = onAttributesFunction.invoke(this, this.attributes);
    }
}

