/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.PathElement;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.impl.GraphElementImpl;
import de.uni_koblenz.jgralab.impl.IncidenceIterable;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import de.uni_koblenz.jgralab.impl.InternalVertex;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.impl.DirectedSchemaEdgeClass;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.pcollections.POrderedSet;
import org.pcollections.PSet;

public abstract class VertexBaseImpl
extends GraphElementImpl<VertexClass, Vertex>
implements Vertex,
InternalVertex {
    protected VertexBaseImpl(int n, Graph graph) {
        super(graph);
        this.id = n;
    }

    @Override
    public final int getDegree() {
        return this.getDegree(EdgeDirection.INOUT);
    }

    @Override
    public final int getDegree(EdgeDirection edgeDirection) {
        int n = 0;
        switch (edgeDirection) {
            case IN: {
                Edge edge;
                for (edge = this.getFirstIncidence(); edge != null; edge = edge.getNextIncidence()) {
                    if (edge.isNormal()) continue;
                    ++n;
                }
                return n;
            }
            case OUT: {
                Edge edge;
                while (edge != null) {
                    if (edge.isNormal()) {
                        ++n;
                    }
                    edge = edge.getNextIncidence();
                }
                return n;
            }
            case INOUT: {
                Edge edge;
                while (edge != null) {
                    ++n;
                    edge = edge.getNextIncidence();
                }
                return n;
            }
        }
        throw new RuntimeException("FIXME!");
    }

    @Override
    public final Vertex getNextVertex() {
        InternalVertex internalVertex;
        TraversalContext traversalContext = this.graph.getTraversalContext();
        if (traversalContext != null && internalVertex != null && !traversalContext.containsVertex(internalVertex)) {
            for (internalVertex = this.getNextVertexInVSeq(); internalVertex != null && !traversalContext.containsVertex(internalVertex); internalVertex = internalVertex.getNextVertexInVSeq()) {
            }
        }
        return internalVertex;
    }

    @Override
    public final Vertex getNextVertex(VertexClass vertexClass) {
        assert (vertexClass != null);
        assert (this.isValid());
        for (Vertex vertex = this.getNextVertex(); vertex != null; vertex = vertex.getNextVertex()) {
            if (!vertex.isInstanceOf(vertexClass)) continue;
            return vertex;
        }
        return null;
    }

    @Override
    public final boolean isBefore(Vertex vertex) {
        InternalVertex internalVertex;
        assert (vertex != null);
        assert (this.getGraph() == vertex.getGraph());
        assert (this.isValid() && vertex.isValid());
        if (this == vertex) {
            return false;
        }
        for (internalVertex = ((InternalVertex)vertex).getPrevVertexInVSeq(); internalVertex != null && internalVertex != this; internalVertex = internalVertex.getPrevVertexInVSeq()) {
        }
        return internalVertex != null;
    }

    @Override
    public final boolean isValid() {
        return this.graph.vSeqContainsVertex(this);
    }

    @Override
    public final void putBefore(Vertex vertex) {
        assert (vertex != null);
        assert (vertex != this);
        assert (this.getGraph() == vertex.getGraph());
        assert (this.isValid() && vertex.isValid());
        this.graph.putVertexBefore((InternalVertex)vertex, this);
    }

    @Override
    public final boolean isAfter(Vertex vertex) {
        InternalVertex internalVertex;
        assert (vertex != null);
        assert (this.getGraph() == vertex.getGraph());
        assert (this.isValid() && vertex.isValid());
        if (this == vertex) {
            return false;
        }
        for (internalVertex = ((InternalVertex)vertex).getNextVertexInVSeq(); internalVertex != null && internalVertex != this; internalVertex = internalVertex.getNextVertexInVSeq()) {
        }
        return internalVertex != null;
    }

    @Override
    public final void putAfter(Vertex vertex) {
        assert (vertex != null);
        assert (vertex != this);
        assert (this.getGraph() == vertex.getGraph());
        assert (this.isValid() && vertex.isValid());
        this.graph.putVertexAfter((InternalVertex)vertex, this);
    }

    @Override
    public final Edge getFirstIncidence() {
        TraversalContext traversalContext = this.graph.getTraversalContext();
        Edge edge = this.getFirstIncidenceInISeq();
        if (traversalContext != null && edge != null && !traversalContext.containsEdge(edge)) {
            edge = edge.getNextIncidence();
        }
        return edge;
    }

    @Override
    public final Edge getLastIncidence() {
        TraversalContext traversalContext = this.graph.getTraversalContext();
        Edge edge = this.getLastIncidenceInISeq();
        if (traversalContext != null && edge != null && !traversalContext.containsEdge(edge)) {
            edge = edge.getPrevIncidence();
        }
        return edge;
    }

    @Override
    public final Edge getFirstIncidence(EdgeDirection edgeDirection) {
        assert (this.isValid());
        switch (edgeDirection) {
            case IN: {
                Edge edge;
                for (edge = this.getFirstIncidence(); edge != null && edge.isNormal(); edge = edge.getNextIncidence()) {
                }
                return edge;
            }
            case OUT: {
                Edge edge;
                while (edge != null && !edge.isNormal()) {
                    edge = edge.getNextIncidence();
                }
                return edge;
            }
            case INOUT: {
                Edge edge;
                return edge;
            }
        }
        throw new RuntimeException("FIXME!");
    }

    @Override
    public final Edge getFirstIncidence(boolean bl, AggregationKind ... aggregationKindArray) {
        Edge edge;
        assert (this.isValid());
        if (aggregationKindArray.length == 0) {
            return edge;
        }
        for (edge = this.getFirstIncidence(); edge != null; edge = edge.getNextIncidence()) {
            for (AggregationKind aggregationKind : aggregationKindArray) {
                if ((bl ? edge.getThisAggregationKind() : edge.getThatAggregationKind()) != aggregationKind) continue;
                return edge;
            }
        }
        return null;
    }

    @Override
    public final Edge getFirstIncidence(EdgeClass edgeClass) {
        assert (edgeClass != null);
        assert (this.isValid());
        return this.getFirstIncidence(edgeClass, EdgeDirection.INOUT);
    }

    @Override
    public final Edge getFirstIncidence(EdgeClass edgeClass, EdgeDirection edgeDirection) {
        assert (edgeClass != null);
        assert (this.isValid());
        for (Edge edge = this.getFirstIncidence(edgeDirection); edge != null; edge = edge.getNextIncidence(edgeDirection)) {
            if (!edge.isInstanceOf(edgeClass)) continue;
            return edge;
        }
        return null;
    }

    @Override
    public final void delete() {
        assert (this.isValid()) : this + " is not valid!";
        this.graph.deleteVertex(this);
    }

    @Override
    public final void putIncidenceAfter(InternalEdge internalEdge, InternalEdge internalEdge2) {
        assert (internalEdge != null && internalEdge2 != null);
        assert (internalEdge.isValid() && internalEdge2.isValid());
        assert (internalEdge.getGraph() == internalEdge2.getGraph());
        assert (internalEdge.getGraph() == this.getGraph());
        assert (internalEdge.getThis() == internalEdge2.getThis());
        assert (internalEdge != internalEdge2);
        this.graph.fireBeforePutIncidenceAfter(internalEdge2, internalEdge);
        if (internalEdge == internalEdge2 || internalEdge.getNextIncidenceInISeq() == internalEdge2) {
            this.graph.fireAfterPutIncidenceAfter(internalEdge2, internalEdge);
            return;
        }
        assert (this.getFirstIncidenceInISeq() != this.getLastIncidenceInISeq());
        if (internalEdge2 == this.getFirstIncidenceInISeq()) {
            this.setFirstIncidence(internalEdge2.getNextIncidenceInISeq());
            internalEdge2.getNextIncidenceInISeq().setPrevIncidenceInternal(null);
        } else if (internalEdge2 == this.getLastIncidenceInISeq()) {
            this.setLastIncidence(internalEdge2.getPrevIncidenceInISeq());
            internalEdge2.getPrevIncidenceInISeq().setNextIncidenceInternal(null);
        } else {
            internalEdge2.getPrevIncidenceInISeq().setNextIncidenceInternal(internalEdge2.getNextIncidenceInISeq());
            internalEdge2.getNextIncidenceInISeq().setPrevIncidenceInternal(internalEdge2.getPrevIncidenceInISeq());
        }
        if (internalEdge == this.getLastIncidenceInISeq()) {
            this.setLastIncidence(internalEdge2);
            internalEdge2.setNextIncidenceInternal(null);
        } else {
            internalEdge.getNextIncidenceInISeq().setPrevIncidenceInternal(internalEdge2);
            internalEdge2.setNextIncidenceInternal(internalEdge.getNextIncidenceInISeq());
        }
        internalEdge2.setPrevIncidenceInternal(internalEdge);
        internalEdge.setNextIncidenceInternal(internalEdge2);
        this.incidenceListModified();
        this.graph.fireAfterPutIncidenceAfter(internalEdge2, internalEdge);
    }

    @Override
    public final void putIncidenceBefore(InternalEdge internalEdge, InternalEdge internalEdge2) {
        assert (internalEdge != null && internalEdge2 != null);
        assert (internalEdge.isValid() && internalEdge2.isValid());
        assert (internalEdge.getGraph() == internalEdge2.getGraph());
        assert (internalEdge.getGraph() == this.getGraph());
        assert (internalEdge.getThis() == internalEdge2.getThis());
        assert (internalEdge != internalEdge2);
        this.graph.fireBeforePutIncidenceBefore(internalEdge2, internalEdge);
        if (internalEdge == internalEdge2 || internalEdge.getPrevIncidenceInISeq() == internalEdge2) {
            this.graph.fireAfterPutIncidenceBefore(internalEdge2, internalEdge);
            return;
        }
        assert (this.getFirstIncidenceInISeq() != this.getLastIncidenceInISeq());
        if (internalEdge2 == this.getFirstIncidenceInISeq()) {
            this.setFirstIncidence(internalEdge2.getNextIncidenceInISeq());
            internalEdge2.getNextIncidenceInISeq().setPrevIncidenceInternal(null);
        } else if (internalEdge2 == this.getLastIncidenceInISeq()) {
            this.setLastIncidence(internalEdge2.getPrevIncidenceInISeq());
            internalEdge2.getPrevIncidenceInISeq().setNextIncidenceInternal(null);
        } else {
            internalEdge2.getPrevIncidenceInISeq().setNextIncidenceInternal(internalEdge2.getNextIncidenceInISeq());
            internalEdge2.getNextIncidenceInISeq().setPrevIncidenceInternal(internalEdge2.getPrevIncidenceInISeq());
        }
        if (internalEdge == this.getFirstIncidenceInISeq()) {
            this.setFirstIncidence(internalEdge2);
            internalEdge2.setPrevIncidenceInternal(null);
        } else {
            InternalEdge internalEdge3 = internalEdge.getPrevIncidenceInISeq();
            internalEdge3.setNextIncidenceInternal(internalEdge2);
            internalEdge2.setPrevIncidenceInternal(internalEdge3);
        }
        internalEdge2.setNextIncidenceInternal(internalEdge);
        internalEdge.setPrevIncidenceInternal(internalEdge2);
        this.incidenceListModified();
        this.graph.fireAfterPutIncidenceBefore(internalEdge2, internalEdge);
    }

    @Override
    public abstract long getIncidenceListVersion();

    @Override
    public final boolean isIncidenceListModified(long l) {
        assert (this.isValid());
        return this.getIncidenceListVersion() != l;
    }

    @Override
    public final void incidenceListModified() {
        assert (this.isValid());
        this.setIncidenceListVersion(this.getIncidenceListVersion() + 1L);
    }

    @Override
    public final int getDegree(EdgeClass edgeClass) {
        assert (edgeClass != null);
        assert (this.isValid());
        return this.getDegree(edgeClass, EdgeDirection.INOUT);
    }

    @Override
    public final int getDegree(EdgeClass edgeClass, EdgeDirection edgeDirection) {
        assert (edgeClass != null);
        assert (this.isValid());
        int n = 0;
        for (Edge edge = this.getFirstIncidence(edgeClass, edgeDirection); edge != null; edge = edge.getNextIncidence(edgeClass, edgeDirection)) {
            ++n;
        }
        return n;
    }

    public String toString() {
        return "v" + this.id + ": " + this.getAttributedElementClass().getQualifiedName();
    }

    @Override
    public final int compareTo(AttributedElement<VertexClass, Vertex> attributedElement) {
        assert (attributedElement instanceof Vertex);
        if (this == attributedElement) {
            return 0;
        }
        Vertex vertex = (Vertex)attributedElement;
        assert (this.isValid() && vertex.isValid());
        assert (this.getGraph() == vertex.getGraph());
        int n = this.getId() - vertex.getId();
        if (n != 0) {
            return n;
        }
        return this.getGraph().compareTo(vertex.getGraph());
    }

    @Override
    public final Iterable<Edge> incidences() {
        assert (this.isValid());
        return new IncidenceIterable<Edge>(this);
    }

    @Override
    public final Iterable<Edge> incidences(EdgeDirection edgeDirection) {
        assert (this.isValid());
        return new IncidenceIterable<Edge>((Vertex)this, edgeDirection);
    }

    @Override
    public final Iterable<Edge> incidences(EdgeClass edgeClass, EdgeDirection edgeDirection) {
        assert (edgeClass != null);
        assert (this.isValid());
        return new IncidenceIterable<Edge>(this, edgeClass, edgeDirection);
    }

    @Override
    public final Iterable<Edge> incidences(EdgeClass edgeClass) {
        assert (edgeClass != null);
        assert (this.isValid());
        return new IncidenceIterable<Edge>((Vertex)this, edgeClass);
    }

    @Override
    public final Vertex getPrevVertex() {
        InternalVertex internalVertex;
        TraversalContext traversalContext = this.graph.getTraversalContext();
        if (traversalContext != null && internalVertex != null && !traversalContext.containsVertex(internalVertex)) {
            for (internalVertex = this.getPrevVertexInVSeq(); internalVertex != null && !traversalContext.containsVertex(internalVertex); internalVertex = internalVertex.getPrevVertexInVSeq()) {
            }
        }
        return internalVertex;
    }

    @Override
    public final void appendIncidenceToISeq(InternalEdge internalEdge) {
        assert (internalEdge != null);
        assert (internalEdge.getIncidentVertex() != this);
        internalEdge.setIncidentVertex(this);
        if (this.getFirstIncidenceInISeq() == null) {
            this.setFirstIncidence(internalEdge);
        }
        if (this.getLastIncidenceInISeq() != null) {
            this.getLastIncidenceInISeq().setNextIncidenceInternal(internalEdge);
            internalEdge.setPrevIncidenceInternal(this.getLastIncidenceInISeq());
        }
        this.setLastIncidence(internalEdge);
    }

    @Override
    public final void removeIncidenceFromISeq(InternalEdge internalEdge) {
        assert (internalEdge != null);
        assert (internalEdge.getIncidentVertex() == this);
        if (internalEdge == this.getFirstIncidenceInISeq()) {
            this.setFirstIncidence(internalEdge.getNextIncidenceInISeq());
            if (this.getFirstIncidenceInISeq() != null) {
                this.getFirstIncidenceInISeq().setPrevIncidenceInternal(null);
            }
            if (internalEdge == this.getLastIncidenceInISeq()) {
                this.setLastIncidence(null);
            }
        } else if (internalEdge == this.getLastIncidenceInISeq()) {
            this.setLastIncidence(internalEdge.getPrevIncidenceInISeq());
            if (this.getLastIncidenceInISeq() != null) {
                this.getLastIncidenceInISeq().setNextIncidenceInternal(null);
            }
        } else {
            internalEdge.getPrevIncidenceInISeq().setNextIncidenceInternal(internalEdge.getNextIncidenceInISeq());
            internalEdge.getNextIncidenceInISeq().setPrevIncidenceInternal(internalEdge.getPrevIncidenceInISeq());
        }
        internalEdge.setIncidentVertex(null);
        internalEdge.setNextIncidenceInternal(null);
        internalEdge.setPrevIncidenceInternal(null);
    }

    @Override
    public final void sortIncidences(Comparator<Edge> comparator) {
        Object object;
        assert (this.isValid());
        if (this.getFirstIncidenceInISeq() == null) {
            return;
        }
        final class IncidenceList {
            InternalEdge first;
            InternalEdge last;

            IncidenceList() {
            }

            public void add(InternalEdge internalEdge) {
                if (this.first == null) {
                    this.first = internalEdge;
                    assert (this.last == null);
                    this.last = internalEdge;
                } else {
                    internalEdge.setPrevIncidenceInternal(this.last);
                    this.last.setNextIncidenceInternal(internalEdge);
                    this.last = internalEdge;
                }
                internalEdge.setNextIncidenceInternal(null);
            }

            public InternalEdge remove() {
                if (this.first == null) {
                    throw new NoSuchElementException();
                }
                if (this.first == this.last) {
                    InternalEdge internalEdge = this.first;
                    this.first = null;
                    this.last = null;
                    return internalEdge;
                }
                InternalEdge internalEdge = this.first;
                this.first = internalEdge.getNextIncidenceInISeq();
                this.first.setPrevIncidenceInternal(null);
                return internalEdge;
            }

            public boolean isEmpty() {
                assert (this.first == null == (this.last == null));
                return this.first == null;
            }
        }
        Object object2 = new IncidenceList();
        IncidenceList incidenceList = new IncidenceList();
        Object object3 = object2;
        IncidenceList incidenceList2 = new IncidenceList();
        incidenceList2.first = this.getFirstIncidenceInISeq();
        incidenceList2.last = this.getLastIncidenceInISeq();
        InternalEdge internalEdge = incidenceList2.remove();
        ((IncidenceList)object3).add(internalEdge);
        while (!incidenceList2.isEmpty()) {
            object = incidenceList2.remove();
            if (comparator.compare((Edge)object, internalEdge) < 0) {
                object3 = object3 == object2 ? incidenceList : object2;
            }
            ((IncidenceList)object3).add((InternalEdge)object);
            internalEdge = object;
        }
        if (((IncidenceList)object2).isEmpty() || incidenceList.isEmpty()) {
            object3 = ((IncidenceList)object2).isEmpty() ? incidenceList : object2;
            this.setFirstIncidence(((IncidenceList)object3).first);
            this.setLastIncidence(((IncidenceList)object3).last);
            return;
        }
        while (true) {
            if (((IncidenceList)object2).isEmpty() || incidenceList.isEmpty()) {
                object3 = ((IncidenceList)object2).isEmpty() ? incidenceList : object2;
                this.setFirstIncidence(((IncidenceList)object3).first);
                this.setLastIncidence(((IncidenceList)object3).last);
                this.incidenceListModified();
                return;
            }
            object = new IncidenceList();
            IncidenceList incidenceList3 = new IncidenceList();
            object3 = object;
            internalEdge = null;
            while (!((IncidenceList)object2).isEmpty() && !incidenceList.isEmpty()) {
                int n;
                int n2 = internalEdge != null ? comparator.compare(((IncidenceList)object2).first, internalEdge) : 0;
                int n3 = n = internalEdge != null ? comparator.compare(incidenceList.first, internalEdge) : 0;
                if (n2 >= 0 && n >= 0) {
                    if (comparator.compare(((IncidenceList)object2).first, incidenceList.first) <= 0) {
                        internalEdge = ((IncidenceList)object2).remove();
                        ((IncidenceList)object3).add(internalEdge);
                        continue;
                    }
                    internalEdge = incidenceList.remove();
                    ((IncidenceList)object3).add(internalEdge);
                    continue;
                }
                if (n2 < 0 && n < 0) {
                    object3 = object3 == object ? incidenceList3 : object;
                    internalEdge = null;
                    continue;
                }
                if (n2 < 0 && n >= 0) {
                    internalEdge = incidenceList.remove();
                    ((IncidenceList)object3).add(internalEdge);
                    continue;
                }
                internalEdge = ((IncidenceList)object2).remove();
                ((IncidenceList)object3).add(internalEdge);
            }
            while (!((IncidenceList)object2).isEmpty()) {
                InternalEdge internalEdge2 = ((IncidenceList)object2).remove();
                if (comparator.compare(internalEdge2, internalEdge) < 0) {
                    object3 = object3 == object ? incidenceList3 : object;
                }
                ((IncidenceList)object3).add(internalEdge2);
                internalEdge = internalEdge2;
            }
            while (!incidenceList.isEmpty()) {
                InternalEdge internalEdge3 = incidenceList.remove();
                if (comparator.compare(internalEdge3, internalEdge) < 0) {
                    object3 = object3 == object ? incidenceList3 : object;
                }
                ((IncidenceList)object3).add(internalEdge3);
                internalEdge = internalEdge3;
            }
            object2 = object;
            incidenceList = incidenceList3;
        }
    }

    @Override
    public final List<? extends Vertex> adjacences(String string) {
        assert (string != null && string.length() > 0);
        assert (this.isValid());
        DirectedSchemaEdgeClass directedSchemaEdgeClass = this.getEdgeForRolename(string);
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        EdgeDirection edgeDirection = directedSchemaEdgeClass.getDirection();
        for (Edge edge : this.incidences(directedSchemaEdgeClass.getEdgeClass(), edgeDirection)) {
            arrayList.add(edge.getThat());
        }
        return arrayList;
    }

    @Override
    public final Edge addAdjacence(String string, Vertex vertex) {
        assert (string != null && string.length() > 0);
        assert (this.isValid());
        assert (vertex.isValid());
        assert (this.getGraph() == vertex.getGraph());
        DirectedSchemaEdgeClass directedSchemaEdgeClass = this.getEdgeForRolename(string);
        EdgeDirection edgeDirection = directedSchemaEdgeClass.getDirection();
        Vertex vertex2 = null;
        Vertex vertex3 = null;
        if (edgeDirection == EdgeDirection.IN) {
            vertex2 = vertex;
            vertex3 = this;
        } else {
            vertex3 = vertex;
            vertex2 = this;
        }
        return this.getGraph().createEdge(directedSchemaEdgeClass.getEdgeClass(), vertex2, vertex3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Vertex> removeAdjacences(String string) {
        assert (string != null && string.length() > 0);
        assert (this.isValid());
        TraversalContext traversalContext = this.getGraph().setTraversalContext(null);
        try {
            DirectedSchemaEdgeClass directedSchemaEdgeClass = this.getEdgeForRolename(string);
            ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
            ArrayList<Edge> arrayList2 = new ArrayList<Edge>();
            EdgeDirection edgeDirection = directedSchemaEdgeClass.getDirection();
            for (Edge edge : this.incidences(directedSchemaEdgeClass.getEdgeClass(), edgeDirection)) {
                arrayList2.add(edge);
                arrayList.add(edge.getThat());
            }
            for (Edge edge : arrayList2) {
                edge.delete();
            }
            ArrayList<Vertex> arrayList3 = arrayList;
            return arrayList3;
        }
        finally {
            this.getGraph().setTraversalContext(traversalContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAdjacence(String string, Vertex vertex) {
        assert (string != null && string.length() > 0);
        assert (this.isValid());
        assert (vertex.isValid());
        assert (this.getGraph() == vertex.getGraph());
        TraversalContext traversalContext = this.getGraph().setTraversalContext(null);
        try {
            DirectedSchemaEdgeClass directedSchemaEdgeClass = this.getEdgeForRolename(string);
            ArrayList<Edge> arrayList = new ArrayList<Edge>();
            EdgeDirection edgeDirection = directedSchemaEdgeClass.getDirection();
            for (Edge edge : this.incidences(directedSchemaEdgeClass.getEdgeClass(), edgeDirection)) {
                if (edge.getThat() != vertex) continue;
                arrayList.add(edge);
            }
            for (Edge edge : arrayList) {
                edge.delete();
            }
        }
        finally {
            this.getGraph().setTraversalContext(traversalContext);
        }
    }

    @Override
    public final DirectedSchemaEdgeClass getEdgeForRolename(String string) {
        return this.getAttributedElementClass().getDirectedEdgeClassForFarEndRole(string);
    }

    @Override
    public final <T extends Vertex> POrderedSet<T> reachableVertices(Class<T> clazz, PathElement ... pathElementArray) {
        PSet<Object> pSet = JGraLab.set();
        LinkedList<Vertex> linkedList = new LinkedList<Vertex>();
        linkedList.add(this);
        for (int i = 0; i < pathElementArray.length; ++i) {
            PathElement pathElement = pathElementArray[i];
            linkedList.add(null);
            Vertex vertex = (Vertex)linkedList.poll();
            while (vertex != null) {
                for (Edge edge : vertex.incidences(pathElement.edgeClass, pathElement.edgeDirection)) {
                    if (pathElement.strictType && (!pathElement.strictType || pathElement.edgeClass != edge.getAttributedElementClass())) continue;
                    if (i == pathElementArray.length - 1) {
                        Vertex vertex2 = edge.getThat();
                        if (!clazz.isInstance(vertex2)) continue;
                        pSet = pSet.plus(vertex2);
                        continue;
                    }
                    linkedList.add(edge.getThat());
                }
                vertex = (Vertex)linkedList.poll();
            }
        }
        return (POrderedSet)pSet;
    }
}

