/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

public class NextGraphElement
extends Function {
    public NextGraphElement() {
        super(2L, 1L, 1.0);
    }

    @Description(params={"e"}, description="Returns the next edge for a given element from the incidence sequence.", categories={Function.Category.GRAPH})
    public Edge evaluate(Edge edge) {
        return edge.getNextIncidence();
    }

    @Description(params={"e", "global"}, description="Returns the next edge for a given element. The boolean parameter $global$ decides if successor is taken from the global edge sequence (true), or from the incidence sequence (false).", categories={Function.Category.GRAPH})
    public Edge evaluate(Edge edge, Boolean bl) {
        return bl != false ? edge.getNextEdge() : edge.getNextIncidence();
    }

    @Description(params={"e", "global", "tc"}, description="Returns the next edge for a given element, restricted by a type collection. The boolean parameter $global$ decides if successor is taken from the global edge sequence (true), or from the incidence sequence (false).", categories={Function.Category.GRAPH})
    public Edge evaluate(Edge edge, Boolean bl, TypeCollection typeCollection) {
        if (bl.booleanValue()) {
            for (Edge edge2 = edge.getNextEdge(); edge2 != null; edge2 = edge2.getNextEdge()) {
                if (!typeCollection.acceptsType(edge2.getAttributedElementClass())) continue;
                return edge2;
            }
            return null;
        }
        return this.evaluate(edge, typeCollection);
    }

    @Description(params={"e", "tc"}, description="Returns the next edge for a given element, restricted by a type collection.", categories={Function.Category.GRAPH})
    public Edge evaluate(Edge edge, TypeCollection typeCollection) {
        for (Edge edge2 = edge.getNextIncidence(); edge2 != null; edge2 = edge2.getNextIncidence()) {
            if (!typeCollection.acceptsType(edge2.getAttributedElementClass())) continue;
            return edge2;
        }
        return null;
    }

    @Description(params={"v"}, description="Returns the next vertex for a given element.", categories={Function.Category.GRAPH})
    public Vertex evaluate(Vertex vertex) {
        return vertex.getNextVertex();
    }

    @Description(params={"v", "tc"}, description="Returns the next vertex for a given element, restricted by a type collection.", categories={Function.Category.GRAPH})
    public Vertex evaluate(Vertex vertex, TypeCollection typeCollection) {
        for (Vertex vertex2 = vertex.getNextVertex(); vertex2 != null; vertex2 = vertex2.getNextVertex()) {
            if (!typeCollection.acceptsType(vertex2.getAttributedElementClass())) continue;
            return vertex2;
        }
        return null;
    }
}

