/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.collections;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class SubCollection
extends Function {
    @Description(params={"coll", "startIndex", "endIndex"}, description="Returns a sub PVector starting at the given start index (including),\nand ending at the given end index (excluding).", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PVector<T> evaluate(PVector<T> pVector, Integer n, Integer n2) {
        if (n < 0 || n2 > pVector.size() || n > n2) {
            return null;
        }
        return pVector.subList(n, n2);
    }

    @Description(params={"coll", "startIndex"}, description="Returns a sub PVector starting at the given start index (including).", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PVector<T> evaluate(PVector<T> pVector, Integer n) {
        return this.evaluate(pVector, n, (Integer)pVector.size());
    }

    @Description(params={"coll", "startIndex", "endIndex"}, description="Returns a sub PSet starting at the given start index (including),\nand ending at the given end index (excluding).", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PSet<T> evaluate(PSet<T> pSet, Integer n, Integer n2) {
        if (n < 0 || n2 > pSet.size() || n > n2) {
            return null;
        }
        PSet pSet2 = JGraLab.set();
        int n3 = 0;
        for (Object e : pSet) {
            if (n3 == n2) break;
            if (n3 >= n && n3 < n2) {
                pSet2 = pSet2.plus(e);
            }
            ++n3;
        }
        return pSet2;
    }

    @Description(params={"coll", "startIndex"}, description="Returns a sub PSet starting at the given start index (including).", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public <T> PSet<T> evaluate(PSet<T> pSet, Integer n) {
        return this.evaluate(pSet, n, (Integer)pSet.size());
    }
}

