/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.TypeIdEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.IsArgumentOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeExprOf;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import java.util.ArrayList;

public class FunctionApplicationEvaluator
extends VertexEvaluator<FunctionApplication> {
    protected ArrayList<VertexEvaluator<? extends Expression>> parameterEvaluators = null;
    protected int paramEvalCount = 0;
    protected boolean listCreated = false;
    TypeCollection typeArgument = null;
    private String functionName = null;
    private FunLib.FunctionInfo fi = null;

    public String getFunctionName() {
        if (this.functionName == null) {
            FunctionId functionId = ((FunctionApplication)this.vertex).getFirstIsFunctionIdOfIncidence(EdgeDirection.IN).getAlpha();
            this.functionName = functionId.get_name();
        }
        return this.functionName;
    }

    public FunLib.FunctionInfo getFunctionInfo() {
        if (this.fi == null) {
            this.fi = FunLib.getFunctionInfo(this.getFunctionName());
            if (this.fi == null) {
                throw new GreqlException("Call to unknown function '" + this.getFunctionName() + "'");
            }
        }
        return this.fi;
    }

    public Function getFunction() {
        return this.getFunctionInfo().getFunction();
    }

    @Override
    public String getLoggingName() {
        return this.getFunctionName();
    }

    public FunctionApplicationEvaluator(FunctionApplication functionApplication, GreqlQueryImpl greqlQueryImpl) {
        super(functionApplication, greqlQueryImpl);
    }

    protected ArrayList<VertexEvaluator<? extends Expression>> createVertexEvaluatorList() {
        ArrayList<VertexEvaluator<? extends Expression>> arrayList = new ArrayList<VertexEvaluator<? extends Expression>>();
        for (IsArgumentOf isArgumentOf = ((FunctionApplication)this.vertex).getFirstIsArgumentOfIncidence(EdgeDirection.IN); isArgumentOf != null; isArgumentOf = isArgumentOf.getNextIsArgumentOfIncidence(EdgeDirection.IN)) {
            Expression expression = isArgumentOf.getAlpha();
            VertexEvaluator<Expression> vertexEvaluator = this.query.getVertexEvaluator(expression);
            arrayList.add(vertexEvaluator);
        }
        return arrayList;
    }

    public TypeCollection createTypeArgument(InternalGreqlEvaluator internalGreqlEvaluator) {
        IsTypeExprOf isTypeExprOf = ((FunctionApplication)this.vertex).getFirstIsTypeExprOfIncidence(EdgeDirection.IN);
        if (isTypeExprOf == null) {
            return null;
        }
        TypeCollection typeCollection = TypeCollection.empty();
        while (isTypeExprOf != null) {
            TypeId typeId = (TypeId)isTypeExprOf.getAlpha();
            TypeIdEvaluator typeIdEvaluator = (TypeIdEvaluator)this.query.getVertexEvaluator(typeId);
            typeCollection = typeCollection.combine((TypeCollection)typeIdEvaluator.getResult(internalGreqlEvaluator));
            isTypeExprOf = isTypeExprOf.getNextIsTypeExprOfIncidence(EdgeDirection.IN);
        }
        try {
            typeCollection = typeCollection.bindToSchema(internalGreqlEvaluator);
        }
        catch (UnknownTypeException unknownTypeException) {
            throw new UnknownTypeException(unknownTypeException.getTypeName(), this.createPossibleSourcePositions());
        }
        return typeCollection;
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator internalGreqlEvaluator) {
        internalGreqlEvaluator.progress(this.getOwnEvaluationCosts());
        FunLib.FunctionInfo functionInfo = this.getFunctionInfo();
        if (!this.listCreated) {
            this.typeArgument = this.createTypeArgument(internalGreqlEvaluator);
            this.parameterEvaluators = this.createVertexEvaluatorList();
            this.paramEvalCount = this.parameterEvaluators.size();
            this.listCreated = true;
        }
        if (this.typeArgument != null) {
            this.typeArgument = this.typeArgument.bindToSchema(internalGreqlEvaluator);
        }
        int n = this.parameterEvaluators.size();
        if (functionInfo.needsGraphArgument()) {
            ++n;
        }
        if (this.typeArgument != null) {
            ++n;
        }
        if (functionInfo.needsEvaluatorArgument()) {
            ++n;
        }
        Object[] objectArray = new Object[n];
        int n2 = 0;
        if (functionInfo.needsEvaluatorArgument()) {
            objectArray[n2++] = internalGreqlEvaluator;
        }
        if (functionInfo.needsGraphArgument()) {
            objectArray[n2++] = internalGreqlEvaluator.getGraph();
        }
        for (int i = 0; i < this.paramEvalCount; ++i) {
            objectArray[n2] = this.parameterEvaluators.get(i).getResult(internalGreqlEvaluator);
            if (objectArray[n2] instanceof NFA) {
                objectArray[n2] = ((NFA)objectArray[n2]).getDFA();
            }
            ++n2;
        }
        if (this.typeArgument != null) {
            objectArray[n2] = this.typeArgument;
        }
        return FunLib.apply(functionInfo, objectArray);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        Object object;
        FunctionApplication functionApplication = (FunctionApplication)this.getVertex();
        long l = 0L;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (IsArgumentOf isArgumentOf = functionApplication.getFirstIsArgumentOfIncidence(EdgeDirection.IN); isArgumentOf != null; isArgumentOf = isArgumentOf.getNextIsArgumentOfIncidence(EdgeDirection.IN)) {
            object = this.query.getVertexEvaluator(isArgumentOf.getAlpha());
            l += ((VertexEvaluator)object).getCurrentSubtreeEvaluationCosts();
            arrayList.add(((VertexEvaluator)object).getEstimatedCardinality());
        }
        object = this.getFunction();
        long l2 = ((Function)object).getEstimatedCosts(arrayList);
        long l3 = l2 * this.getVariableCombinations();
        long l4 = l3 + l;
        return new VertexCosts(l2, l3, l4);
    }

    @Override
    public double calculateEstimatedSelectivity() {
        Function function = this.getFunction();
        if (function != null) {
            return function.getSelectivity();
        }
        return 1.0;
    }

    @Override
    public long calculateEstimatedCardinality() {
        Object object;
        FunctionApplication functionApplication = (FunctionApplication)this.getVertex();
        int n = 0;
        for (IsArgumentOf isArgumentOf = functionApplication.getFirstIsArgumentOfIncidence(EdgeDirection.IN); isArgumentOf != null; isArgumentOf = isArgumentOf.getNextIsArgumentOfIncidence(EdgeDirection.IN)) {
            object = this.query.getVertexEvaluator(isArgumentOf.getAlpha());
            n = (int)((long)n + ((VertexEvaluator)object).getEstimatedCardinality());
        }
        object = this.getFunction();
        if (object != null) {
            return ((Function)object).getEstimatedCardinality(n);
        }
        return 1L;
    }
}

