/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.search.visitors;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitor;
import de.uni_koblenz.jgralab.algolib.visitors.GraphVisitorList;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import java.util.ArrayList;
import java.util.List;

public class SearchVisitorList
extends GraphVisitorList
implements SearchVisitor {
    private List<SearchVisitor> visitors = new ArrayList<SearchVisitor>();

    @Override
    public void addVisitor(Visitor visitor) {
        super.addVisitor(visitor);
        if (visitor instanceof SearchVisitor && !this.visitors.contains(visitor)) {
            this.visitors.add((SearchVisitor)visitor);
        }
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        super.removeVisitor(visitor);
        if (visitor instanceof SearchVisitor) {
            this.visitors.remove(visitor);
        }
    }

    @Override
    public void clearVisitors() {
        super.clearVisitors();
        this.visitors.clear();
    }

    @Override
    public void visitFrond(Edge edge) throws AlgorithmTerminatedException {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).visitFrond(edge);
        }
    }

    @Override
    public void visitRoot(Vertex vertex) throws AlgorithmTerminatedException {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).visitRoot(vertex);
        }
    }

    @Override
    public void visitTreeEdge(Edge edge) throws AlgorithmTerminatedException {
        int n = this.visitors.size();
        for (int i = 0; i < n; ++i) {
            this.visitors.get(i).visitTreeEdge(edge);
        }
    }
}

