/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.search;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.search.SearchAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.DFSVisitorList;
import de.uni_koblenz.jgralab.algolib.functions.ArrayPermutation;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.functions.Permutation;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import de.uni_koblenz.jgralab.graphmarker.IntegerVertexMarker;

public abstract class DepthFirstSearch
extends SearchAlgorithm {
    protected DFSVisitorList visitors;
    protected int rNum;
    protected IntFunction<Vertex> rnumber;
    protected Vertex[] rorder;

    public DepthFirstSearch(Graph graph, BooleanFunction<Edge> booleanFunction) {
        super(graph, booleanFunction);
    }

    public DepthFirstSearch(Graph graph) {
        this(graph, null);
    }

    @Override
    public void reset() {
        super.reset();
        this.visitors.reset();
        this.rNum = 1;
        this.rorder = this.rorder == null ? null : new Vertex[this.graph.getVCount() + 1];
        this.rnumber = new IntegerVertexMarker(this.graph);
        this.number = new IntegerVertexMarker(this.graph);
    }

    @Override
    public DepthFirstSearch withLevel() {
        super.withLevel();
        return this;
    }

    @Override
    public DepthFirstSearch withNumber() {
        this.checkStateForSettingParameters();
        super.withNumber();
        return this;
    }

    @Override
    public DepthFirstSearch withENumber() {
        this.checkStateForSettingParameters();
        super.withENumber();
        return this;
    }

    @Override
    public DepthFirstSearch withParent() {
        super.withParent();
        return this;
    }

    public DepthFirstSearch withRorder() {
        this.checkStateForSettingParameters();
        this.rorder = new Vertex[this.graph.getVCount() + 1];
        return this;
    }

    @Override
    public DepthFirstSearch withoutLevel() {
        super.withoutLevel();
        return this;
    }

    @Override
    public DepthFirstSearch withoutNumber() {
        this.checkStateForSettingParameters();
        throw new UnsupportedOperationException("The result \"number\" is mandatory for DFS and cannot be deactivated.");
    }

    @Override
    public DepthFirstSearch withoutENumber() {
        this.checkStateForSettingParameters();
        super.withoutENumber();
        return this;
    }

    @Override
    public DepthFirstSearch withoutParent() {
        super.withoutParent();
        return this;
    }

    public DepthFirstSearch withoutRorder() {
        this.checkStateForSettingParameters();
        this.rorder = null;
        return this;
    }

    @Override
    public DepthFirstSearch normal() {
        super.normal();
        return this;
    }

    @Override
    public DepthFirstSearch reversed() {
        super.reversed();
        return this;
    }

    @Override
    public DepthFirstSearch undirected() {
        super.undirected();
        return this;
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.visitors = new DFSVisitorList();
    }

    @Override
    public void disableOptionalResults() {
        this.checkStateForSettingParameters();
        this.level = null;
        this.parent = null;
        this.rorder = null;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        visitor.setAlgorithm(this);
        this.visitors.addVisitor(visitor);
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        this.visitors.removeVisitor(visitor);
    }

    public Vertex[] getInternalRorder() {
        return this.rorder;
    }

    public int getRNum() {
        return this.rNum;
    }

    public IntFunction<Vertex> getInternalRnumber() {
        return this.rnumber;
    }

    public IntFunction<Vertex> getRnumber() {
        this.checkStateForResult();
        return this.rnumber;
    }

    public Permutation<Vertex> getRorder() {
        this.checkStateForResult();
        return this.rorder == null ? null : new ArrayPermutation<Vertex>(this.rorder);
    }
}

