/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class StringListPreferences {
    protected ArrayList<String> entries;
    private Preferences prefs;
    private String key;

    public StringListPreferences(Preferences preferences, String string) {
        this.prefs = preferences;
        this.key = string;
    }

    public void setEntries(List<String> list) {
        this.entries.clear();
        this.entries.addAll(list);
        this.save();
    }

    public List<String> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public int size() {
        return this.entries.size();
    }

    public String get(int n) {
        return this.entries.get(n);
    }

    public boolean contains(String string) {
        return this.entries.contains(string);
    }

    public int indexOf(String string) {
        return this.entries.indexOf(string);
    }

    public void sort() {
        Collections.sort(this.entries);
        this.save();
    }

    public void add(int n, String string) {
        this.entries.add(n, string);
        this.save();
    }

    public void add(String string) {
        this.entries.add(string);
        this.save();
    }

    public void remove(String string) {
        while (this.entries.remove(string)) {
        }
        this.save();
    }

    public String remove(int n) {
        String string = this.entries.remove(n);
        this.save();
        return string;
    }

    public void clear() {
        this.entries.clear();
        this.save();
    }

    public void save() {
        int n;
        for (n = 0; n < this.entries.size(); ++n) {
            this.prefs.put(this.key + n, this.entries.get(n));
        }
        while (this.prefs.get(this.key + n, null) != null) {
            this.prefs.remove(this.key + n);
            ++n;
        }
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void load(int n) {
        String string;
        this.entries = new ArrayList();
        for (int i = 0; i < n && (string = this.prefs.get(this.key + i, null)) != null; ++i) {
            this.entries.add(string);
        }
    }

    public void load() {
        this.load(Integer.MAX_VALUE);
    }
}

