/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.csvreader;

import de.uni_koblenz.ist.utilities.csvreader.CsvReaderException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CsvReader {
    public static final int WITHOUT_FIELDNAMES = 0;
    public static final int WITH_FIELDNAMES = 1;
    private static final Pattern commentLine = Pattern.compile("^\\s*#.*$");
    private LineNumberReader reader;
    private ArrayList<String> fieldNames;
    private ArrayList<String> currentRecord;
    private String separators;
    private String quote;
    private char stringDelimiter = (char)34;
    private boolean quoting;

    public CsvReader(Reader reader, int n) throws IOException {
        this(reader, ";", "", n);
    }

    public CsvReader(Reader reader) throws IOException {
        this(reader, ";", "", 0);
    }

    public CsvReader(Reader reader, String string, String string2) throws IOException {
        this(reader, string, string2, 0);
    }

    public CsvReader(Reader reader, String string, String string2, int n) throws IOException {
        this.reader = new LineNumberReader(reader);
        this.separators = string;
        this.quote = string2;
        this.currentRecord = new ArrayList();
        boolean bl = this.quoting = !string2.equals("");
        if (n == 1) {
            this.readFieldNames();
        }
    }

    public int getLineNumber() {
        return this.reader.getLineNumber();
    }

    public void readFieldNames() throws IOException {
        if (this.readRecord()) {
            this.fieldNames = new ArrayList<String>(this.currentRecord);
        }
    }

    public boolean readRecord() throws IOException {
        String string;
        do {
            if ((string = this.reader.readLine()) != null) continue;
            return false;
        } while (commentLine.matcher(string).matches());
        this.currentRecord.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.separators + this.quote, true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.quoting && string2.equals(this.quote)) {
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = stringTokenizer.nextToken();
                stringBuilder.append(string2);
                continue;
            }
            if (this.separators.indexOf(string2) >= 0) {
                this.currentRecord.add(this.removeStringDelimiters(stringBuilder));
                stringBuilder = new StringBuilder();
                continue;
            }
            stringBuilder.append(string2);
        }
        this.currentRecord.add(this.removeStringDelimiters(stringBuilder));
        return true;
    }

    public String removeStringDelimiters(StringBuilder stringBuilder) {
        String string = stringBuilder.toString().trim();
        if (string.length() > 0) {
            if (string.charAt(0) == this.stringDelimiter) {
                string = string.substring(1);
            }
            if (string.length() > 0 && string.charAt(string.length() - 1) == this.stringDelimiter) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public String getFieldByName(String string) throws CsvReaderException {
        if (this.fieldNames == null) {
            throw new CsvReaderException("field name lookup disabled because field names were not read");
        }
        int n = this.fieldNames.indexOf(string);
        if (n < 0) {
            throw new NoSuchElementException("unknown field name: \"" + string + "\"");
        }
        return this.currentRecord.get(n);
    }

    public String getFieldAt(int n) {
        return this.currentRecord.get(n);
    }

    public int getFieldCount() {
        return this.currentRecord.size();
    }

    public List<String> getCurrentRecord() {
        return new ArrayList<String>(this.currentRecord);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

