/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import org.pcollections.PMap;
import org.pcollections.PSet;

public final class MapPSet<E>
extends AbstractSet<E>
implements PSet<E> {
    private final PMap<E, Object> map;

    public static <E> MapPSet<E> from(PMap<E, ?> pMap) {
        return new MapPSet<E>(pMap);
    }

    public static <E> MapPSet<E> from(PMap<E, ?> pMap, E e) {
        return MapPSet.from(pMap).plus((Object)e);
    }

    public static <E> MapPSet<E> from(PMap<E, ?> pMap, Collection<? extends E> collection) {
        return MapPSet.from(pMap).plusAll((Collection)collection);
    }

    private MapPSet(PMap<E, Object> pMap) {
        this.map = pMap;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public MapPSet<E> plus(E e) {
        if (this.contains(e)) {
            return this;
        }
        return new MapPSet<E>(this.map.plus(e, (Object)In.IN));
    }

    @Override
    public MapPSet<E> minus(Object object) {
        if (!this.contains(object)) {
            return this;
        }
        return new MapPSet<E>(this.map.minus(object));
    }

    @Override
    public MapPSet<E> plusAll(Collection<? extends E> collection) {
        PMap<E, Object> pMap = this.map;
        for (E e : collection) {
            pMap = pMap.plus(e, (Object)In.IN);
        }
        return MapPSet.from(pMap);
    }

    @Override
    public MapPSet<E> minusAll(Collection<?> collection) {
        PMap<E, Object> pMap = this.map.minusAll(collection);
        return MapPSet.from(pMap);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    private static enum In {
        IN;

    }
}

