/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgschema2java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SchemaJarGenerator {
    private String path;
    private String packageName;
    private String jarFileName;
    private int storeMethod;

    public SchemaJarGenerator(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public SchemaJarGenerator(String string, String string2, String string3, boolean bl) {
        this.path = string;
        this.packageName = string2;
        this.jarFileName = string3;
        this.storeMethod = bl ? 0 : 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJar() throws Exception {
        ZipOutputStream zipOutputStream = null;
        try {
            System.out.println("Jar file name is: " + this.jarFileName);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(this.path + "/" + this.jarFileName));
            zipOutputStream.setMethod(this.storeMethod);
            String string = this.packageName.replaceAll("\\.", "/");
            File file = new File(this.path + "/" + string);
            this.putDirInJar(zipOutputStream, file.getAbsolutePath(), string + "/");
            this.putDirInJar(zipOutputStream, file.getAbsolutePath() + "/impl", string + "/impl/");
            zipOutputStream.closeEntry();
        }
        finally {
            zipOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putDirInJar(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        File[] fileArray;
        ZipEntry zipEntry = new ZipEntry(string2);
        zipOutputStream.putNextEntry(zipEntry);
        for (File file : fileArray = new File(string).listFiles()) {
            if (file.getName().startsWith(".") || file.isDirectory()) continue;
            ZipEntry zipEntry2 = new ZipEntry(string2 + "/" + file.getName());
            zipOutputStream.putNextEntry(zipEntry2);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                int n = 0;
                byte[] byArray = new byte[4096];
                while ((n = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                fileInputStream.close();
            }
        }
        zipOutputStream.closeEntry();
    }
}

