/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.argouml2tg;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.entries.FunctionEntry;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.BooleanGraphMarker;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.graphmarker.IntegerVertexMarker;
import de.uni_koblenz.jgralab.graphvalidator.ConstraintViolation;
import de.uni_koblenz.jgralab.graphvalidator.GraphValidator;
import de.uni_koblenz.jgralab.grumlschema.GrumlSchema;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.BooleanDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.ListDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.MapDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.SetDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.AggregationKind;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.Attribute;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Package;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesEdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesVertexClass;
import de.uni_koblenz.jgralab.grumlschema.structure.VertexClass;
import de.uni_koblenz.jgralab.utilities.rsa2tg.ProcessingException;
import de.uni_koblenz.jgralab.utilities.rsa2tg.SchemaGraph2Tg;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import de.uni_koblenz.jgralab.utilities.xml2tg.Xml2Tg;
import de.uni_koblenz.jgralab.utilities.xml2tg.XmlGraphUtilities;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Element;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.HasChild;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.pcollections.PVector;

public class ArgoUml2Tg
extends Xml2Tg {
    private final Logger logger = JGraLab.getLogger(ArgoUml2Tg.class);
    private static final String OPTION_FILENAME_VALIDATION = "r";
    private static final String OPTION_FILENAME_SCHEMA_GRAPH = "s";
    private static final String OPTION_FILENAME_DOT = "e";
    private static final String OPTION_FILENAME_SCHEMA = "o";
    private static final String OPTION_USE_NAVIGABILITY = "n";
    private static final String OPTION_REMOVE_UNUSED_DOMAINS = "u";
    private static final String OPTION_KEEP_EMPTY_PACKAGES = "k";
    private static final String OPTION_USE_ROLE_NAME = "f";
    private boolean useFromRole;
    private boolean removeUnusedDomains;
    private boolean keepEmptyPackages;
    private boolean useNavigability;
    private boolean suppressOutput;
    private String filenameSchema;
    private String filenameSchemaGraph;
    private String filenameDot;
    private String filenameValidation;
    static final String ST_GRAPHCLASS = "-64--88-111--125-2048530b:13717182953:-8000:0000000000000D6A";
    static final String ST_RECORD = "-64--88-111--125-2048530b:13717182953:-8000:0000000000000D6B";
    static final String ST_ABSTRACT = "-64--88-111--125-2048530b:13717182953:-8000:0000000000000D6C";
    static final String DT_DOUBLE = "-115-26-95--20--17a78cb8:13718617229:-8000:0000000000000D76";
    static final String DT_INTEGER = "-115-26-95--20--17a78cb8:13718617229:-8000:00000000000019DA";
    static final String DT_UML_INTEGER = "-84-17--56-5-43645a83:11466542d86:-8000:000000000000087C";
    static final String DT_LONG = "-115-26-95--20--17a78cb8:13718617229:-8000:0000000000000D77";
    static final String DT_BOOLEAN = "-115-26-95--20--17a78cb8:13718617229:-8000:00000000000019DB";
    static final String DT_STRING = "-115-26-95--20--17a78cb8:13718617229:-8000:00000000000019DC";
    static final String DT_UML_STRING = "-84-17--56-5-43645a83:11466542d86:-8000:000000000000087E";
    static final String TV_UML_DERIVED = "-64--88-0-101--2259be85:11dd526880c:-8000:000000000000E4A7";
    private XmlGraphUtilities xu;
    private HashMap<String, Vertex> qnMap;
    private HashMap<String, Package> packageMap;
    private HashMap<String, Domain> domainMap;
    private HashMap<String, Domain> profileIdMap;
    private HashMap<String, Vertex> xmiIdMap;
    private SchemaGraph sg;
    private Schema schema;
    private Package defaultPackage;
    private GraphClass graphClass;

    public static void main(String[] stringArray) throws IOException {
        boolean bl;
        System.out.println("ArgoUML to TG");
        System.out.println("=========");
        JGraLab.setLogLevel(Level.OFF);
        CommandLine commandLine = ArgoUml2Tg.processCommandLineOptions(stringArray);
        assert (commandLine != null) : "No CommandLine object has been generated!";
        File file = new File(commandLine.getOptionValue('i'));
        ArgoUml2Tg argoUml2Tg = new ArgoUml2Tg();
        argoUml2Tg.setUseFromRole(commandLine.hasOption(OPTION_USE_ROLE_NAME));
        argoUml2Tg.setRemoveUnusedDomains(commandLine.hasOption(OPTION_REMOVE_UNUSED_DOMAINS));
        argoUml2Tg.setKeepEmptyPackages(commandLine.hasOption(OPTION_KEEP_EMPTY_PACKAGES));
        argoUml2Tg.setUseNavigability(commandLine.hasOption(OPTION_USE_NAVIGABILITY));
        argoUml2Tg.setFilenameSchema(commandLine.getOptionValue(OPTION_FILENAME_SCHEMA));
        argoUml2Tg.setFilenameSchemaGraph(commandLine.getOptionValue(OPTION_FILENAME_SCHEMA_GRAPH));
        argoUml2Tg.setFilenameDot(commandLine.getOptionValue(OPTION_FILENAME_DOT));
        argoUml2Tg.setFilenameValidation(commandLine.getOptionValue(OPTION_FILENAME_VALIDATION));
        boolean bl2 = bl = !commandLine.hasOption(OPTION_FILENAME_SCHEMA) && !commandLine.hasOption(OPTION_FILENAME_SCHEMA_GRAPH) && !commandLine.hasOption(OPTION_FILENAME_DOT) && !commandLine.hasOption(OPTION_FILENAME_VALIDATION);
        if (bl) {
            System.out.println("No output option has been selected. A TG-file for the Schema will be written.");
            argoUml2Tg.setFilenameSchema(ArgoUml2Tg.createFilename(file));
        }
        try {
            argoUml2Tg.process(file.getPath());
        }
        catch (Exception exception) {
            System.err.println("An Exception occured while processing " + file + ".");
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        System.out.println("Fini.");
    }

    public static CommandLine processCommandLineOptions(String[] stringArray) {
        String string = "java " + ArgoUml2Tg.class.getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option(OPTION_FILENAME_VALIDATION, "report", true, "(optional): writes a validation report to the given filename. Free naming, but should look like this: '<filename>.html'");
        option.setRequired(false);
        option.setArgName("filename");
        optionHandler.addOption(option);
        Option option2 = new Option(OPTION_FILENAME_DOT, "export", true, "(optional): writes a GraphViz DOT file to the given filename. Free naming, but should look like this: '<filename>.dot'");
        option2.setRequired(false);
        option2.setArgName("filename");
        optionHandler.addOption(option2);
        Option option3 = new Option(OPTION_FILENAME_SCHEMA_GRAPH, "schemaGraph", true, "(optional): writes a TG-file of the Schema as graph instance to the given filename. Free naming, but should look like this:  '<filename>.tg'");
        option3.setRequired(false);
        option3.setArgName("filename");
        optionHandler.addOption(option3);
        Option option4 = new Option("i", "input", true, "(required): UML 1.2-XMI exchange model file of the Schema.");
        option4.setRequired(true);
        option4.setArgName("filename");
        optionHandler.addOption(option4);
        Option option5 = new Option(OPTION_FILENAME_SCHEMA, "output", true, "(optional): writes a TG-file of the Schema to the given filename. Free naming, but should look like this: '<filename>.argouml.tg.'");
        option5.setRequired(false);
        option5.setArgName("filename");
        optionHandler.addOption(option5);
        Option option6 = new Option(OPTION_USE_ROLE_NAME, "useFromRole", false, "(optional): if this flag is set, the name of from roles will be used for creating undefined EdgeClass names.");
        option6.setRequired(false);
        optionHandler.addOption(option6);
        Option option7 = new Option(OPTION_REMOVE_UNUSED_DOMAINS, "removeUnusedDomains", false, "(optional): if this flag is set, all unused domains be deleted.");
        option7.setRequired(false);
        optionHandler.addOption(option7);
        Option option8 = new Option(OPTION_KEEP_EMPTY_PACKAGES, "keepEmptyPackages", false, "(optional): if this flag is set, empty packages will be retained.");
        option7.setRequired(false);
        optionHandler.addOption(option8);
        Option option9 = new Option(OPTION_USE_NAVIGABILITY, "useNavigability", false, "(optional): if this flag is set, navigability information will be interpreted as reading direction.");
        option9.setRequired(false);
        optionHandler.addOption(option9);
        return optionHandler.parse(stringArray);
    }

    public static String createFilename(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(file.getParent());
        stringBuilder.append(File.separatorChar);
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        stringBuilder.append(string);
        stringBuilder.append(".argouml.tg");
        return stringBuilder.toString();
    }

    public ArgoUml2Tg() {
        this.setIgnoreCharacters(false);
        this.addIgnoredElements("XMI.header");
        this.addIdAttributes("*/xmi.id");
        this.addIdRefAttributes("*/xmi.idref");
    }

    @Override
    public void process(String string) throws FileNotFoundException, XMLStreamException {
        this.defaultPackage = null;
        this.graphClass = null;
        this.domainMap = new HashMap();
        this.packageMap = new HashMap();
        this.profileIdMap = new HashMap();
        this.qnMap = new HashMap();
        this.xmiIdMap = new HashMap();
        this.schema = null;
        this.sg = null;
        System.out.println("Process " + string + "...");
        super.process(string);
        this.convertToTg(this.getFilenameSchema());
    }

    private void convertToTg(String string) {
        this.qnMap = new HashMap();
        this.packageMap = new HashMap();
        this.domainMap = new HashMap();
        this.profileIdMap = new HashMap();
        this.xmiIdMap = new HashMap();
        this.xu = new XmlGraphUtilities(this.getXmlGraph());
        Element element = this.xu.firstChildWithName(this.xu.firstChildWithName(this.xu.getRootElement(), "XMI.content"), "UML:Model");
        String string2 = this.xu.getAttributeValue(element, "name");
        this.sg = GrumlSchema.instance().createSchemaGraph(ImplementationType.STANDARD, string2 + "#" + this.xu.getAttributeValue(element, "xmi.id"), 100, 100);
        this.schema = this.sg.createSchema();
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "A Schema must have a package prefix!\nProcessed qualified name: " + string2);
        }
        this.schema.set_name(string2.substring(n + 1));
        this.schema.set_packagePrefix(string2.substring(0, n));
        this.defaultPackage = this.sg.createPackage();
        this.defaultPackage.set_qualifiedName("");
        this.sg.createContainsDefaultPackage(this.schema, this.defaultPackage);
        this.packageMap.put("", this.defaultPackage);
        this.createPrimitiveDomains();
        this.createEnumDomains();
        this.createRecordDomains();
        this.createGraphClass();
        this.createVertexClasses();
        this.createEdgeClasses();
        this.createGeneralizations();
        this.createCommentsAndConstraints();
        this.removeRedundantGeneralization();
        this.checkAttributes();
        if (this.isRemoveUnusedDomains()) {
            this.removeUnusedDomains();
        }
        this.handlesEmptyPackages();
        if (!this.suppressOutput) {
            try {
                this.writeOutput();
            }
            catch (GraphIOException graphIOException) {
                throw new RuntimeException(graphIOException);
            }
        }
    }

    private void checkAttributes() {
        GraphClass graphClass = this.sg.getFirstGraphClass();
        HashMap<String, AttributedElementClass> hashMap = new HashMap<String, AttributedElementClass>();
        for (Attribute vertex : graphClass.get_attributes()) {
            if (hashMap.containsKey(vertex)) {
                throw new RuntimeException("Attribute " + vertex.get_name() + " at " + graphClass.get_qualifiedName() + " is duplicate.");
            }
            hashMap.put(vertex.get_name(), graphClass);
        }
        for (GraphElementClass graphElementClass : this.sg.getGraphElementClassVertices()) {
            boolean bl = graphElementClass.isInstanceOf(VertexClass.VC);
            hashMap = new HashMap();
            BooleanGraphMarker booleanGraphMarker = new BooleanGraphMarker(this.sg);
            LinkedList<AttributedElementClass> linkedList = new LinkedList<AttributedElementClass>();
            linkedList.add(graphElementClass);
            while (!linkedList.isEmpty()) {
                AttributedElementClass attributedElementClass;
                GraphElementClass graphElementClass2 = (GraphElementClass)linkedList.poll();
                if (booleanGraphMarker.isMarked(graphElementClass2)) continue;
                for (Attribute attribute : graphElementClass2.get_attributes()) {
                    if (hashMap.containsKey(attribute.get_name())) {
                        attributedElementClass = (AttributedElementClass)hashMap.get(attribute.get_name());
                        throw new RuntimeException("The name of the " + (attributedElementClass == graphElementClass && graphElementClass2 != graphElementClass ? "" : "inherited ") + "attribute " + attribute.get_name() + " of " + (bl ? "VertexClass" : "EdgeClass") + " " + attributedElementClass.get_qualifiedName() + (graphElementClass2 == graphElementClass ? " is duplicate" : " is the same name as the inherited attribute of " + (bl ? "VertexClass" : "EdgeClass") + " " + graphElementClass2.get_qualifiedName()) + ".");
                    }
                    hashMap.put(attribute.get_name(), graphElementClass2);
                }
                booleanGraphMarker.mark(graphElementClass2);
                for (Edge edge : graphElementClass2.incidences(bl ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT)) {
                    attributedElementClass = (GraphElementClass)edge.getThat();
                    if (booleanGraphMarker.isMarked(attributedElementClass)) continue;
                    linkedList.add(attributedElementClass);
                }
            }
        }
    }

    private void removeRedundantGeneralization() {
        Iterator<GraphElementClass> iterator = this.sg.getGraphElementClassVertices().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            GraphElementClass graphElementClass;
            boolean bl = (graphElementClass = iterator.next()).isInstanceOf(VertexClass.VC);
            if (graphElementClass.getDegree(bl ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT) <= 1) continue;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            IntegerVertexMarker integerVertexMarker = new IntegerVertexMarker(this.sg);
            GraphMarker<Object> graphMarker = new GraphMarker<Object>(this.sg);
            integerVertexMarker.mark(graphElementClass, 0);
            Object object3 = graphElementClass.getFirstIncidence(bl ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
            while (object3 != null) {
                object2 = object3.getNextIncidence(bl ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
                object = (GraphElementClass)object3.getThat();
                if (object == this) {
                    object3.delete();
                } else if (integerVertexMarker.isMarked(object)) {
                    object3.delete();
                } else {
                    linkedList.add(object);
                    integerVertexMarker.mark(object, 1);
                    graphMarker.mark(object, object3);
                }
                object3 = object2;
            }
            while (!linkedList.isEmpty()) {
                object2 = (GraphElementClass)linkedList.poll();
                object = object2.getFirstIncidence(bl ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
                int n = integerVertexMarker.get(object2) + 1;
                Edge edge = (Edge)graphMarker.get(object2);
                while (object != null) {
                    Edge edge2 = object.getNextIncidence(bl ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
                    GraphElementClass graphElementClass2 = (GraphElementClass)object.getThat();
                    if (integerVertexMarker.isMarked(graphElementClass2)) {
                        int n2 = integerVertexMarker.getMark(graphElementClass2);
                        if (n > n2) {
                            linkedList.add(graphElementClass2);
                            integerVertexMarker.mark(graphElementClass2, n);
                            graphMarker.mark(graphElementClass2, edge);
                        }
                    } else {
                        linkedList.add(graphElementClass2);
                        integerVertexMarker.mark(graphElementClass2, n);
                        graphMarker.mark(graphElementClass2, edge);
                    }
                    object = edge2;
                }
            }
            object2 = new HashSet();
            for (FunctionEntry functionEntry : graphMarker) {
                object2.add(functionEntry.getSecond());
            }
            object3 = graphElementClass.getFirstIncidence(bl ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
            while (object3 != null) {
                Edge edge = object3.getNextIncidence(bl ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
                if (!object2.contains(object3)) {
                    object3.delete();
                }
                object3 = edge;
            }
        }
    }

    private void removeUnusedDomains() {
        System.out.println("Removing unused domains...");
        Domain domain = this.sg.getFirstDomain();
        while (domain != null) {
            Domain domain2 = domain.getNextDomain();
            if (domain.getDegree(EdgeDirection.IN) - domain.getDegree(Annotates.EC, EdgeDirection.IN) <= 1) {
                this.logger.fine("...remove unused domain '" + domain.get_qualifiedName() + "'");
                List<? extends Comment> list = domain.remove_comments();
                for (Comment comment : list) {
                    comment.delete();
                }
                domain.delete();
                domain = this.sg.getFirstDomain();
                continue;
            }
            domain = domain2;
        }
    }

    public void writeOutput() throws GraphIOException {
        boolean bl = false;
        if (this.filenameDot != null) {
            try {
                this.printTypeAndFilename("GraphvViz DOT file", this.filenameDot);
                this.writeDotFile(this.filenameDot);
                bl = true;
            }
            catch (IOException iOException) {
                System.out.println("Could not create DOT file.");
                System.out.println("Exception was " + iOException);
            }
        }
        if (this.filenameSchemaGraph != null) {
            this.printTypeAndFilename("schemagraph", this.filenameSchemaGraph);
            this.writeSchemaGraph(this.filenameSchemaGraph);
            bl = true;
        }
        this.validateGraph(this.filenameValidation);
        if (this.filenameValidation != null) {
            bl = true;
        }
        if (this.filenameSchema != null) {
            this.printTypeAndFilename("schema", this.filenameSchema);
            this.writeSchema(this.filenameSchema);
            bl = true;
        }
        if (!bl) {
            System.out.println("No files have been created.");
        }
    }

    private void writeDotFile(String string) throws IOException {
        Tg2Dot tg2Dot = new Tg2Dot();
        tg2Dot.setGraph(this.sg);
        tg2Dot.setPrintEdgeAttributes(true);
        tg2Dot.setOutputFile(string);
        tg2Dot.convert();
    }

    private void writeSchemaGraph(String string) throws GraphIOException {
        this.sg.save(string);
    }

    private void writeSchema(String string) {
        try {
            SchemaGraph2Tg schemaGraph2Tg = new SchemaGraph2Tg(this.sg, string);
            schemaGraph2Tg.process();
        }
        catch (IOException iOException) {
            throw new RuntimeException("SchemaGraph2Tg failed with an IOException!", iOException);
        }
    }

    private void printTypeAndFilename(String string, String string2) {
        System.out.println("Writing " + string + " to: " + string2);
    }

    private boolean validateGraph(String string) {
        if (string != null) {
            this.printTypeAndFilename("validation report", string);
        }
        System.out.println("Validate schema graph...");
        GraphValidator graphValidator = new GraphValidator(this.sg);
        SortedSet<ConstraintViolation> sortedSet = graphValidator.validate();
        if (sortedSet.size() > 0) {
            try {
                System.out.println("Schema graph is invalid. Please look at " + string);
                graphValidator.createValidationReport(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private void handlesEmptyPackages() {
        if (!this.isKeepEmptyPackages()) {
            System.out.println("Remove empty packages...");
            Package package_ = this.sg.getFirstPackage();
            int n = 0;
            while (package_ != null) {
                Package package_2 = package_.getNextPackage();
                int n2 = package_.getDegree(Annotates.EC);
                if (package_.getDegree() - n2 == 1 && package_.get_qualifiedName().length() > 0) {
                    this.logger.fine("\t- empty package '" + package_.get_qualifiedName() + "' removed" + (n2 > 0 ? (n2 == 1 ? " including 1 comment" : " including " + n2 + " comments") : ""));
                    if (n2 > 0) {
                        Annotates annotates = package_.getFirstAnnotatesIncidence();
                        while (annotates != null) {
                            annotates.getThat().delete();
                            annotates = package_.getFirstAnnotatesIncidence();
                        }
                    }
                    package_.delete();
                    ++n;
                    package_ = this.sg.getFirstPackage();
                    continue;
                }
                package_ = package_2;
            }
            this.logger.fine("Removed " + n + " package" + (n == 1 ? "" : OPTION_FILENAME_SCHEMA_GRAPH) + ".");
        } else {
            System.out.println("Create empty packages...");
            for (Element element : this.xu.elementsWithName("UML:Package")) {
                String string = this.getQualifiedName(element, false);
                if (!this.packageMap.containsKey(string)) {
                    this.logger.fine("Created empty package " + string + ".");
                }
                this.getPackage(string);
            }
        }
    }

    private void createCommentsAndConstraints() {
        for (Element element : this.xu.elementsWithName("UML:Comment")) {
            String string;
            if (!this.xu.hasAttribute(element, "body")) continue;
            NamedElement namedElement = null;
            Element element2 = this.xu.firstChildWithName(element, "UML:Comment.annotatedElement");
            if (element2 == null) {
                namedElement = this.graphClass;
            } else {
                assert (element2.getDegree(HasChild.EC, EdgeDirection.OUT) == 1);
                element2 = (Element)element2.getFirstHasChildIncidence(EdgeDirection.OUT).getThat();
                assert (element2.get_name().equals("UML:Class") || element2.get_name().equals("UML:AssociationClass") || element2.get_name().equals("UML:Association") || element2.get_name().equals("UML:Enumeration") || element2.get_name().equals("UML:Package"));
                element2 = this.xu.getReferencedElement(element2, "xmi.idref");
                assert (element2 != null);
                string = this.getQualifiedName(element2, !element2.get_name().equals("UML:Package"));
                namedElement = (NamedElement)this.qnMap.get(string);
                if (namedElement == null) {
                    namedElement = this.graphClass;
                }
            }
            string = this.xu.getAttributeValue(element, "body");
            if (namedElement.isInstanceOf(AttributedElementClass.VC) && this.addGreqlConstraint((AttributedElementClass)namedElement, string)) continue;
            Comment comment = this.sg.createComment();
            comment.set_text(string);
            this.sg.createAnnotates(comment, namedElement);
        }
    }

    private boolean addGreqlConstraint(AttributedElementClass attributedElementClass, String string) {
        if (!(string = string.trim()).startsWith("{") || !string.endsWith("}")) {
            return false;
        }
        string = string.substring(1, string.length() - 1).trim();
        assert (attributedElementClass != null);
        Constraint constraint = this.sg.createConstraint();
        int n = 0;
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (bl) {
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (!bl2 && c == '\"') {
                    ++n;
                    String string2 = string.substring(n2 + 1, i).trim().replaceAll("\\\\(.)", "$1");
                    if (string2.isEmpty()) {
                        string2 = null;
                    }
                    switch (n) {
                        case 1: {
                            constraint.set_message(string2);
                            break;
                        }
                        case 2: {
                            constraint.set_predicateQuery(string2);
                            break;
                        }
                        case 3: {
                            constraint.set_offendingElementsQuery(string2);
                            break;
                        }
                        default: {
                            constraint.delete();
                            return false;
                        }
                    }
                    bl = false;
                    continue;
                }
                if (!bl2 || c != '\"') continue;
                bl2 = false;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            if (c == '\"') {
                bl = true;
                n2 = i;
                continue;
            }
            constraint.delete();
            return false;
        }
        if (bl || bl2 || n < 2 || n > 3) {
            constraint.delete();
            return false;
        }
        this.sg.createHasConstraint(attributedElementClass, constraint);
        return true;
    }

    private void createGeneralizations() {
        this.logger.fine("Creating generalization:");
        for (Element element : this.xu.elementsWithName("UML:Generalization")) {
            if (!this.xu.hasAttribute(element, "xmi.id")) continue;
            Element element2 = this.xu.firstChildWithName(element, "UML:Generalization.child");
            Element element3 = this.xu.firstChildWithName(element2, "UML:Class");
            if (element3 == null) {
                element3 = this.xu.firstChildWithName(element2, "UML:Association");
            }
            if (element3 == null) {
                element3 = this.xu.firstChildWithName(element2, "UML:AssociationClass");
            }
            if (element3 == null) {
                throw new RuntimeException("Unexpected Generalization child " + element);
            }
            element2 = element3;
            Vertex vertex = this.xmiIdMap.get(this.xu.getAttributeValue(element2, "xmi.idref"));
            assert (vertex != null);
            Element element4 = this.xu.firstChildWithName(element, "UML:Generalization.parent");
            element3 = this.xu.firstChildWithName(element4, "UML:Class");
            if (element3 == null) {
                element3 = this.xu.firstChildWithName(element4, "UML:Association");
            }
            if (element3 == null) {
                element3 = this.xu.firstChildWithName(element4, "UML:AssociationClass");
            }
            if (element3 == null) {
                throw new RuntimeException("Unexpected Generalization parent " + element);
            }
            element4 = element3;
            Vertex vertex2 = this.xmiIdMap.get(this.xu.getAttributeValue(element4, "xmi.idref"));
            assert (vertex2 != null);
            assert (vertex.getAttributedElementClass() == vertex2.getAttributedElementClass());
            if (vertex2.isInstanceOf(VertexClass.VC)) {
                this.sg.createSpecializesVertexClass((VertexClass)vertex, (VertexClass)vertex2);
                this.logger.fine("\t" + ((VertexClass)vertex).get_qualifiedName() + ": " + ((VertexClass)vertex2).get_qualifiedName());
                continue;
            }
            if (vertex2.isInstanceOf(EdgeClass.VC)) {
                this.logger.fine("\t" + ((EdgeClass)vertex).get_qualifiedName() + ": " + ((EdgeClass)vertex2).get_qualifiedName());
                EdgeClass edgeClass = (EdgeClass)vertex;
                EdgeClass edgeClass2 = (EdgeClass)vertex2;
                this.sg.createSpecializesEdgeClass(edgeClass, edgeClass2);
                continue;
            }
            throw new RuntimeException("Unexpected generalization between " + vertex2.getSchemaClass().getName() + " vertices.");
        }
    }

    private void createGraphClass() {
        for (Element element : this.xu.elementsWithName("UML:Class")) {
            if (!this.hasStereotype(element, ST_GRAPHCLASS)) continue;
            assert (!this.hasStereotype(element, ST_ABSTRACT));
            assert (!this.hasStereotype(element, ST_RECORD));
            if (this.graphClass != null) {
                throw new RuntimeException("Multiple classes marked with <<graphclass>>, only one is allowed. Offending element: " + element + " (name=" + this.xu.getAttributeValue(element, "name") + ")");
            }
            this.graphClass = this.sg.createGraphClass();
            this.sg.createDefinesGraphClass(this.schema, this.graphClass);
            this.graphClass.set_qualifiedName(this.xu.getAttributeValue(element, "name", true));
            this.qnMap.put(this.graphClass.get_qualifiedName(), this.graphClass);
            this.xmiIdMap.put(this.xu.getAttributeValue(element, "xmi.id"), this.graphClass);
            this.logger.fine("GraphClass " + this.graphClass.get_qualifiedName());
            this.createAttributes(element, this.graphClass);
        }
    }

    private void createEdgeClasses() {
        for (Element element : this.xu.elementsWithName("UML:Association")) {
            if (!this.xu.hasAttribute(element, "xmi.id") || this.isDerived(element)) continue;
            this.createEdgeClass(element);
        }
        for (Element element : this.xu.elementsWithName("UML:AssociationClass")) {
            if (!this.xu.hasAttribute(element, "xmi.id") || this.isDerived(element)) continue;
            this.createEdgeClass(element);
        }
    }

    private void createEdgeClass(Element element) {
        Package package_ = this.getPackage(this.getPackageName(element));
        String string = this.getQualifiedName(element, true);
        assert (string != null && !string.isEmpty()) : "The EdgeClass " + this.xu.getAttributeValue(element, "xmi.id") + " must have a name.";
        String string2 = this.xu.getAttributeValue(element, "name", true);
        if (string2.length() == 0) {
            string2 = null;
        }
        boolean bl = this.hasStereotype(element, ST_ABSTRACT) || this.xu.hasAttribute(element, "isAbstract") && this.xu.getAttributeValue(element, "isAbstract").equals("true");
        this.logger.fine((bl ? "abstract " : "") + "EdgeClass " + (string2 != null ? string : "<<name will be generated>>"));
        EdgeClass edgeClass = this.sg.createEdgeClass();
        edgeClass.set_abstract(bl);
        this.sg.createContainsGraphElementClass(package_, edgeClass);
        this.createAttributes(element, edgeClass);
        Element element2 = this.xu.firstChildWithName(element, "UML:Association.connection");
        assert (element2 != null);
        Iterator<Element> iterator = this.xu.childrenWithName(element2, "UML:AssociationEnd").iterator();
        assert (iterator.hasNext());
        Element element3 = iterator.next();
        IncidenceClass incidenceClass = this.createIncidenceClass(element3);
        assert (iterator.hasNext());
        Element element4 = iterator.next();
        IncidenceClass incidenceClass2 = this.createIncidenceClass(element4);
        if (this.useNavigability) {
            boolean bl2;
            boolean bl3 = this.xu.hasAttribute(element3, "isNavigable") && this.xu.getAttributeValue(element3, "isNavigable").equals("true");
            boolean bl4 = bl2 = this.xu.hasAttribute(element4, "isNavigable") && this.xu.getAttributeValue(element4, "isNavigable").equals("true");
            if (bl3 && !bl2) {
                IncidenceClass incidenceClass3 = incidenceClass;
                incidenceClass = incidenceClass2;
                incidenceClass2 = incidenceClass3;
            }
        }
        AggregationKind aggregationKind = incidenceClass.get_aggregation();
        incidenceClass.set_aggregation(incidenceClass2.get_aggregation());
        incidenceClass2.set_aggregation(aggregationKind);
        edgeClass.add_from(incidenceClass);
        edgeClass.add_to(incidenceClass2);
        if (string2 == null) {
            String string3 = incidenceClass2.get_roleName();
            if (string3 == null || string3.equals("")) {
                string3 = ((VertexClass)incidenceClass2.getFirstEndsAtIncidence().getThat()).get_qualifiedName();
                int n = string3.lastIndexOf(46);
                if (n >= 0) {
                    string3 = string3.substring(n + 1);
                }
            } else {
                string3 = Character.toUpperCase(string3.charAt(0)) + string3.substring(1);
            }
            if (string3 == null || string3.length() <= 0) {
                throw new RuntimeException("Undefined 'to' role name for EdgeClass " + edgeClass);
            }
            string2 = incidenceClass.get_aggregation() != AggregationKind.NONE || incidenceClass2.get_aggregation() != AggregationKind.NONE ? (incidenceClass2.get_aggregation() != AggregationKind.NONE ? "Contains" + string3 : "IsPartOf" + string3) : "LinksTo" + string3;
            if (this.useFromRole) {
                String string4 = incidenceClass.get_roleName();
                if (string4 == null || string4.equals("")) {
                    string4 = ((VertexClass)incidenceClass.getFirstEndsAtIncidence().getThat()).get_qualifiedName();
                    int n = string4.lastIndexOf(46);
                    if (n >= 0) {
                        string4 = string4.substring(n + 1);
                    }
                } else {
                    string4 = Character.toUpperCase(string4.charAt(0)) + string4.substring(1);
                }
                if (string4 == null || string4.length() == 0) {
                    throw new RuntimeException("Undefined 'from' role name for EdgeClass " + edgeClass);
                }
                string2 = string4 + string2;
            }
            string = package_.get_qualifiedName() + "." + string2;
        }
        edgeClass.set_qualifiedName(string);
        assert (this.qnMap.get(string) == null) : "There already exists an EdgeClass with name: " + string;
        this.qnMap.put(string, edgeClass);
        this.xmiIdMap.put(this.xu.getAttributeValue(element, "xmi.id"), edgeClass);
    }

    private IncidenceClass createIncidenceClass(Element element) {
        IncidenceClass incidenceClass = this.sg.createIncidenceClass();
        String string = this.xu.hasAttribute(element, "name") ? this.xu.getAttributeValue(element, "name") : "";
        incidenceClass.set_roleName(string.trim());
        String string2 = this.xu.getAttributeValue(element, "aggregation");
        if (string2.equals("none")) {
            incidenceClass.set_aggregation(AggregationKind.NONE);
        } else if (string2.equals("aggregate")) {
            incidenceClass.set_aggregation(AggregationKind.SHARED);
        } else if (string2.equals("composite")) {
            incidenceClass.set_aggregation(AggregationKind.COMPOSITE);
        } else {
            throw new RuntimeException("Unexpected aggregation value '" + string2 + "'");
        }
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        Element element2 = this.xu.firstChildWithName(element, "UML:AssociationEnd.multiplicity");
        if (element2 != null) {
            element2 = this.xu.firstChildWithName(element2, "UML:Multiplicity");
        }
        if (element2 != null) {
            element2 = this.xu.firstChildWithName(element2, "UML:Multiplicity.range");
        }
        if (element2 != null) {
            element2 = this.xu.firstChildWithName(element2, "UML:MultiplicityRange");
        }
        if (element2 != null) {
            n = Integer.parseInt(this.xu.getAttributeValue(element2, "lower"));
            n2 = Integer.parseInt(this.xu.getAttributeValue(element2, "upper"));
            if (n2 < 0) {
                n2 = Integer.MAX_VALUE;
            }
        }
        incidenceClass.set_min(n);
        incidenceClass.set_max(n2);
        Element element3 = this.xu.firstChildWithName(element, "UML:AssociationEnd.participant");
        assert (element3 != null);
        VertexClass vertexClass = (VertexClass)this.xmiIdMap.get(this.xu.getAttributeValue(this.xu.firstChildWithName(element3, "UML:Class"), "xmi.idref"));
        incidenceClass.add_targetclass(vertexClass);
        this.checkMultiplicities(incidenceClass);
        return incidenceClass;
    }

    private void checkMultiplicities(IncidenceClass incidenceClass) {
        int n = incidenceClass.get_min();
        int n2 = incidenceClass.get_max();
        assert (n >= 0);
        assert (n2 > 0);
        if (n == Integer.MAX_VALUE) {
            throw new ProcessingException(this.getFileName(), "Error in multiplicities: lower bound must not be * at association end " + incidenceClass);
        }
        if (n > n2) {
            throw new ProcessingException(this.getFileName(), "Error in multiplicities: lower bound (" + n + ") must be <= upper bound (" + n2 + ") at association end " + incidenceClass);
        }
    }

    private void createVertexClasses() {
        for (Element element : this.xu.elementsWithName("UML:Class")) {
            if (!this.xu.hasAttribute(element, "name") || this.hasStereotype(element, ST_RECORD) || this.hasStereotype(element, ST_GRAPHCLASS) || this.isDerived(element)) continue;
            boolean bl = this.hasStereotype(element, ST_ABSTRACT) || this.xu.hasAttribute(element, "isAbstract") && this.xu.getAttributeValue(element, "isAbstract").equals("true");
            Package package_ = this.getPackage(this.getPackageName(element));
            String string = this.getQualifiedName(element, true);
            assert (string != null && !string.isEmpty()) : "The VertexClass " + this.xu.getAttributeValue(element, "xmi.id") + " must have a name.";
            assert (this.qnMap.get(string) == null);
            this.logger.fine((bl ? "abstract " : "") + "VertexClass " + string);
            VertexClass vertexClass = this.sg.createVertexClass();
            vertexClass.set_qualifiedName(string);
            vertexClass.set_abstract(bl);
            this.sg.createContainsGraphElementClass(package_, vertexClass);
            this.qnMap.put(string, vertexClass);
            this.xmiIdMap.put(this.xu.getAttributeValue(element, "xmi.id"), vertexClass);
            this.createAttributes(element, vertexClass);
        }
    }

    private void createAttributes(Element element, AttributedElementClass attributedElementClass) {
        Element element2 = this.xu.firstChildWithName(element, "UML:Classifier.feature");
        if (element2 != null) {
            for (Element element3 : this.xu.childrenWithName(element2, "UML:Attribute")) {
                if (this.isDerived(element3)) continue;
                Domain domain = this.getAttributeDomain(element3);
                assert (domain != null);
                this.logger.fine("\t" + this.xu.getAttributeValue(element3, "name") + ": " + domain.get_qualifiedName());
                Attribute attribute = this.sg.createAttribute();
                attribute.set_name(this.xu.getAttributeValue(element3, "name"));
                attribute.set_defaultValue(this.getDefaultValue(element3, domain));
                attribute.add_domain(domain);
                attributedElementClass.add_attributes(attribute);
            }
        }
    }

    private boolean isDerived(Element element) {
        Element element2 = this.xu.firstChildWithName(element, "UML:ModelElement.taggedValue");
        if (element2 == null) {
            return false;
        }
        for (Element element3 : this.xu.childrenWithName(element2, "UML:TaggedValue")) {
            Element element4 = this.xu.firstChildWithName(element3, "UML:TaggedValue.type");
            Element element5 = this.xu.firstChildWithName(element4, "UML:TagDefinition");
            if (!this.xu.getAttributeValue(element5, "href").endsWith("#-64--88-0-101--2259be85:11dd526880c:-8000:000000000000E4A7")) continue;
            Element element6 = this.xu.firstChildWithName(element3, "UML:TaggedValue.dataValue");
            return !this.xu.getText(element6).equals("false");
        }
        return false;
    }

    private String getDefaultValue(Element element, Domain domain) {
        Element element2 = this.xu.firstChildWithName(element, "UML:Attribute.initialValue");
        if (element2 == null) {
            return null;
        }
        Element element3 = this.xu.firstChildWithName(element2, "UML:Expression");
        assert (element3 != null);
        String string = this.xu.getAttributeValue(element3, "body");
        if (string != null) {
            if (domain.isInstanceOf(BooleanDomain.VC) && (string.equals("true") || string.equals("false"))) {
                string = string.substring(0, 1);
            }
            if (string.equals("null")) {
                string = OPTION_USE_NAVIGABILITY;
            }
        }
        return string;
    }

    private void createRecordDomains() {
        for (Element element : this.xu.elementsWithName("UML:Class")) {
            if (!this.hasStereotype(element, ST_RECORD)) continue;
            assert (!this.hasStereotype(element, ST_GRAPHCLASS));
            assert (!this.hasStereotype(element, ST_ABSTRACT));
            Package package_ = this.getPackage(this.getPackageName(element));
            String string = this.getQualifiedName(element, true);
            assert (string != null && !string.isEmpty()) : "The RecordDomain " + this.xu.getAttributeValue(element, "xmi.id") + " must have a name.";
            RecordDomain recordDomain = (RecordDomain)this.domainMap.get(string);
            if (recordDomain == null) {
                assert (this.qnMap.get(string) == null);
                recordDomain = this.sg.createRecordDomain();
                recordDomain.set_qualifiedName(string);
                this.sg.createContainsDomain(package_, recordDomain);
                this.qnMap.put(string, recordDomain);
                this.domainMap.put(string, recordDomain);
                this.xmiIdMap.put(this.xu.getAttributeValue(element, "xmi.id"), recordDomain);
            }
            this.logger.fine("RecordDomain " + string);
            Element element2 = this.xu.firstChildWithName(element, "UML:Classifier.feature");
            if (element2 == null) continue;
            for (Element element3 : this.xu.childrenWithName(element2, "UML:Attribute")) {
                this.logger.fine("\t" + this.xu.getAttributeValue(element3, "name"));
                Domain domain = this.getAttributeDomain(element3);
                assert (domain != null);
                HasRecordDomainComponent hasRecordDomainComponent = this.sg.createHasRecordDomainComponent(recordDomain, domain);
                hasRecordDomainComponent.set_name(this.xu.getAttributeValue(element3, "name"));
            }
        }
    }

    private Domain getAttributeDomain(Element element) {
        Element element2 = this.xu.firstChildWithName(element, "UML:StructuralFeature.type");
        assert (element2 != null);
        Element element3 = this.xu.firstChildWithName(element2, "UML:DataType");
        if (element3 != null) {
            if (this.xu.hasAttribute(element3, "xmi.idref")) {
                Element element4 = this.xu.getReferencedElement(element3, "xmi.idref");
                return this.createCompositeDomain(this.xu.getAttributeValue(element4, "name"));
            }
            if (this.xu.hasAttribute(element3, "href")) {
                return this.getPrimitiveDomainByProfileId(this.xu.getAttributeValue(element3, "href"));
            }
            throw new RuntimeException("FIXME: Unhandled UML:DataType");
        }
        element3 = this.xu.firstChildWithName(element2, "UML:Enumeration");
        if (element3 != null) {
            return (Domain)this.xmiIdMap.get(this.xu.getAttributeValue(element3, "xmi.idref"));
        }
        element3 = this.xu.firstChildWithName(element2, "UML:Class");
        if (element3 != null) {
            Vertex vertex = this.xmiIdMap.get(this.xu.getAttributeValue(element3, "xmi.idref"));
            if (vertex != null) {
                assert (vertex.isInstanceOf(RecordDomain.VC));
                return (Domain)vertex;
            }
            Element element5 = this.xu.getReferencedElement(element3, "xmi.idref");
            assert (element5.get_name().equals("UML:Class") && this.hasStereotype(element5, ST_RECORD) && !this.hasStereotype(element5, ST_ABSTRACT) && !this.hasStereotype(element5, ST_GRAPHCLASS)) : element3;
            Package package_ = this.getPackage(this.getPackageName(element5));
            String string = this.getQualifiedName(element5, true);
            assert (string != null && !string.isEmpty()) : "The domain of attribute " + this.xu.getAttributeValue(element5, "xmi.id") + " must have a name.";
            RecordDomain recordDomain = this.sg.createRecordDomain();
            recordDomain.set_qualifiedName(string);
            this.domainMap.put(string, recordDomain);
            this.qnMap.put(string, recordDomain);
            this.xmiIdMap.put(this.xu.getAttributeValue(element5, "xmi.id"), recordDomain);
            this.sg.createContainsDomain(package_, recordDomain);
            return recordDomain;
        }
        throw new RuntimeException("FIXME: Unhandled UML:DataType");
    }

    private Domain createCompositeDomain(String string) {
        Domain domain = this.domainMap.get(string = string.trim().replaceAll("\\s+", ""));
        if (domain != null) {
            return domain;
        }
        this.logger.fine("CompositeDomain " + string);
        if (string.startsWith("Map<")) {
            int n;
            MapDomain mapDomain = this.sg.createMapDomain();
            domain = mapDomain;
            int n2 = 0;
            for (n = 4; n < string.length(); ++n) {
                char c = string.charAt(n);
                if (n2 == 0 && c == ',') break;
                if (c == '<') {
                    ++n2;
                    continue;
                }
                if (c != '>') continue;
                --n2;
            }
            String string2 = string.substring(4, n);
            String string3 = string.substring(n + 1, string.length() - 1);
            mapDomain.add_keydomain(this.createCompositeDomain(string2));
            mapDomain.add_valuedomain(this.createCompositeDomain(string3));
        } else if (string.startsWith("List<")) {
            ListDomain listDomain = this.sg.createListDomain();
            domain = listDomain;
            String string4 = string.substring(5, string.length() - 1);
            listDomain.add_basedomain(this.createCompositeDomain(string4));
        } else if (string.startsWith("Set<")) {
            SetDomain setDomain = this.sg.createSetDomain();
            domain = setDomain;
            String string5 = string.substring(4, string.length() - 1);
            setDomain.add_basedomain(this.createCompositeDomain(string5));
        } else {
            throw new RuntimeException("Unknown domain name '" + string + "'");
        }
        domain.set_qualifiedName(string.replaceAll(",", ", "));
        this.domainMap.put(string, domain);
        this.sg.createContainsDomain(this.defaultPackage, domain);
        return domain;
    }

    private Domain getPrimitiveDomainByProfileId(String string) {
        int n = string.indexOf(35);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return this.profileIdMap.get(string);
    }

    private boolean hasStereotype(Element element, String string) {
        Element element2 = this.xu.firstChildWithName(element, "UML:ModelElement.stereotype");
        if (element2 == null) {
            return false;
        }
        element2 = this.xu.firstChildWithName(element2, "UML:Stereotype");
        return this.xu.getAttributeValue(element2, "href").endsWith("#" + string);
    }

    private void createPrimitiveDomains() {
        this.createPrimitiveDomain(this.sg.createBooleanDomain(), "Boolean", DT_BOOLEAN);
        this.createPrimitiveDomain(this.sg.createIntegerDomain(), "Integer", DT_INTEGER, DT_UML_INTEGER);
        this.createPrimitiveDomain(this.sg.createLongDomain(), "Long", DT_LONG);
        this.createPrimitiveDomain(this.sg.createDoubleDomain(), "Double", DT_DOUBLE);
        this.createPrimitiveDomain(this.sg.createStringDomain(), "String", DT_STRING, DT_UML_STRING);
    }

    private void createPrimitiveDomain(Domain domain, String string, String ... stringArray) {
        this.logger.fine("PrimitiveDomain " + string);
        domain.set_qualifiedName(string);
        this.sg.createContainsDomain(this.packageMap.get(""), domain);
        for (String string2 : stringArray) {
            this.profileIdMap.put(string2, domain);
        }
        this.domainMap.put(string, domain);
        this.qnMap.put(string, domain);
    }

    private void createEnumDomains() {
        for (Element element : this.xu.elementsWithName("UML:Enumeration")) {
            if (!this.xu.hasAttribute(element, "xmi.id")) continue;
            String string = this.getQualifiedName(element, true);
            assert (string != null && !string.isEmpty()) : "The EnumDomain " + this.xu.getAttributeValue(element, "xmi.id") + " must have a name.";
            assert (this.qnMap.get(string) == null);
            this.logger.fine("EnumDomain " + string);
            EnumDomain enumDomain = this.sg.createEnumDomain();
            enumDomain.set_qualifiedName(string);
            this.domainMap.put(string, enumDomain);
            this.qnMap.put(string, enumDomain);
            this.xmiIdMap.put(this.xu.getAttributeValue(element, "xmi.id"), enumDomain);
            this.sg.createContainsDomain(this.getPackage(this.getPackageName(element)), enumDomain);
            Element element2 = this.xu.firstChildWithName(element, "UML:Enumeration.literal");
            PVector<String> pVector = JGraLab.vector();
            for (Element element3 : this.xu.childrenWithName(element2, "UML:EnumerationLiteral")) {
                String string2 = this.xu.getAttributeValue(element3, "name");
                this.logger.fine("\t" + string2);
                pVector = pVector.plus(string2);
            }
            enumDomain.set_enumConstants(pVector);
        }
    }

    private String getQualifiedName(Element element, boolean bl) {
        String string = this.getPackageName(element);
        Package package_ = this.getPackage(string);
        String string2 = this.xu.getAttributeValue(element, "name", bl);
        return package_ == this.defaultPackage ? string2 : package_.get_qualifiedName() + "." + string2;
    }

    private Package getPackage(String string) {
        Package package_ = this.packageMap.get(string);
        if (package_ == null) {
            if (string.length() == 0) {
                package_ = this.packageMap.get("");
            } else {
                package_ = this.sg.createPackage();
                package_.set_qualifiedName(string);
                int n = string.lastIndexOf(46);
                Package package_2 = this.getPackage(n < 0 ? "" : string.substring(0, n));
                package_2.add_subpackages(package_);
                this.packageMap.put(string, package_);
                this.qnMap.put(string, package_);
            }
        }
        return package_;
    }

    private String getPackageName(Element element) {
        String string = "";
        for (element = element.get_parent(); element != null; element = element.get_parent()) {
            if (!element.get_name().equals("UML:Package")) continue;
            string = string.length() == 0 ? this.xu.getAttributeValue(element, "name") : this.xu.getAttributeValue(element, "name") + "." + string;
        }
        return string;
    }

    public void setUseFromRole(boolean bl) {
        this.useFromRole = bl;
    }

    public boolean isUseFromRole() {
        return this.useFromRole;
    }

    public void setRemoveUnusedDomains(boolean bl) {
        this.removeUnusedDomains = bl;
    }

    public boolean isRemoveUnusedDomains() {
        return this.removeUnusedDomains;
    }

    public void setUseNavigability(boolean bl) {
        this.useNavigability = bl;
    }

    public boolean isUseNavigability() {
        return this.useNavigability;
    }

    public SchemaGraph getSchemaGraph() {
        return this.sg;
    }

    public void setSuppressOutput(boolean bl) {
        this.suppressOutput = bl;
    }

    public String getFilenameSchema() {
        return this.filenameSchema;
    }

    public void setFilenameSchema(String string) {
        this.filenameSchema = string;
    }

    public String getFilenameSchemaGraph() {
        return this.filenameSchemaGraph;
    }

    public void setFilenameSchemaGraph(String string) {
        this.filenameSchemaGraph = string;
    }

    public String getFilenameDot() {
        return this.filenameDot;
    }

    public void setFilenameDot(String string) {
        this.filenameDot = string;
    }

    public String getFilenameValidation() {
        return this.filenameValidation;
    }

    public void setFilenameValidation(String string) {
        this.filenameValidation = string;
    }

    public boolean isKeepEmptyPackages() {
        return this.keepEmptyPackages;
    }

    public void setKeepEmptyPackages(boolean bl) {
        this.keepEmptyPackages = bl;
    }
}

