/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.tools.ant.Task;

public class RetrieveVersion
extends Task {
    public final String VERSION_FILENAME = "version.properties";
    private static final String MAJOR = "major";
    private static final String MINOR = "minor";
    private static final String MICRO = "micro";
    private static final String CODENAME = "codename";
    private static final String HEAD = "head";
    private final Properties prop = new Properties();
    protected String major;
    protected String minor;
    protected String micro;
    protected String head;
    protected String codename;

    private void checkExisting(File file) {
        if (!file.exists() || !file.canRead()) {
            throw new RuntimeException(file.getAbsolutePath() + " doesn't exist!");
        }
    }

    protected void setHEAD() {
        File file = new File(this.getProject().getBaseDir() + File.separator + ".git" + File.separator + "HEAD");
        this.checkExisting(file);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            int n = string.indexOf(32);
            string = string.substring(n + 1).replace('/', File.separatorChar);
            bufferedReader.close();
            File file2 = new File(this.getProject().getBaseDir() + File.separator + ".git" + File.separator + string);
            this.checkExisting(file2);
            bufferedReader = new BufferedReader(new FileReader(file2));
            this.head = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void execute() {
        this.readProperties();
        this.getProject().setNewProperty("version", this.major + "." + this.minor + "." + this.micro);
        this.getProject().setNewProperty("version.major", this.major);
        this.getProject().setNewProperty("version.minor", this.minor);
        this.getProject().setNewProperty("version.micro", this.micro);
        this.getProject().setNewProperty("version.head", this.head);
        this.getProject().setNewProperty("version.codename", this.codename);
    }

    protected void readProperties() {
        File file = new File(this.getProject().getBaseDir(), "version.properties");
        try {
            this.prop.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.major = this.prop.getProperty(MAJOR, "0");
        this.minor = this.prop.getProperty(MINOR, "0");
        this.micro = this.prop.getProperty(MICRO, "0");
        this.head = this.prop.getProperty(HEAD, "<unknown>");
        this.codename = this.prop.getProperty(CODENAME, "?");
    }

    protected void saveProperties() {
        File file = new File(this.getProject().getBaseDir(), "version.properties");
        this.prop.put(MAJOR, this.major);
        this.prop.put(MINOR, this.minor);
        this.prop.put(MICRO, this.micro);
        this.prop.put(HEAD, this.head);
        this.prop.put(CODENAME, this.codename);
        try {
            this.prop.store(new FileOutputStream(file), "JGraLab version information");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void writePomFile() {
        try {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("pom.xml"), "UTF-8"));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<project>");
            printWriter.println("\t<modelVersion>4.0.0</modelVersion>");
            printWriter.println("\t<groupId>de.uni-koblenz.ist</groupId>");
            printWriter.println("\t<artifactId>jgralab</artifactId>");
            printWriter.println("\t<version>" + this.major + "." + this.minor + "." + this.micro + "</version>");
            printWriter.println("\t<name>JGraLab</name>");
            printWriter.println("\t<description>");
            printWriter.println("\t\tA high-performance TGraph library.");
            printWriter.println("\t\tSee https://github.com/jgralab/jgralab");
            printWriter.println("\t</description>");
            printWriter.println("\t<repositories>");
            printWriter.println("\t\t<repository>");
            printWriter.println("\t\t\t<id>clojars</id>");
            printWriter.println("\t\t\t<url>http://clojars.org/repo/</url>");
            printWriter.println("\t\t</repository>");
            printWriter.println("\t</repositories>");
            printWriter.println("</project>");
            printWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }
}

