/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.AttributeImpl;
import de.uni_koblenz.jgralab.schema.impl.AttributedElementClassImpl;
import de.uni_koblenz.jgralab.schema.impl.DirectedAcyclicGraph;
import de.uni_koblenz.jgralab.schema.impl.GraphClassImpl;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.util.BitSet;
import java.util.List;
import java.util.TreeSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PSet;
import org.pcollections.PVector;

public abstract class GraphElementClassImpl<SC extends GraphElementClass<SC, IC>, IC extends GraphElement<SC, IC>>
extends AttributedElementClassImpl<SC, IC>
implements GraphElementClass<SC, IC> {
    protected final GraphClassImpl graphClass;
    protected PVector<Attribute> ownAttributes = ArrayPVector.empty();
    protected PSet<SC> allSubClasses;
    protected BitSet allSubClassesBitSet;
    protected PSet<SC> allSuperClasses;
    protected BitSet allSuperClassesBitSet;
    protected final DirectedAcyclicGraph<GraphElementClass<SC, IC>> subclassDag;
    protected final int classId;

    protected GraphElementClassImpl(String string, PackageImpl packageImpl, GraphClassImpl graphClassImpl, DirectedAcyclicGraph<SC> directedAcyclicGraph) {
        super(string, packageImpl, graphClassImpl.schema);
        this.subclassDag = directedAcyclicGraph;
        this.subclassDag.createNode(this);
        this.graphClass = graphClassImpl;
        this.classId = this.schema.getNextGraphElementClassId();
    }

    @Override
    protected Attribute createAttribute(Attribute attribute) {
        this.assertNotFinished();
        if (this.subclassContainsAttribute(attribute.getName())) {
            throw new SchemaException("Duplicate attribute '" + attribute.getName() + "' in AttributedElementClass '" + this.getQualifiedName() + "'. A derived AttributedElementClass already contains this Attribute.");
        }
        super.createAttribute(attribute);
        TreeSet<Attribute> treeSet = new TreeSet<Attribute>(this.ownAttributes);
        treeSet.add(attribute);
        this.ownAttributes = ArrayPVector.empty().plusAll(treeSet);
        return attribute;
    }

    @Override
    public GraphClass getGraphClass() {
        return this.graphClass;
    }

    protected void addSuperClass(SC SC) {
        this.assertNotFinished();
        if (SC == this) {
            return;
        }
        for (Attribute attribute : SC.getAttributeList()) {
            if (this.getAttribute(attribute.getName()) == null || this.getAttribute(attribute.getName()) == attribute) continue;
            throw new SchemaException("Cannot add " + SC.getQualifiedName() + " as superclass of " + this.getQualifiedName() + ". Cause: Attribute " + attribute.getName() + " is declared in both classes");
        }
        this.subclassDag.createEdge((GraphElementClass<SC, IC>)SC, this);
    }

    @Override
    public PSet<SC> getDirectSubClasses() {
        return this.subclassDag.getDirectSuccessors(this);
    }

    protected abstract SC getDefaultClass();

    @Override
    public PSet<SC> getDirectSuperClasses() {
        return this.subclassDag.getDirectPredecessors(this).minus(this.getDefaultClass());
    }

    @Override
    public PSet<SC> getAllSubClasses() {
        if (this.finished) {
            return this.allSubClasses;
        }
        return this.subclassDag.getAllSuccessorsInTopologicalOrder(this);
    }

    @Override
    public PSet<SC> getAllSuperClasses() {
        if (this.finished) {
            return this.allSuperClasses;
        }
        return this.subclassDag.getAllPredecessorsInTopologicalOrder(this).minus(this.getDefaultClass());
    }

    @Override
    public final boolean isSubClassOf(SC SC) {
        if (this.finished) {
            return this.allSuperClassesBitSet.get(SC.getGraphElementClassIdInSchema());
        }
        return this.getAllSuperClasses().contains(SC);
    }

    @Override
    public final boolean isSuperClassOf(SC SC) {
        if (this.finished) {
            return this.allSubClassesBitSet.get(SC.getGraphElementClassIdInSchema());
        }
        return this.getAllSubClasses().contains(SC);
    }

    private boolean subclassContainsAttribute(String string) {
        for (GraphElementClass graphElementClass : this.getAllSubClasses()) {
            if (graphElementClass.getAttribute(string) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void finish() {
        this.allSuperClasses = this.getAllSuperClasses();
        this.allSuperClassesBitSet = new BitSet();
        for (Object object : this.allSuperClasses) {
            this.allSuperClassesBitSet.set(object.getGraphElementClassIdInSchema(), true);
        }
        this.allSubClasses = this.getAllSubClasses();
        this.allSubClassesBitSet = new BitSet();
        for (Object object : this.allSubClasses) {
            this.allSubClassesBitSet.set(object.getGraphElementClassIdInSchema(), true);
        }
        TreeSet<Attribute> treeSet = new TreeSet<Attribute>(this.ownAttributes);
        for (AttributedElementClass attributedElementClass : this.subclassDag.getDirectPredecessors(this)) {
            treeSet.addAll(attributedElementClass.getAttributeList());
        }
        this.allAttributes = ArrayPVector.empty().plusAll(treeSet);
        super.finish();
    }

    @Override
    public int getAttributeCount() {
        if (this.finished) {
            return this.allAttributes.size();
        }
        int n = this.getOwnAttributeCount();
        for (AttributedElementClass attributedElementClass : this.subclassDag.getDirectPredecessors(this)) {
            n += attributedElementClass.getAttributeCount();
        }
        return n;
    }

    @Override
    public List<Attribute> getAttributeList() {
        if (this.finished) {
            return this.allAttributes;
        }
        TreeSet<Attribute> treeSet = new TreeSet<Attribute>();
        treeSet.addAll(this.ownAttributes);
        for (AttributedElementClass attributedElementClass : this.subclassDag.getDirectPredecessors(this)) {
            treeSet.addAll(attributedElementClass.getAttributeList());
        }
        return ArrayPVector.empty().plusAll(treeSet);
    }

    @Override
    public Attribute getAttribute(String string) {
        if (this.finished) {
            return super.getAttribute(string);
        }
        Attribute attribute = this.getOwnAttribute(string);
        if (attribute != null) {
            return attribute;
        }
        for (AttributedElementClass attributedElementClass : this.subclassDag.getDirectPredecessors(this)) {
            Attribute attribute2 = attributedElementClass.getAttribute(string);
            if (attribute2 == null) continue;
            return attribute2;
        }
        return null;
    }

    @Override
    public Attribute getOwnAttribute(String string) {
        for (Attribute attribute : this.ownAttributes) {
            if (!attribute.getName().equals(string)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public int getOwnAttributeCount() {
        return this.ownAttributes.size();
    }

    @Override
    public List<Attribute> getOwnAttributeList() {
        return this.ownAttributes;
    }

    @Override
    public boolean hasOwnAttributes() {
        return !this.ownAttributes.isEmpty();
    }

    public String getDescriptionString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName() + " '" + this.getQualifiedName() + "'");
        if (this.isAbstract()) {
            stringBuilder.append(" (abstract)");
        }
        stringBuilder.append(":\n");
        stringBuilder.append("Subclasses of '" + this.getQualifiedName() + "': ");
        for (GraphElementClass graphElementClass : this.getAllSubClasses()) {
            stringBuilder.append("'" + graphElementClass.getQualifiedName() + "' ");
        }
        stringBuilder.append("\nSuperclasses of '" + this.getQualifiedName() + "': ");
        for (GraphElementClass graphElementClass : this.getAllSuperClasses()) {
            stringBuilder.append("'" + graphElementClass.getQualifiedName() + "' ");
        }
        stringBuilder.append("\nDirect Superclasses of '" + this.getQualifiedName() + "': ");
        for (GraphElementClass graphElementClass : this.getDirectSuperClasses()) {
            stringBuilder.append("'" + graphElementClass.getQualifiedName() + "' ");
        }
        stringBuilder.append(this.attributesToString());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public int getGraphElementClassIdInSchema() {
        return this.classId;
    }

    @Override
    public void setQualifiedName(String string) {
        if (this.qualifiedName.equals(string)) {
            return;
        }
        if (this.schema.knows(string)) {
            throw new SchemaException(string + " is already known to the schema.");
        }
        String[] stringArray = SchemaImpl.splitQualifiedName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (!NamedElementImpl.ATTRELEM_OR_NOCOLLDOMAIN_PATTERN.matcher(string3).matches()) {
            throw new SchemaException("Invalid graph element class name '" + string3 + "'.");
        }
        this.unregister();
        this.qualifiedName = string;
        this.simpleName = string3;
        this.parentPackage = this.schema.createPackageWithParents(string2);
        this.register();
    }

    @Override
    protected void reopen() {
        this.allSuperClasses = null;
        this.allSuperClassesBitSet = null;
        this.allSubClasses = null;
        this.allSubClassesBitSet = null;
        super.reopen();
    }

    @Override
    protected void deleteAttribute(AttributeImpl attributeImpl) {
        this.allAttributes = this.allAttributes.minus(attributeImpl);
        this.ownAttributes = this.ownAttributes.minus(attributeImpl);
    }

    @Override
    public void delete() {
        for (Attribute attribute : this.ownAttributes) {
            attribute.delete();
        }
        this.ownAttributes = null;
        this.allAttributes = null;
        this.schema.namedElements.remove(this.qualifiedName);
    }
}

