/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.IncidenceDirection;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.GraphClassImpl;
import de.uni_koblenz.jgralab.schema.impl.GraphElementClassImpl;
import de.uni_koblenz.jgralab.schema.impl.IncidenceClassImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.VertexClassImpl;

public class EdgeClassImpl
extends GraphElementClassImpl<EdgeClass, Edge>
implements EdgeClass {
    private final IncidenceClass from;
    private final IncidenceClass to;

    protected EdgeClassImpl(String string, PackageImpl packageImpl, GraphClassImpl graphClassImpl, VertexClass vertexClass, int n, int n2, String string2, AggregationKind aggregationKind, VertexClass vertexClass2, int n3, int n4, String string3, AggregationKind aggregationKind2) {
        super(string, packageImpl, graphClassImpl, graphClassImpl.edgeClassDag);
        if (!(packageImpl.isDefaultPackage() && string.equals("Edge") || packageImpl.isDefaultPackage() && string.equals("TemporaryEdgeClass") || vertexClass != this.graphClass.getDefaultVertexClass() && vertexClass2 != this.graphClass.getDefaultVertexClass())) {
            throw new SchemaException("EdgeClasses from/to the default vertex class are forbidden!\n Tried to create edge class " + string + ": " + vertexClass2.getQualifiedName() + " -> " + vertexClass2.getQualifiedName());
        }
        IncidenceClassImpl incidenceClassImpl = new IncidenceClassImpl(this, vertexClass, string2, n, n2, IncidenceDirection.OUT, aggregationKind);
        IncidenceClassImpl incidenceClassImpl2 = new IncidenceClassImpl(this, vertexClass2, string3, n3, n4, IncidenceDirection.IN, aggregationKind2);
        this.from = incidenceClassImpl;
        this.to = incidenceClassImpl2;
        ((VertexClassImpl)vertexClass).addOutIncidenceClass(incidenceClassImpl);
        ((VertexClassImpl)vertexClass2).addInIncidenceClass(incidenceClassImpl2);
        this.parentPackage.addEdgeClass(this);
        this.graphClass.addEdgeClass(this);
    }

    @Override
    public void addSuperClass(EdgeClass edgeClass) {
        this.assertNotFinished();
        if (edgeClass == this) {
            return;
        }
        EdgeClassImpl.checkIncidenceClassSpecialization(this.getFrom(), edgeClass.getFrom());
        EdgeClassImpl.checkIncidenceClassSpecialization(this.getTo(), edgeClass.getTo());
        super.addSuperClass(edgeClass);
        ((IncidenceClassImpl)this.getFrom()).addSubsettedIncidenceClass(edgeClass.getFrom());
        ((IncidenceClassImpl)this.getTo()).addSubsettedIncidenceClass(edgeClass.getTo());
    }

    @Override
    public final IncidenceClass getFrom() {
        return this.from;
    }

    @Override
    public final IncidenceClass getTo() {
        return this.to;
    }

    static void checkIncidenceClassSpecialization(IncidenceClass incidenceClass, IncidenceClass incidenceClass2) {
        if (!incidenceClass2.getVertexClass().equals(incidenceClass.getVertexClass()) && !incidenceClass2.getVertexClass().isSuperClassOf(incidenceClass.getVertexClass())) {
            String string = incidenceClass.getDirection() == IncidenceDirection.OUT ? "Alpha" : "Omega";
            throw new SchemaException("An IncidenceClass may specialize only IncidenceClasses whose connected vertex class is identical or a superclass of the own one. Offending EdgeClasses are " + incidenceClass.getEdgeClass().getQualifiedName() + " which wants to specialize " + incidenceClass2.getEdgeClass().getQualifiedName() + " at end " + string + ". Connected VertexClass of special IncidenceClass ist " + incidenceClass.getVertexClass().getQualifiedName() + " and of general VertexClass is " + incidenceClass2.getVertexClass().getQualifiedName() + ".");
        }
        if (incidenceClass.getMax() > incidenceClass2.getMax()) {
            String string = incidenceClass.getDirection() == IncidenceDirection.OUT ? "Alpha" : "Omega";
            throw new SchemaException("The multiplicity of an edge class may not be larger than the multiplicities of its superclass. Offending EdgeClasses are " + incidenceClass.getEdgeClass().getQualifiedName() + " and " + incidenceClass2.getEdgeClass().getQualifiedName() + " at end " + string);
        }
        if (incidenceClass2.getRolename().equals(incidenceClass.getRolename()) && !incidenceClass2.getRolename().isEmpty() && !incidenceClass.getRolename().isEmpty()) {
            String string = incidenceClass.getDirection() == IncidenceDirection.OUT ? "Alpha" : "Omega";
            throw new SchemaException("An IncidenceClass may only subset an IncidenceClass with a different name. OffendingEdgeClasses are " + incidenceClass.getEdgeClass().getQualifiedName() + " and " + incidenceClass2.getEdgeClass().getQualifiedName() + " at end " + string);
        }
        for (IncidenceClass incidenceClass3 : incidenceClass2.getSubsettedIncidenceClasses()) {
            if (!incidenceClass3.getRolename().equals(incidenceClass.getRolename()) || incidenceClass2.getRolename().isEmpty() || incidenceClass3.getRolename().isEmpty()) continue;
            String string = incidenceClass3.getDirection() == IncidenceDirection.OUT ? "Alpha" : "Omega";
            throw new SchemaException("An IncidenceClass may only subset an IncidenceClass with a different name. OffendingEdgeClasses are " + incidenceClass.getEdgeClass().getQualifiedName() + " and " + incidenceClass3.getEdgeClass().getQualifiedName() + " at end " + string);
        }
    }

    @Override
    protected void register() {
        super.register();
        this.graphClass.edgeClasses.put(this.qualifiedName, this);
        this.parentPackage.edgeClasses.put(this.simpleName, this);
    }

    @Override
    protected void unregister() {
        super.unregister();
        this.graphClass.edgeClasses.remove(this.qualifiedName);
        this.parentPackage.edgeClasses.remove(this.simpleName);
    }

    @Override
    public void delete() {
        if (this == this.graphClass.getDefaultEdgeClass()) {
            throw new SchemaException("The default edge class cannot be deleted.");
        }
        VertexClassImpl vertexClassImpl = (VertexClassImpl)this.from.getVertexClass();
        VertexClassImpl vertexClassImpl2 = (VertexClassImpl)this.to.getVertexClass();
        vertexClassImpl.unlink(this.from);
        vertexClassImpl2.unlink(this.to);
        super.delete();
        this.graphClass.edgeClasses.remove(this.qualifiedName);
        this.graphClass.edgeClassDag.delete(this);
        this.parentPackage.edgeClasses.remove(this.simpleName);
    }

    @Override
    protected EdgeClass getDefaultClass() {
        return this.graphClass.getDefaultEdgeClass();
    }

    @Override
    public boolean isDefaultGraphElementClass() {
        return this == this.graphClass.getDefaultEdgeClass();
    }
}

