/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.gretl.GReTLBijectionViolationException;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pcollections.Empty;
import org.pcollections.PMap;

public class Context {
    private static Logger logger = JGraLab.getLogger(Context.class);
    public static final String DEFAULT_SOURCE_GRAPH_ALIAS = "default";
    public static final String DEFAULT_TARGET_GRAPH_ALIAS = "target";
    private static final Pattern QUERY_GRAPH_ALIAS_PATTERN = Pattern.compile("\\p{Space}*(#(\\p{Alnum}+)#\\p{Space}*).*", 32);
    private final Map<String, Graph> sourceGraphs = new HashMap<String, Graph>(1);
    private GreqlQuery query = null;
    Schema targetSchema = null;
    Graph targetGraph = null;
    TransformationPhase phase = TransformationPhase.SCHEMA;
    private String targetSchemaName;
    private String targetGraphClassName;
    boolean outermost = true;
    private final Map<AttributedElementClass<?, ?>, PMap<Object, AttributedElement<?, ?>>> imgMap = new HashMap();
    private final Map<AttributedElementClass<?, ?>, PMap<AttributedElement<?, ?>, Object>> archMap = new HashMap();
    private final Map<String, Object> greqlExtraVars = new HashMap<String, Object>();
    private final Set<String> greqlImports = new HashSet<String>();
    private final Random uniqueSeed = new Random();

    public final Schema getTargetSchema() {
        return this.targetSchema;
    }

    public final TransformationPhase getPhase() {
        return this.phase;
    }

    final void setGReQLVariable(String string, Object object) {
        this.greqlExtraVars.put(string, object);
    }

    final void setGReQLVariable(String string, String string2) {
        this.greqlExtraVars.put(string, this.evaluateGReQLQuery(string2));
    }

    final void setGReQLHelper(String string, String string2) {
        if (FunLib.contains(string)) {
            FunLib.removeGreqlQueryFunction(string);
        }
        GreqlQuery greqlQuery = GreqlQuery.createQuery(string2);
        greqlQuery.setName(string);
        FunLib.registerGreqlQueryFunction(greqlQuery, true, 1L, 1L, 1.0);
    }

    final void addGReQLImport(String string) {
        this.greqlImports.add(string);
    }

    private final String getGreqlImportString(Graph graph) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.greqlImports) {
            if (string.endsWith(".*") ? graph.getSchema().getPackage(string.replace(".*", "")) == null : graph.getSchema().getAttributedElementClass(string) == null) continue;
            stringBuilder.append("import ");
            stringBuilder.append(string);
            stringBuilder.append("; ");
        }
        return stringBuilder.toString();
    }

    public Context(String string, String string2) {
        this.targetSchemaName = string;
        this.targetGraphClassName = string2;
        try {
            Class<?> clazz = SchemaClassManager.instance(string).loadClass(string);
            Method method = clazz.getMethod("instance", new Class[0]);
            this.targetSchema = (Schema)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Context(Schema schema) {
        this.targetSchema = schema;
        this.targetSchemaName = schema.getQualifiedName();
    }

    public Context(Graph graph) {
        this.setTargetGraph(graph);
        this.setSourceGraph(graph);
    }

    public final PMap<AttributedElement<?, ?>, Object> getArch(AttributedElementClass<?, ?> attributedElementClass) {
        PMap<AttributedElement<?, ?>, Object> pMap = this.archMap.get(attributedElementClass);
        if (pMap == null) {
            pMap = Empty.orderedMap();
            this.archMap.put(attributedElementClass, pMap);
        }
        return pMap;
    }

    public final PMap<Object, AttributedElement<?, ?>> getImg(AttributedElementClass<?, ?> attributedElementClass) {
        PMap<Object, AttributedElement<?, ?>> pMap = this.imgMap.get(attributedElementClass);
        if (pMap == null) {
            pMap = Empty.orderedMap();
            this.imgMap.put(attributedElementClass, pMap);
        }
        return pMap;
    }

    final void ensureMappings(AttributedElementClass<?, ?> attributedElementClass) {
        this.getImg(attributedElementClass);
        this.getArch(attributedElementClass);
    }

    public final void ensureAllMappings() {
        this.ensureMappings(this.targetSchema.getGraphClass());
        for (GraphElementClass<?, ?> graphElementClass : this.targetSchema.getGraphClass().getGraphElementClasses()) {
            this.ensureMappings(graphElementClass);
        }
    }

    public final void printImgMappings() {
        System.out.println("Image Mappings:");
        for (Map.Entry<AttributedElementClass<?, ?>, PMap<Object, AttributedElement<?, ?>>> entry : this.imgMap.entrySet()) {
            AttributedElementClass<?, ?> attributedElementClass = entry.getKey();
            PMap<Object, AttributedElement<?, ?>> pMap = entry.getValue();
            System.out.println("Mappings for: " + attributedElementClass.getQualifiedName());
            for (Map.Entry entry2 : pMap.entrySet()) {
                System.out.println("    " + entry2.getKey() + " ==> " + entry2.getValue());
            }
        }
    }

    final void addMapping(AttributedElementClass<?, ?> attributedElementClass, Object object, AttributedElement<?, ?> attributedElement) {
        this.addMappingToClass(attributedElementClass, object, attributedElement);
        if (attributedElementClass instanceof GraphElementClass) {
            this.addMappingsToSuperClasses((GraphElementClass)attributedElementClass, object, (GraphElement)attributedElement);
        }
    }

    private final void addMappingsToSuperClasses(GraphElementClass<?, ?> graphElementClass, Object object, GraphElement<?, ?> graphElement) {
        for (AttributedElementClass attributedElementClass : graphElementClass.getAllSuperClasses()) {
            this.addMappingToClass(attributedElementClass, object, graphElement);
        }
    }

    private final void addMappingToClass(AttributedElementClass<?, ?> attributedElementClass, Object object, AttributedElement<?, ?> attributedElement) {
        this.addArchMapping(attributedElementClass, attributedElement, object);
        this.addImgMapping(attributedElementClass, object, attributedElement);
    }

    private void addArchMapping(AttributedElementClass<?, ?> attributedElementClass, AttributedElement<?, ?> attributedElement, Object object) {
        PMap<AttributedElement<?, ?>, Object> pMap = this.archMap.get(attributedElementClass);
        if (pMap.containsKey(attributedElement)) {
            throw new GReTLBijectionViolationException(this, "'" + attributedElement + "' already maps to '" + pMap.get(attributedElement) + "' in " + Context.toGReTLVarNotation(attributedElementClass.getQualifiedName(), GReTLVariableType.ARCH) + "! You wanted to create an archMap mapping from '" + attributedElement + "' to '" + object + "'.");
        }
        this.archMap.remove(pMap);
        pMap = pMap.plus(attributedElement, object);
        this.archMap.put(attributedElementClass, pMap);
    }

    private void addImgMapping(AttributedElementClass<?, ?> attributedElementClass, Object object, AttributedElement<?, ?> attributedElement) {
        PMap<Object, AttributedElement<?, ?>> pMap = this.imgMap.get(attributedElementClass);
        if (pMap.containsKey(object)) {
            throw new GReTLBijectionViolationException(this, "'" + object + "' already maps to '" + pMap.get(object) + "' in " + Context.toGReTLVarNotation(attributedElementClass.getQualifiedName(), GReTLVariableType.IMG) + "! You wanted to create an imgMap mapping from '" + object + "' to '" + attributedElement + "'.");
        }
        this.imgMap.remove(pMap);
        pMap = pMap.plus(object, attributedElement);
        this.imgMap.put(attributedElementClass, pMap);
    }

    public String getUniqueString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<--[");
        stringBuilder.append(this.uniqueSeed.nextInt());
        stringBuilder.append("]--[");
        stringBuilder.append(System.currentTimeMillis());
        stringBuilder.append("]-->");
        return stringBuilder.toString();
    }

    public final void validateMappings() {
        if (this.imgMap.size() != this.archMap.size()) {
            Map<AttributedElementClass<?, ?>, PMap<Object, Object>> map = this.imgMap;
            Map<AttributedElementClass<?, ?>, PMap<Object, Object>> map2 = this.archMap;
            if (this.archMap.size() > this.imgMap.size()) {
                map = this.archMap;
                map2 = this.imgMap;
            }
            Set<AttributedElementClass<?, ?>> set = map.keySet();
            for (AttributedElementClass<?, ?> attributedElementClass : set) {
                if (map2.containsKey(attributedElementClass)) continue;
                System.err.println(Context.toGReTLVarNotation(attributedElementClass.getQualifiedName(), map2 == this.archMap ? GReTLVariableType.ARCH : GReTLVariableType.IMG) + " is missing");
            }
            throw new GReTLBijectionViolationException(this, "The imgMap and archMap mappings aren't valid! The sizes of imgMap (" + this.imgMap.size() + ") and archMap (" + this.archMap.size() + ") don't match!");
        }
        for (AttributedElementClass<?, ?> attributedElementClass : this.archMap.keySet()) {
            if (!this.imgMap.containsKey(attributedElementClass)) {
                throw new GReTLBijectionViolationException(this, "The imgMap and archMap mappings aren't valid! imgMap contains no mappings for '" + attributedElementClass.getQualifiedName() + "'!");
            }
            Map map = this.archMap.get(attributedElementClass);
            Map map3 = this.imgMap.get(attributedElementClass);
            if (map.size() != map3.size()) {
                throw new GReTLBijectionViolationException(this, "The imgMap and archMap mappings aren't valid! The sizes of '" + Context.toGReTLVarNotation(attributedElementClass.getQualifiedName(), GReTLVariableType.IMG) + "' and '" + Context.toGReTLVarNotation(attributedElementClass.getQualifiedName(), GReTLVariableType.ARCH) + "' don't match!");
            }
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                if (!map3.containsKey(entry.getValue())) {
                    throw new GReTLBijectionViolationException(this, "The imgMap and archMap mappings aren't valid! imgMap contains no mapping for '" + entry.getValue() + "'!");
                }
                if (map3.get(entry.getValue()).equals(entry.getKey())) continue;
                throw new GReTLBijectionViolationException(this, "The imgMap and archMap mappings aren't valid! imgMap is not inverse to archMap for '" + Context.toGReTLVarNotation(attributedElementClass.getQualifiedName(), GReTLVariableType.ARCH) + "'! " + "archMap: " + entry.getKey() + " --> " + entry.getValue() + ", but imgMap: " + entry.getValue() + " --> " + map3.get(entry.getValue()));
            }
        }
    }

    public final Context swap() {
        logger.info("Swapping context...");
        logger.info("Old target schema name: " + this.targetSchema.getQualifiedName());
        this.sourceGraphs.clear();
        Graph graph = this.targetGraph;
        String string = this.targetSchema.getPackagePrefix();
        Pattern pattern = Pattern.compile(".*(_v(\\d+))$");
        Matcher matcher = pattern.matcher(string);
        int n = 1;
        if (matcher.matches()) {
            String string2 = matcher.group(2);
            n = Integer.parseInt(string2);
            string = string.substring(0, string.length() - matcher.group(1).length());
        }
        string = string + "_v" + ++n;
        this.targetSchemaName = string + "." + this.targetSchema.getName();
        logger.info("New target schema name: " + this.targetSchemaName);
        this.setSourceGraph(graph);
        return this.reset(true);
    }

    public final Context reset(boolean bl) {
        this.outermost = true;
        this.phase = TransformationPhase.SCHEMA;
        this.targetGraph = null;
        if (bl) {
            this.targetSchema = null;
        }
        this.archMap.clear();
        this.imgMap.clear();
        this.greqlExtraVars.clear();
        this.greqlImports.clear();
        return this;
    }

    public final void setSourceGraph(Graph graph) {
        this.addSourceGraph(DEFAULT_SOURCE_GRAPH_ALIAS, graph);
    }

    public final void addSourceGraph(String string, Graph graph) {
        if (this.sourceGraphs.containsKey(string)) {
            throw new GReTLException(this, "There's already a source graph with name '" + string + "'.");
        }
        if (!string.matches("\\w+")) {
            throw new GReTLException(this, "Invalid source graph name '" + string + "'. Must be only word characters.");
        }
        if (string.equals(DEFAULT_TARGET_GRAPH_ALIAS)) {
            throw new GReTLException(this, "Invalid source graph name '" + string + "'. That's the default alias for the target graph.");
        }
        if (graph.getSchema().getQualifiedName().equals(this.targetSchemaName) && this.targetSchema == null) {
            throw new SchemaException("The schema names of source and target have to be different. Currently both are named '" + this.targetSchemaName + "'.");
        }
        this.sourceGraphs.put(string, graph);
    }

    public final Map<String, Graph> getSourceGraphs() {
        return this.sourceGraphs;
    }

    public final Graph getSourceGraph() {
        return this.getSourceGraph(DEFAULT_SOURCE_GRAPH_ALIAS);
    }

    public final Graph getSourceGraph(String string) {
        return this.sourceGraphs.get(string);
    }

    public final Graph getTargetGraph() {
        return this.targetGraph;
    }

    public final void setTargetGraph(Graph graph) {
        this.targetGraph = graph;
        this.targetSchema = graph.getSchema();
    }

    final void createTargetSchema() {
        String[] stringArray = SchemaImpl.splitQualifiedName(this.targetSchemaName);
        this.targetSchema = new SchemaImpl(stringArray[1], stringArray[0]);
        GraphClass graphClass = this.targetSchema.createGraphClass(this.targetGraphClassName);
        this.ensureMappings(graphClass);
    }

    final void createTargetGraph() {
        this.targetSchema.finish();
        try {
            this.targetSchema.getGraphClass().getSchemaClass();
            logger.info("Schema '" + this.targetSchema.getQualifiedName() + "' is already compiled or in the CLASSPATH...");
            this.targetSchema.finish();
            this.targetGraph = this.targetSchema.createGraph(ImplementationType.STANDARD);
        }
        catch (Exception exception) {
            logger.info("Schema '" + this.targetSchema.getQualifiedName() + "' is new, so instantiating a generic target graph...");
            this.targetGraph = this.targetSchema.createGraph(ImplementationType.GENERIC);
        }
        for (Map.Entry<String, Graph> entry : this.sourceGraphs.entrySet()) {
            String string = entry.getKey();
            Graph graph = entry.getValue();
            if (!string.equals(DEFAULT_SOURCE_GRAPH_ALIAS)) continue;
            this.addMapping(this.targetGraph.getGraphClass(), graph, this.targetGraph);
        }
    }

    public static String toGReTLVarNotation(String string, GReTLVariableType gReTLVariableType) {
        String string2 = NamedElementImpl.toUniqueNameNotation(string);
        return gReTLVariableType.toString().toLowerCase() + "_" + string2;
    }

    public final <T> T evaluateGReQLQuery(String string) {
        if (this.phase == TransformationPhase.SCHEMA) {
            return null;
        }
        String string2 = DEFAULT_SOURCE_GRAPH_ALIAS;
        Matcher matcher = QUERY_GRAPH_ALIAS_PATTERN.matcher(string);
        if (matcher.matches()) {
            string = string.replace(matcher.group(1), "");
            string2 = matcher.group(2);
            if (string2.equals(DEFAULT_TARGET_GRAPH_ALIAS)) {
                return this.evalGReQLQuery(string, this.targetGraph);
            }
            if (!this.sourceGraphs.containsKey(string2)) {
                throw new GReTLException(this, "No source graph with name '" + string2 + "'.");
            }
        }
        return this.evalGReQLQuery(string, this.sourceGraphs.get(string2));
    }

    private final <T> T evalGReQLQuery(String string, Graph graph) {
        if (this.phase == TransformationPhase.SCHEMA) {
            return null;
        }
        if (string.isEmpty()) {
            logger.severe("The given semantic expression is empty!  Fix that!");
            return null;
        }
        PMap<String, Object> pMap = this.getGreqlVariablesNeededByQuery(string);
        StringBuilder stringBuilder = new StringBuilder();
        if (this.sourceGraphs.values().contains(graph)) {
            stringBuilder.append(this.getGreqlImportString(graph));
        }
        stringBuilder.append(this.getGreqlUsingString(pMap));
        stringBuilder.append(string);
        String string2 = stringBuilder.toString();
        logger.finest("GReQL: " + string);
        this.query = GreqlQuery.createQuery(string2);
        GreqlEnvironmentAdapter greqlEnvironmentAdapter = new GreqlEnvironmentAdapter(pMap);
        Object object = this.query.evaluate(graph, greqlEnvironmentAdapter);
        return (T)object;
    }

    private final PMap<String, Object> getGreqlVariablesNeededByQuery(String string) {
        String string2;
        PMap<Object, Object> pMap = Empty.orderedMap();
        for (String object : this.greqlExtraVars.keySet()) {
            if (!string.contains(object)) continue;
            pMap = pMap.plus(object, this.greqlExtraVars.get(object));
        }
        for (Map.Entry entry : this.archMap.entrySet()) {
            string2 = Context.toGReTLVarNotation(((AttributedElementClass)entry.getKey()).getQualifiedName(), GReTLVariableType.ARCH);
            if (!string.contains(string2)) continue;
            pMap = pMap.plus(string2, entry.getValue());
        }
        for (Map.Entry entry : this.imgMap.entrySet()) {
            string2 = Context.toGReTLVarNotation(((AttributedElementClass)entry.getKey()).getQualifiedName(), GReTLVariableType.IMG);
            if (!string.contains(string2)) continue;
            pMap = pMap.plus(string2, entry.getValue());
        }
        return pMap;
    }

    private final String getGreqlUsingString(Map<String, Object> map) {
        if (map.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("using ");
        boolean bl = true;
        for (String string : new TreeSet<String>(map.keySet())) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(": ");
        return stringBuilder.toString();
    }

    public final void storeTrace(String string) {
    }

    public final void restoreTrace(String string) {
    }

    public static enum GReTLVariableType {
        ARCH,
        IMG;

    }

    public static enum TransformationPhase {
        SCHEMA,
        GRAPH;

    }
}

