/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.serialising;

import de.uni_koblenz.ist.utilities.xml.XmlProcessor;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.exception.SerialisingException;
import de.uni_koblenz.jgralab.greql.serialising.XMLConstants;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import de.uni_koblenz.jgralab.impl.RecordImpl;
import de.uni_koblenz.jgralab.schema.Schema;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import org.pcollections.PCollection;
import org.pcollections.PMap;
import org.pcollections.PVector;

public class XMLLoader
extends XmlProcessor
implements XMLConstants {
    private Graph defaultGraph;
    private PathSystem pathSystem;
    private Path path;
    private Map<String, Graph> id2GraphMap = null;
    private Map<String, Schema> schemaName2Schema = null;
    private final Stack<Object> stack = new Stack();

    public XMLLoader(Graph ... graphArray) {
        this.id2GraphMap = new HashMap<String, Graph>(graphArray.length);
        for (Graph graph : graphArray) {
            this.id2GraphMap.put(graph.getId(), graph);
        }
        this.schemaName2Schema = new HashMap<String, Schema>(graphArray.length);
        for (Graph graph : graphArray) {
            Schema schema = graph.getSchema();
            this.schemaName2Schema.put(schema.getQualifiedName(), schema);
        }
    }

    public Object load(String string) throws FileNotFoundException, XMLStreamException {
        this.process(string);
        if (this.stack.size() != 1) {
            throw new SerialisingException("Something went wrong.  stack.size() = " + this.stack.size() + " != 1.  This must not happen!", (Object)null);
        }
        return this.stack.firstElement();
    }

    @Override
    protected void endDocument() throws XMLStreamException {
    }

    @Override
    protected void endElement(String string, StringBuilder stringBuilder) throws XMLStreamException {
        if (string.equals("object")) {
            return;
        }
        Object object = this.stack.pop();
        if (this.stack.isEmpty()) {
            this.stack.push(object);
            return;
        }
        Object object2 = this.stack.peek();
        if (object2 instanceof PMap) {
            MapEntry mapEntry = (MapEntry)object;
            PMap pMap = (PMap)object2;
            object2 = pMap.plus(mapEntry.key, mapEntry.value);
        } else {
            if (object2 instanceof MapEntry) {
                MapEntry mapEntry = (MapEntry)object2;
                if (mapEntry.key == null) {
                    mapEntry.key = object;
                } else if (mapEntry.value == null) {
                    mapEntry.value = object;
                }
                return;
            }
            if (object2 instanceof RecordComponent) {
                RecordComponent recordComponent = (RecordComponent)object2;
                recordComponent.value = object;
                return;
            }
            if (object2 instanceof PCollection) {
                if (object2 instanceof RecordImpl) {
                    RecordImpl recordImpl = (RecordImpl)object2;
                    RecordComponent recordComponent = (RecordComponent)object;
                    object2 = recordImpl.plus(recordComponent.componentName, recordComponent.value);
                } else if (object2 instanceof Table) {
                    Table table = (Table)object2;
                    if (table.getTitles().isEmpty()) {
                        PVector pVector = (PVector)object;
                        object2 = table.withTitles(pVector);
                    } else {
                        PVector pVector = (PVector)object;
                        object2 = table.plusAll((Collection)pVector);
                    }
                } else {
                    PCollection pCollection = (PCollection)object2;
                    object2 = pCollection.plus(object);
                }
                this.stack.pop();
                this.stack.push(object2);
            } else if (object2 == Path.class) {
                assert (object instanceof List);
                if (this.path == null) {
                    List list = (List)object;
                    this.path = Path.start((Vertex)list.get(0));
                } else {
                    List list = (List)object;
                    for (Edge edge : list) {
                        this.path = this.path.append(edge);
                    }
                    this.stack.pop();
                    this.stack.push(this.path);
                    this.path = null;
                }
            } else if (object2 instanceof PathSystem) {
                PathSystemNodeEntry pathSystemNodeEntry = (PathSystemNodeEntry)object;
                PathSystem.PathSystemNode pathSystemNode = this.pathSystem.setRootVertex(pathSystemNodeEntry.currentVertex, pathSystemNodeEntry.state, pathSystemNodeEntry.isLeaf);
                for (PathSystem.PathSystemNode pathSystemNode2 : pathSystemNodeEntry.children) {
                    this.pathSystem.addEdge(pathSystemNode2, pathSystemNode, pathSystemNode2.edge2parent);
                }
                this.pathSystem.finish();
                this.pathSystem = null;
            } else if (object2 instanceof PathSystemNodeEntry) {
                PathSystemNodeEntry pathSystemNodeEntry = (PathSystemNodeEntry)object2;
                if (object instanceof PathSystemNodeEntry) {
                    PathSystemNodeEntry pathSystemNodeEntry2 = (PathSystemNodeEntry)object;
                    PathSystem.PathSystemNode pathSystemNode = this.pathSystem.addVertex(pathSystemNodeEntry2.currentVertex, pathSystemNodeEntry2.state, pathSystemNodeEntry2.isLeaf);
                    pathSystemNode.edge2parent = pathSystemNodeEntry2.edge2Parent;
                    for (PathSystem.PathSystemNode pathSystemNode3 : pathSystemNodeEntry2.children) {
                        this.pathSystem.addEdge(pathSystemNode3, pathSystemNode, pathSystemNode3.edge2parent);
                    }
                    pathSystemNodeEntry.children.add(pathSystemNode);
                } else if (object instanceof Vertex) {
                    pathSystemNodeEntry.currentVertex = (Vertex)object;
                } else if (object instanceof Edge) {
                    pathSystemNodeEntry.edge2Parent = (Edge)object;
                }
            } else {
                throw new SerialisingException("The element '" + object + "' couldn't be added to its parent.", (Object)null);
            }
        }
    }

    @Override
    protected void startDocument() throws XMLStreamException {
        this.stack.clear();
    }

    @Override
    protected void startElement(String string) throws XMLStreamException {
        Object object = null;
        if (string.equals("undefined")) {
            object = Undefined.UNDEFINED;
        } else {
            if (string.equals("graph") || string.equals("object")) {
                String string2 = this.getAttribute("graphId");
                if (string2 != null) {
                    this.defaultGraph = this.id2GraphMap.get(string2);
                    if (this.defaultGraph == null) {
                        throw new SerialisingException("There's no graph with id '" + string2 + "'.", (Object)null);
                    }
                }
                return;
            }
            if (string.equals("attributedElementClass")) {
                String string3 = this.getAttribute("name");
                String string4 = this.getAttribute("schema");
                Schema schema = this.schemaName2Schema.get(string4);
                if (schema == null) {
                    throw new SerialisingException("Couldn't retrieve Schema '" + string4 + "'", (Object)null);
                }
                Object t = schema.getAttributedElementClass(string3);
                if (t == null) {
                    throw new SerialisingException("Couldn't retrieve attributed element '" + string3 + "' from schema '" + string4 + "'.", (Object)null);
                }
                object = t;
            } else if (string.equals("boolean")) {
                object = Boolean.valueOf(this.getAttribute("value"));
            } else if (string.equals("double")) {
                object = Double.valueOf(this.getAttribute("value"));
            } else if (string.equals("edge")) {
                int n = Integer.valueOf(this.getAttribute("id"));
                Graph graph = this.defaultGraph;
                String string5 = this.getAttribute("graphId");
                if (string5 != null && (graph = this.id2GraphMap.get(string5)) == null) {
                    throw new SerialisingException("There's no graph with id '" + string5 + "'.", (Object)null);
                }
                Edge edge = graph.getEdge(n);
                if (edge == null) {
                    throw new SerialisingException("There's no edge with id '" + n + "' in graph '" + graph.getId() + "'.", (Object)null);
                }
                object = edge;
            } else if (string.equals("enum")) {
                String string6 = this.getAttribute("value");
                String string7 = this.getAttribute("type");
                object = this.createEnum(string6, string7);
            } else if (string.equals("graph")) {
                String string8 = this.getAttribute("graphId");
                Graph graph = this.id2GraphMap.get(string8);
                if (graph == null) {
                    throw new SerialisingException("There's no graph with id '" + string8 + "'.", (Object)null);
                }
                object = graph;
            } else if (string.equals("integer")) {
                object = Integer.valueOf(this.getAttribute("value"));
            } else if (string.equals("list")) {
                object = JGraLab.vector();
            } else if (string.equals("long")) {
                object = Long.valueOf(this.getAttribute("value"));
            } else if (string.equals("map")) {
                object = JGraLab.map();
            } else if (string.equals("entry")) {
                object = new MapEntry();
            } else if (string.equals("record")) {
                object = RecordImpl.empty();
            } else if (string.equals("comp")) {
                object = new RecordComponent(this.getAttribute("name"));
            } else if (string.equals("set")) {
                object = JGraLab.set();
            } else if (string.equals("string")) {
                object = this.getAttribute("value");
            } else if (string.equals("table")) {
                Table table = Table.empty();
                table = table.withTitles(null);
                object = table;
            } else if (string.equals("tup")) {
                object = Tuple.empty();
            } else if (string.equals("vertex")) {
                int n = Integer.valueOf(this.getAttribute("id"));
                Graph graph = this.defaultGraph;
                String string9 = this.getAttribute("graphId");
                if (string9 != null && (graph = this.id2GraphMap.get(string9)) == null) {
                    throw new SerialisingException("There's no graph with id '" + string9 + "'.", (Object)null);
                }
                Vertex vertex = graph.getVertex(n);
                if (vertex == null) {
                    throw new SerialisingException("There's no vertex with id '" + n + "' in graph '" + graph.getId() + "'.", (Object)null);
                }
                object = vertex;
            } else if (string.equals("path")) {
                object = Path.class;
            } else if (string.equals("pathSystem")) {
                this.pathSystem = new PathSystem();
                object = this.pathSystem;
            } else if (string.equals("node")) {
                PathSystemNodeEntry pathSystemNodeEntry = new PathSystemNodeEntry();
                pathSystemNodeEntry.state = Integer.parseInt(this.getAttribute("state"));
                pathSystemNodeEntry.isLeaf = this.getAttribute("isLeaf").equals("true");
                object = pathSystemNodeEntry;
            } else {
                throw new SerialisingException("Unrecognized XML element '" + string + "'.", (Object)null);
            }
        }
        if (object == null) {
            throw new SerialisingException("Couldn't read the value of element '" + string + "'.", (Object)null);
        }
        this.stack.push(object);
    }

    private Object createEnum(String string, String string2) {
        Object var3_3 = null;
        try {
            Class<?> clazz = Class.forName(string2);
            var3_3 = Enum.valueOf(clazz, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new SerialisingException("The Enum class '" + string2 + "' could not be loaded.", (Object)classNotFoundException);
        }
        return var3_3;
    }

    private static class PathSystemNodeEntry {
        Vertex currentVertex;
        int state;
        Edge edge2Parent;
        boolean isLeaf = true;
        List<PathSystem.PathSystemNode> children = new ArrayList<PathSystem.PathSystemNode>();

        private PathSystemNodeEntry() {
        }

        public String toString() {
            return "(currentVertex: " + this.currentVertex + " state: " + this.state + " edge2Parent: " + this.edge2Parent + " isLeaf: " + this.isLeaf + ")" + " children: " + this.children;
        }
    }

    private static class MapEntry {
        Object key = null;
        Object value = null;

        private MapEntry() {
        }
    }

    private static class RecordComponent {
        String componentName;
        Object value;

        RecordComponent(String string) {
            this.componentName = string;
        }
    }
}

