/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.IntLiteralEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.schema.ExponentiatedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IntLiteral;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;

public class ExponentiatedPathDescriptionEvaluator
extends PathDescriptionEvaluator<ExponentiatedPathDescription> {
    protected static final int defaultExponent = 3;

    public ExponentiatedPathDescriptionEvaluator(ExponentiatedPathDescription exponentiatedPathDescription, GreqlQueryImpl greqlQueryImpl) {
        super(exponentiatedPathDescription, greqlQueryImpl);
    }

    @Override
    public NFA evaluate(InternalGreqlEvaluator internalGreqlEvaluator) {
        internalGreqlEvaluator.progress(this.getOwnEvaluationCosts());
        PathDescription pathDescription = ((ExponentiatedPathDescription)this.vertex).getFirstIsExponentiatedPathOfIncidence().getAlpha();
        PathDescriptionEvaluator pathDescriptionEvaluator = (PathDescriptionEvaluator)this.query.getVertexEvaluator(pathDescription);
        VertexEvaluator<IntLiteral> vertexEvaluator = this.query.getVertexEvaluator(((ExponentiatedPathDescription)this.vertex).getFirstIsExponentOfIncidence(EdgeDirection.IN).getAlpha());
        Object object = vertexEvaluator.getResult(internalGreqlEvaluator);
        int n = 0;
        if (!(object instanceof Integer)) {
            throw new GreqlException("Exponent of ExponentiatedPathDescription is not convertable to integer value");
        }
        n = (Integer)object;
        if (n <= 0) {
            throw new GreqlException("Exponent of ExponentiatedPathDescription is " + n + " but must be >=1.");
        }
        return NFA.createExponentiatedPathDescriptionNFA(pathDescriptionEvaluator.getNFA(internalGreqlEvaluator), n);
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        ExponentiatedPathDescription exponentiatedPathDescription = (ExponentiatedPathDescription)this.getVertex();
        long l = 3L;
        VertexEvaluator<IntLiteral> vertexEvaluator = this.query.getVertexEvaluator(exponentiatedPathDescription.getFirstIsExponentOfIncidence(EdgeDirection.IN).getAlpha());
        if (vertexEvaluator instanceof IntLiteralEvaluator) {
            try {
                l = ((Number)vertexEvaluator.getResult(null)).longValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long l2 = vertexEvaluator.getCurrentSubtreeEvaluationCosts();
        VertexEvaluator<PathDescription> vertexEvaluator2 = this.query.getVertexEvaluator(exponentiatedPathDescription.getFirstIsExponentiatedPathOfIncidence(EdgeDirection.IN).getAlpha());
        long l3 = vertexEvaluator2.getCurrentSubtreeEvaluationCosts();
        long l4 = l3 * l * 1L / 3L;
        long l5 = l3 + l4 + l2;
        return new VertexCosts(l4, l4, l5);
    }
}

