/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.weak_components;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmStates;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.BreadthFirstSearch;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitor;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.SearchVisitorAdapter;
import de.uni_koblenz.jgralab.algolib.algorithms.weak_components.visitors.VertexPartitionVisitor;
import de.uni_koblenz.jgralab.algolib.algorithms.weak_components.visitors.VertexPartitionVisitorList;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.problems.WeakComponentsSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import de.uni_koblenz.jgralab.graphmarker.ArrayVertexMarker;
import java.util.HashSet;
import java.util.Set;

public class WeakComponentsWithBFS
extends StructureOrientedAlgorithm
implements WeakComponentsSolver {
    private BreadthFirstSearch bfs;
    private SearchVisitor weakComponentsVisitor;
    private VertexPartitionVisitorList visitors;
    private Function<Vertex, Vertex> weakComponents;
    private Function<Vertex, Set<Vertex>> inverseResult;
    private int kappa;

    public WeakComponentsWithBFS(Graph graph, BreadthFirstSearch breadthFirstSearch) {
        this(graph, breadthFirstSearch, null);
    }

    public WeakComponentsWithBFS(Graph graph, BreadthFirstSearch breadthFirstSearch, BooleanFunction<Edge> booleanFunction) {
        super(graph, booleanFunction);
        this.bfs = breadthFirstSearch;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        if (visitor instanceof VertexPartitionVisitor) {
            visitor.setAlgorithm(this);
            this.visitors.addVisitor(visitor);
        } else {
            this.bfs.addVisitor(visitor);
        }
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        if (visitor instanceof VertexPartitionVisitor) {
            this.visitors.removeVisitor(visitor);
        } else {
            this.bfs.removeVisitor(visitor);
        }
    }

    @Override
    public WeakComponentsWithBFS normal() {
        throw new UnsupportedOperationException("This algorithm is only defined for undirected graphs.");
    }

    @Override
    public WeakComponentsWithBFS reversed() {
        throw new UnsupportedOperationException("This algorithm is only defined for undirected graphs.");
    }

    @Override
    public WeakComponentsWithBFS undirected() {
        super.undirected();
        return this;
    }

    @Override
    public boolean isHybrid() {
        return false;
    }

    public WeakComponentsWithBFS withInverseResult() {
        this.checkStateForSettingParameters();
        this.inverseResult = new ArrayVertexMarker<Set<Vertex>>(this.graph);
        return this;
    }

    public WeakComponentsWithBFS withoutInverseResult() {
        this.checkStateForSettingParameters();
        this.inverseResult = null;
        return this;
    }

    @Override
    public void reset() {
        super.reset();
        this.weakComponents = new ArrayVertexMarker<Vertex>(this.graph);
        this.inverseResult = this.inverseResult == null ? null : new ArrayVertexMarker(this.graph);
        this.kappa = 0;
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.visitors = new VertexPartitionVisitorList();
        this.traversalDirection = EdgeDirection.INOUT;
        this.weakComponentsVisitor = new SearchVisitorAdapter(){
            private Vertex currentRepresentativeVertex;

            @Override
            public void visitRoot(Vertex vertex) throws AlgorithmTerminatedException {
                WeakComponentsWithBFS.this.kappa++;
                this.currentRepresentativeVertex = vertex;
                if (WeakComponentsWithBFS.this.inverseResult != null) {
                    assert (WeakComponentsWithBFS.this.inverseResult.get(vertex) == null);
                    WeakComponentsWithBFS.this.inverseResult.set(vertex, new HashSet());
                }
                WeakComponentsWithBFS.this.visitors.visitRepresentativeVertex(vertex);
            }

            @Override
            public void visitVertex(Vertex vertex) throws AlgorithmTerminatedException {
                WeakComponentsWithBFS.this.weakComponents.set(vertex, this.currentRepresentativeVertex);
                if (WeakComponentsWithBFS.this.inverseResult != null) {
                    Set set = (Set)WeakComponentsWithBFS.this.inverseResult.get(this.currentRepresentativeVertex);
                    assert (set != null);
                    set.add(vertex);
                }
            }
        };
    }

    @Override
    public void disableOptionalResults() {
        this.checkStateForSettingParameters();
        this.inverseResult = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WeakComponentsWithBFS execute() throws AlgorithmTerminatedException {
        this.bfs.reset();
        this.bfs.setGraph(this.graph);
        this.bfs.setNavigable(this.navigable);
        this.bfs.undirected();
        this.bfs.addVisitor(this.weakComponentsVisitor);
        this.startRunning();
        try {
            this.bfs.execute();
        }
        catch (AlgorithmTerminatedException algorithmTerminatedException) {
            this.bfs.terminate();
        }
        finally {
            this.bfs.removeVisitor(this.weakComponentsVisitor);
            this.done();
        }
        return this;
    }

    @Override
    protected void done() {
        this.state = AlgorithmStates.FINISHED;
    }

    @Override
    public Function<Vertex, Vertex> getWeakComponents() {
        this.checkStateForResult();
        return this.weakComponents;
    }

    public Function<Vertex, Set<Vertex>> getInverseResult() {
        this.checkStateForResult();
        return this.inverseResult;
    }

    @Override
    public int getKappa() {
        this.checkStateForResult();
        return this.kappa;
    }

    public Function<Vertex, Vertex> getInternalWeakComponents() {
        return this.weakComponents;
    }

    public Function<Vertex, Set<Vertex>> getInternalInverseResult() {
        return this.inverseResult;
    }

    public int getInternalKappa() {
        return this.kappa;
    }
}

