/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.option_handler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class OptionHandler {
    private List<Option> optionList;
    private List<OptionGroup> optionGroupList;
    private Options options = new Options();
    private Set<Option> requiredOptions;
    private Set<OptionGroup> requiredOptionGroups;
    private String usageString;
    private String toolString;
    private String versionString;
    private HelpFormatter helpFormatter;
    private int argumentCount;
    private String argumentName;
    private boolean optionalArgument;
    private ParserType parserType;

    public OptionHandler(String string, String string2) {
        this.optionList = new ArrayList<Option>();
        this.optionGroupList = new ArrayList<OptionGroup>();
        this.requiredOptions = new HashSet<Option>();
        this.requiredOptionGroups = new HashSet<OptionGroup>();
        this.helpFormatter = new HelpFormatter();
        this.parserType = ParserType.GNU;
        this.toolString = string;
        this.versionString = string2;
        Option option = new Option("h", "help", false, "(optional): print this help message.");
        option.setRequired(false);
        this.addOption(option);
        Option option2 = new Option("v", "version", false, "(optional): print version information");
        option2.setRequired(false);
        this.addOption(option2);
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.setRequired(false);
        optionGroup.addOption(option);
        optionGroup.addOption(option2);
        this.options.addOptionGroup(optionGroup);
        this.argumentCount = 0;
        this.argumentName = "parameter";
        this.optionalArgument = false;
    }

    public void addOption(Option option) {
        if (option.isRequired()) {
            this.requiredOptions.add(option);
            option.setRequired(false);
        }
        this.optionList.add(option);
        this.options.addOption(option);
    }

    public void addOptionGroup(OptionGroup optionGroup) {
        if (optionGroup.isRequired()) {
            this.requiredOptionGroups.add(optionGroup);
            optionGroup.setRequired(false);
        }
        this.optionGroupList.add(optionGroup);
        this.options.addOptionGroup(optionGroup);
    }

    public Options getOptions() {
        return this.options;
    }

    public void printVersionAndExit(int n) {
        System.out.println(this.versionString);
        System.exit(n);
    }

    public void printHelpAndExit(int n) {
        this.helpFormatter.printHelp(this.getUsageString(), this.options);
        System.exit(n);
    }

    private String getUsageString() {
        if (this.usageString == null) {
            StringBuilder stringBuilder = new StringBuilder(this.toolString);
            for (Option option : this.optionList) {
                stringBuilder.append(" ");
                if (this.isOptionRequired(option)) {
                    this.appendOption(stringBuilder, option);
                    continue;
                }
                stringBuilder.append("[");
                this.appendOption(stringBuilder, option);
                stringBuilder.append("]");
            }
            this.appendAdditionalArguments(stringBuilder);
            this.usageString = stringBuilder.toString();
        }
        return this.usageString;
    }

    private void appendAdditionalArguments(StringBuilder stringBuilder) {
        if (this.argumentCount != 0) {
            stringBuilder.append(" (");
            if (this.optionalArgument) {
                stringBuilder.append("[");
            }
            if (this.argumentCount == -2) {
                this.appendArgument(stringBuilder);
                stringBuilder.append(" ");
                stringBuilder.append("{");
                this.appendArgument(stringBuilder);
                stringBuilder.append("}");
            } else {
                for (int i = 0; i < this.argumentCount; ++i) {
                    this.appendArgument(stringBuilder);
                }
            }
            if (this.optionalArgument) {
                stringBuilder.append("]");
            }
            stringBuilder.append(")");
        }
    }

    private void appendArgument(StringBuilder stringBuilder) {
        stringBuilder.append("<");
        stringBuilder.append(this.argumentName);
        stringBuilder.append(">");
    }

    public boolean isOptionRequired(Option option) {
        return this.requiredOptions.contains(option);
    }

    public boolean containsAllRequiredOptions(CommandLine commandLine) {
        Option option;
        boolean bl = true;
        Option[] optionArray = commandLine.getOptions();
        HashSet<Option> hashSet = new HashSet<Option>();
        for (Option option2 : optionArray) {
            hashSet.add(option2);
        }
        Iterator<Option> iterator = this.optionList.iterator();
        while (iterator.hasNext() && (!this.isOptionRequired(option = (Option)iterator.next()) || (bl &= hashSet.contains(option)))) {
        }
        return bl && !this.requiredOptionGroups.isEmpty() ? bl && this.containsAllRequiredOptionGroups(optionArray) : bl;
    }

    private boolean containsAllRequiredOptionGroups(Option[] optionArray) {
        boolean bl = true;
        for (OptionGroup optionGroup : this.requiredOptionGroups) {
            boolean bl2 = false;
            for (Option option : optionArray) {
                if (bl2 |= optionGroup.getOptions().contains(option)) break;
            }
            if (bl &= bl2) continue;
            break;
        }
        return bl;
    }

    private void appendOption(StringBuilder stringBuilder, Option option) {
        stringBuilder.append("-");
        stringBuilder.append(option.getOpt());
        int n = option.getArgs();
        stringBuilder.append(" ");
        if (option.hasOptionalArg()) {
            stringBuilder.append("[");
        }
        if (n == -2) {
            this.appendArgName(stringBuilder, option);
            stringBuilder.append("{");
            stringBuilder.append(option.getValueSeparator());
            this.appendArgName(stringBuilder, option);
            stringBuilder.append("}");
        }
        if (n >= 1) {
            this.appendArgName(stringBuilder, option);
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(option.getValueSeparator());
                this.appendArgName(stringBuilder, option);
            }
        }
        if (option.hasOptionalArg()) {
            stringBuilder.append("]");
        }
    }

    private void appendArgName(StringBuilder stringBuilder, Option option) {
        stringBuilder.append("<").append(option.getArgName()).append(">");
    }

    public CommandLine parse(String[] stringArray) {
        try {
            CommandLineParser commandLineParser = this.getParser();
            CommandLine commandLine = commandLineParser.parse(this.getOptions(), stringArray);
            if (commandLine.hasOption("h")) {
                this.printHelpAndExit(0);
            } else if (commandLine.hasOption("v")) {
                this.printVersionAndExit(0);
            } else if (!this.containsAllRequiredOptions(commandLine)) {
                System.err.println("Required options are missing.");
                this.printHelpAndExit(1);
            }
            return commandLine;
        }
        catch (ParseException parseException) {
            System.err.println(OptionHandler.parseErrorMessage(parseException.getMessage()));
            this.printHelpAndExit(1);
            return null;
        }
    }

    private static String parseErrorMessage(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = string.indexOf(91);
        if (n2 == -1) {
            return string;
        }
        stringBuilder.append(string.substring(n, n2));
        stringBuilder.append("\n\t");
        n = n2 + 1;
        while ((n2 = string.indexOf(44, n)) != -1) {
            stringBuilder.append(string.substring(n, n2 + 1).trim());
            stringBuilder.append("\n\t");
            n = n2 + 1;
        }
        stringBuilder.append(string.substring(n, string.length() - 1).trim());
        return stringBuilder.toString();
    }

    public void setArgumentCount(int n) {
        this.argumentCount = n;
    }

    public void setArgumentName(String string) {
        this.argumentName = string;
    }

    public void setOptionalArgument(boolean bl) {
        this.optionalArgument = bl;
    }

    public OptionHandler withPosixParser() {
        this.parserType = ParserType.POSIX;
        return this;
    }

    public OptionHandler withBasicParser() {
        this.parserType = ParserType.BASIC;
        return this;
    }

    public OptionHandler withGnuParser() {
        this.parserType = ParserType.GNU;
        return this;
    }

    private CommandLineParser getParser() {
        switch (this.parserType) {
            case GNU: {
                return new GnuParser();
            }
            case POSIX: {
                return new PosixParser();
            }
            case BASIC: {
                return new BasicParser();
            }
        }
        return null;
    }

    public static enum ParserType {
        BASIC,
        GNU,
        POSIX;

    }
}

