/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.AbstractBooleanGraphMarker;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.DotWriter;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphType;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizLayouter;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizOutputFormat;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizProgram;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.GraphLayout;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.GraphLayoutFactory;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.Definition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.ElementDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.TypeDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.GreqlEvaluatorFacade;
import de.uni_koblenz.jgralab.utilities.tg2whatever.Tg2Whatever;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class Tg2Dot
extends Tg2Whatever {
    private boolean abbreviateEdgeAttributeNames = false;
    private boolean printIncidenceIndices = false;
    private boolean printElementSequenceIndices = false;
    private String graphLayoutFilename;
    private GraphLayout layout;
    private GreqlEvaluatorFacade evaluator;
    private DotWriter writer;
    private GraphVizLayouter graphVizLayouter;
    private GraphVizOutputFormat graphVizOutputFormat;
    private Level jGraLabLogLevel;

    public static void main(String[] stringArray) {
        Tg2Dot tg2Dot = new Tg2Dot();
        tg2Dot.getOptions(stringArray);
        System.out.print("Starting processing of graph...");
        try {
            tg2Dot.convert();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Finished Processing.");
    }

    @Override
    public void convert() throws IOException {
        if (this.graphVizOutputFormat == null) {
            super.convert();
            return;
        }
        GraphVizProgram graphVizProgram = new GraphVizProgram().layouter(this.graphVizLayouter).outputFormat(this.graphVizOutputFormat);
        this.pipeToGraphViz(graphVizProgram);
    }

    public static Tg2Dot createConverterAndSetAttributes(Graph graph, boolean bl) {
        Tg2Dot tg2Dot = new Tg2Dot();
        tg2Dot.setGraph(graph);
        tg2Dot.setReversedEdges(bl);
        tg2Dot.setPrintEdgeAttributes(true);
        return tg2Dot;
    }

    public static void convertGraph(Graph graph, String string) throws IOException {
        Tg2Dot.convertGraph(graph, string, false, GraphVizOutputFormat.XDOT);
    }

    public static void convertGraph(Graph graph, String string, boolean bl) throws IOException {
        Tg2Dot.convertGraph(graph, string, bl, GraphVizOutputFormat.XDOT);
    }

    public static void convertGraph(Graph graph, String string, GraphVizOutputFormat graphVizOutputFormat) throws IOException {
        Tg2Dot.convertGraph(graph, string, false, graphVizOutputFormat);
    }

    public static void convertGraph(Graph graph, String string, boolean bl, GraphVizOutputFormat graphVizOutputFormat) throws IOException {
        Tg2Dot tg2Dot = Tg2Dot.createConverterAndSetAttributes(graph, bl);
        tg2Dot.setOutputFile(string);
        tg2Dot.setGraphVizOutputFormat(graphVizOutputFormat);
        tg2Dot.convert();
    }

    public static void convertGraph(AbstractBooleanGraphMarker abstractBooleanGraphMarker, String string) throws IOException {
        Tg2Dot.convertGraph(abstractBooleanGraphMarker, string, false);
    }

    public static void convertGraph(AbstractBooleanGraphMarker abstractBooleanGraphMarker, String string, boolean bl) throws IOException {
        Tg2Dot.convertGraph(abstractBooleanGraphMarker, string, GraphVizOutputFormat.PDF, bl);
    }

    public static void convertGraph(AbstractBooleanGraphMarker abstractBooleanGraphMarker, String string, GraphVizOutputFormat graphVizOutputFormat, boolean bl) throws IOException {
        Tg2Dot tg2Dot = Tg2Dot.createConverterAndSetAttributes(abstractBooleanGraphMarker.getGraph(), bl);
        tg2Dot.setOutputFile(string);
        tg2Dot.setGraphMarker(abstractBooleanGraphMarker);
        tg2Dot.convert();
    }

    public void pipeToGraphViz(GraphVizProgram graphVizProgram) throws IOException {
        String string = String.format("%s%s -T%s -o%s", new Object[]{graphVizProgram.path, graphVizProgram.layouter, graphVizProgram.outputFormat, this.outputName});
        final Process process = Runtime.getRuntime().exec(string);
        new Thread(){

            @Override
            public void run() {
                PrintStream printStream = new PrintStream(process.getOutputStream());
                Tg2Dot.this.convert(printStream);
                printStream.flush();
                printStream.close();
            }
        }.start();
        try {
            int n = process.waitFor();
            if (n != 0) {
                throw new RuntimeException("GraphViz process failed! Error code = " + n);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public InputStream convertToGraphVizStream(GraphVizProgram graphVizProgram) throws IOException {
        String string = String.format("%s%s -T%s", new Object[]{graphVizProgram.path, graphVizProgram.layouter, graphVizProgram.outputFormat});
        final Process process = Runtime.getRuntime().exec(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
        new Thread(){

            @Override
            public void run() {
                PrintStream printStream = new PrintStream(process.getOutputStream());
                Tg2Dot.this.convert(printStream);
                printStream.flush();
                printStream.close();
            }
        }.start();
        return bufferedInputStream;
    }

    public ImageIcon convertToGraphVizImageIcon(GraphVizProgram graphVizProgram) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.convertToGraphVizStream(graphVizProgram));
        return new ImageIcon(ImageIO.read(bufferedInputStream));
    }

    @Override
    protected void getAdditionalOptions(CommandLine commandLine) {
        String string;
        this.initializeGraphAndSchema();
        this.graphLayoutFilename = commandLine.getOptionValue('p');
        this.printIncidenceIndices = commandLine.hasOption('i');
        this.printElementSequenceIndices = commandLine.hasOption('m');
        String string2 = commandLine.getOptionValue('l');
        if (string2 != null) {
            try {
                this.graphVizLayouter = GraphVizLayouter.valueOf(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("Unknown layouter '" + string2 + "'. Possible values are " + GraphVizLayouter.describeValues());
            }
        }
        if ((string = commandLine.getOptionValue('t')) != null) {
            try {
                this.graphVizOutputFormat = GraphVizOutputFormat.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("Unknown output format  '" + string + "'. Possible values are " + GraphVizOutputFormat.describeValues());
            }
        }
    }

    @Override
    protected void addAdditionalOptions(OptionHandler optionHandler) {
        Option option = new Option("p", "pListLayout", true, "(optional): declares a PList-layout file, which should be used to lay out the given graph.");
        option.setRequired(false);
        optionHandler.addOption(option);
        Option option2 = new Option("i", "incidenceIndices", false, "(optional): prints the incidence index to every edge.");
        option2.setRequired(false);
        optionHandler.addOption(option2);
        Option option3 = new Option("m", "elementSequenceIndices", false, "(optional): prints the element sequence index of every vertex and edge.");
        option3.setRequired(false);
        optionHandler.addOption(option3);
        Option option4 = new Option("t", "graphVizFormat", true, "(optional): determines the GraphViz output format");
        option4.setRequired(false);
        optionHandler.addOption(option4);
        Option option5 = new Option("l", "graphVizLayouter", true, "(optional): determines the GraphViz layout program (default: 'dot')");
        option5.setRequired(false);
        optionHandler.addOption(option5);
    }

    @Override
    protected void graphStart(PrintStream printStream) {
        this.jGraLabLogLevel = JGraLab.getRootLogger().getLevel();
        JGraLab.setLogLevel(Level.OFF);
        this.initializeEvaluator();
        this.initializeGraphLayout();
        this.setGlobalVariables();
        this.setCommandLineVariables();
        this.createDotWriter(printStream);
        this.startDotGraph();
    }

    private void initializeEvaluator() {
        this.evaluator = new GreqlEvaluatorFacade(this.graph);
    }

    private void initializeGraphLayout() {
        GraphLayoutFactory graphLayoutFactory = new GraphLayoutFactory(this.evaluator);
        if (this.graphLayoutFilename != null) {
            File file = new File(this.graphLayoutFilename);
            graphLayoutFactory.setPListGraphLayoutFilename(file);
        }
        this.layout = graphLayoutFactory.createGraphLayout();
    }

    private void setGlobalVariables() {
        this.evaluator.setVariablesWithGreqlValues(this.layout.getGlobalVariables());
    }

    private void setCommandLineVariables() {
        this.evaluator.setVariable("printRolenames", this.roleNames);
        this.evaluator.setVariable("printIncidenceIndices", this.printIncidenceIndices);
        this.evaluator.setVariable("printElementSequenceIndices", this.printElementSequenceIndices);
        this.evaluator.setVariable("printDomainNames", this.domainNames);
        this.evaluator.setVariable("shortenStrings", this.shortenStrings);
        this.evaluator.setVariable("abbreviateEdgeAttributeNames", this.abbreviateEdgeAttributeNames);
        this.evaluator.setVariable("printEdgeAttributes", this.edgeAttributes);
    }

    private void createDotWriter(PrintStream printStream) {
        this.writer = new DotWriter(printStream);
    }

    private void startDotGraph() {
        this.writer.startGraph(GraphType.DIRECTED, this.graph.getAttributedElementClass().getQualifiedName(), this.graph.getId() + " / " + this.graph.getGraphVersion());
    }

    @Override
    protected void printVertex(PrintStream printStream, Vertex vertex) {
        Definition definition = this.getCorrespondingDefinition(vertex);
        this.evaluator.setStaticVariablesOfGreqlEvaluator((AttributedElementClass<?, ?>)vertex.getAttributedElementClass());
        this.writeLayoutedVertex(vertex, definition);
    }

    private Definition getCorrespondingDefinition(AttributedElement<?, ?> attributedElement) {
        if (this.layout.isDefinedbyElementDefinitions(attributedElement)) {
            return this.constructSpecificElementDefinition(attributedElement);
        }
        TypeDefinition typeDefinition = this.layout.getTypeDefinition(attributedElement);
        return typeDefinition;
    }

    private Definition constructSpecificElementDefinition(AttributedElement<?, ?> attributedElement) {
        Definition definition = this.layout.getTypeDefinition(attributedElement);
        definition = definition.clone();
        for (ElementDefinition elementDefinition : this.layout.getElementDefinitions()) {
            if (!elementDefinition.hasElement(attributedElement)) continue;
            definition.overwriteAttributes(elementDefinition);
        }
        return definition;
    }

    private void writeLayoutedVertex(Vertex vertex, Definition definition) {
        this.evaluator.setVariablesOfGreqlEvaluator(vertex, this.getCurrentElementSequenceIndex());
        String string = this.getVertexName(vertex);
        Map<String, String> map = this.createEvaluatedStyleAttributeList(definition);
        if (!map.containsKey("id")) {
            map.put("id", string);
        }
        this.writer.writeNode(string, map);
    }

    private String getVertexName(Vertex vertex) {
        return "v" + vertex.getId();
    }

    private Map<String, String> createEvaluatedStyleAttributeList(Definition definition) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : definition.getAttributeNames()) {
            String string2 = definition.getAttributeValue(string);
            Object object = this.evaluator.evaluate(string2);
            hashMap.put(string, object.toString());
        }
        return hashMap;
    }

    @Override
    protected void printEdge(PrintStream printStream, Edge edge) {
        Definition definition = this.getCorrespondingDefinition(edge);
        this.evaluator.setStaticVariablesOfGreqlEvaluator((AttributedElementClass<?, ?>)edge.getAttributedElementClass());
        this.writeLayoutedEdge(edge, definition);
    }

    private void writeLayoutedEdge(Edge edge, Definition definition) {
        this.evaluator.setVariablesOfGreqlEvaluator(edge, this.getCurrentElementSequenceIndex());
        boolean bl = this.isReversedEdges();
        Vertex vertex = !bl ? edge.getAlpha() : edge.getOmega();
        Vertex vertex2 = !bl ? edge.getOmega() : edge.getAlpha();
        String string = this.getVertexName(vertex);
        String string2 = this.getVertexName(vertex2);
        Map<String, String> map = this.createEvaluatedStyleAttributeList(definition);
        if (bl) {
            this.reverseEdgeAttributes(map);
        }
        if (!map.containsKey("id")) {
            map.put("id", "e" + edge.getNormalEdge().getId());
        }
        this.writer.writeEdge(string, string2, map);
    }

    private void reverseEdgeAttributes(Map<String, String> map) {
        for (Map.Entry<String, String> entry : DotWriter.reversableEdgeAttributePairs.entrySet()) {
            this.swapAttributes(entry.getKey(), entry.getValue(), map);
        }
    }

    private void swapAttributes(String string, String string2, Map<String, String> map) {
        String string3 = map.remove(string);
        String string4 = map.remove(string2);
        if (string3 != null) {
            map.put(string2, string3);
        }
        if (string4 != null) {
            map.put(string, string4);
        }
    }

    @Override
    protected void graphEnd(PrintStream printStream) {
        this.writer.close();
        this.writer = null;
        JGraLab.setLogLevel(this.jGraLabLogLevel);
    }

    @Override
    protected String stringQuote(String string) {
        throw new RuntimeException("This method should have been called!");
    }

    public boolean printsIncidenceNumbers() {
        return this.printIncidenceIndices;
    }

    public void setPrintIncidenceNumbers(boolean bl) {
        this.printIncidenceIndices = bl;
    }

    public boolean isAbbreviateAttributeNames() {
        return this.abbreviateEdgeAttributeNames;
    }

    public void setAbbreviateAttributeNames(boolean bl) {
        this.abbreviateEdgeAttributeNames = bl;
    }

    public GraphLayout getGraphLayout() {
        return this.layout;
    }

    public void setGraphLayout(GraphLayout graphLayout) {
        this.layout = graphLayout;
    }

    public boolean isAbbreviateEdgeAttributeNames() {
        return this.abbreviateEdgeAttributeNames;
    }

    public void setAbbreviateEdgeAttributeNames(boolean bl) {
        this.abbreviateEdgeAttributeNames = bl;
    }

    public boolean isPrintElementSequenceIndices() {
        return this.printElementSequenceIndices;
    }

    public void setPrintElementSequenceIndices(boolean bl) {
        this.printElementSequenceIndices = bl;
    }

    public String getGraphLayoutFilename() {
        return this.graphLayoutFilename;
    }

    public void setPListGraphLayoutFilename(String string) {
        this.graphLayoutFilename = string;
    }

    public GraphVizLayouter getGraphVizLayouter() {
        return this.graphVizLayouter;
    }

    public void setGraphVizLayouter(GraphVizLayouter graphVizLayouter) {
        this.graphVizLayouter = graphVizLayouter;
    }

    public GraphVizOutputFormat getGraphVizOutputFormat() {
        return this.graphVizOutputFormat;
    }

    public void setGraphVizOutputFormat(GraphVizOutputFormat graphVizOutputFormat) {
        this.graphVizOutputFormat = graphVizOutputFormat;
    }
}

