/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlgui;

import de.uni_koblenz.ist.utilities.gui.FontSelectionDialog;
import de.uni_koblenz.ist.utilities.gui.RecentFilesList;
import de.uni_koblenz.ist.utilities.gui.StringListPreferences;
import de.uni_koblenz.ist.utilities.gui.SwingApplication;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.exception.EvaluationInterruptedException;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.exception.ParsingException;
import de.uni_koblenz.jgralab.greql.exception.QuerySourceException;
import de.uni_koblenz.jgralab.greql.exception.SerialisingException;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizerInfo;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.serialising.DefaultWriter;
import de.uni_koblenz.jgralab.greql.serialising.GreqlSerializer;
import de.uni_koblenz.jgralab.greql.serialising.HTMLOutputWriter;
import de.uni_koblenz.jgralab.greql.serialising.XMLOutputWriter;
import de.uni_koblenz.jgralab.utilities.greqlgui.GraphViewer;
import de.uni_koblenz.jgralab.utilities.greqlgui.QueryEditorPanel;
import de.uni_koblenz.jgralab.utilities.greqlgui.SettingsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.xml.stream.XMLStreamException;

public class GreqlGui
extends SwingApplication {
    private static final String PREFS_KEY_LAST_QUERY_DIRECTORY = "LAST_QUERY_DIRECTORY";
    private static final String PREFS_KEY_LAST_GRAPH_DIRECTORY = "LAST_GRAPH_DIRECTORY";
    private static final String PREFS_KEY_RECENT_GRAPH = "RECENT_GRAPH";
    private static final String PREFS_KEY_RECENT_QUERY = "RECENT_QUERY";
    private static final String PREFS_KEY_RESULT_FONT = "RESULT_FONT";
    private static final String PREFS_KEY_QUERY_FONT = "QUERY_FONT";
    private static final String PREFS_KEY_GENERIC_IMPL = "GENERIC_IMPL";
    private static final String PREFS_KEY_ENABLE_OPTIMIZER = "ENABLE_OPTIMIZER";
    private static final String PREFS_KEY_DEBUG_OPTIMIZER = "DEBUG_OPTIMIZER";
    private static final String PREFS_KEY_GREQL_FUNCTIONS = "GREQL_FUNCTION";
    private static final String VERSION = "0.0";
    private static final String BUNDLE_NAME = GreqlGui.class.getPackage().getName() + ".resources.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
    private static final String DOCUMENT_EXTENSION = ".greql";
    private static final String GRAPH_EXTENSION = ".tg";
    private Graph graph;
    private JTabbedPane editorPane;
    private List<QueryEditorPanel> queries;
    private JTextPane resultPane;
    private JTabbedPane outputPane;
    private JScrollPane resultScrollPane;
    private JTextArea consoleOutputArea;
    private JProgressBar progressBar;
    private BoundedRangeModel brm;
    private Evaluator evaluator;
    private final SwingApplication.FileDialog fd;
    private Action insertJavaQuotesAction;
    private Action removeJavaQuotesAction;
    private Action loadGraphAction;
    private Action unloadGraphAction;
    private Action genericImplementaionAction;
    private Action clearRecentGraphsAction;
    private Action evaluateQueryAction;
    private Action showQueryGraphAction;
    private Action stopEvaluationAction;
    private Action enableOptimizerAction;
    private Action debugOptimizerAction;
    private JCheckBoxMenuItem enableOptimizerCheckBoxItem;
    private JCheckBoxMenuItem debugOptimizerCheckBoxItem;
    private JCheckBoxMenuItem genericImplementationCheckBoxItem;
    private boolean graphLoading;
    private boolean evaluating;
    private double parseTime;
    private double evaluationTime;
    private final Preferences prefs = Preferences.userNodeForPackage(GreqlGui.class);
    private final RecentFilesList recentQueryList;
    private final RecentFilesList recentGraphList;
    private final StringListPreferences greqlFunctionList;
    private JMenu recentGraphsMenu;
    private Font queryFont;
    private Font resultFont;

    public GreqlGui() {
        super(RESOURCE_BUNDLE);
        this.loadFontSettings();
        this.initializeApplication();
        this.loadCheckBoxSettings();
        this.recentQueryList = new RecentFilesList(this.prefs, PREFS_KEY_RECENT_QUERY, 10, this.recentFilesMenu){

            @Override
            public void openRecentFile(File file) {
                GreqlGui.this.openFile(file);
            }
        };
        this.recentGraphList = new RecentFilesList(this.prefs, PREFS_KEY_RECENT_GRAPH, 10, this.recentGraphsMenu){

            @Override
            public void openRecentFile(File file) {
                GreqlGui.this.loadGraph(file);
            }
        };
        this.fd = new SwingApplication.FileDialog(this.getApplicationName());
        this.greqlFunctionList = new StringListPreferences(this.prefs, PREFS_KEY_GREQL_FUNCTIONS);
        this.greqlFunctionList.load();
        this.loadGreqlFunctions();
    }

    public boolean isGraphLoading() {
        return this.graphLoading;
    }

    public boolean isEvaluating() {
        return this.evaluating;
    }

    private void loadFontSettings() {
        String string = this.prefs.get(PREFS_KEY_QUERY_FONT, "Monospaced-plain-14");
        this.queryFont = Font.decode(string);
        if (this.queryFont == null) {
            this.queryFont = new Font("Monospaced", 0, 14);
        }
        string = this.prefs.get(PREFS_KEY_RESULT_FONT, "Monospaced-plain-14");
        this.resultFont = Font.decode(string);
        if (this.resultFont == null) {
            this.resultFont = new Font("Monospaced", 0, 14);
        }
    }

    private void loadCheckBoxSettings() {
        this.enableOptimizerCheckBoxItem.setSelected(this.prefs.getBoolean(PREFS_KEY_ENABLE_OPTIMIZER, true));
        this.debugOptimizerCheckBoxItem.setSelected(this.prefs.getBoolean(PREFS_KEY_DEBUG_OPTIMIZER, false));
        this.genericImplementationCheckBoxItem.setSelected(this.prefs.getBoolean(PREFS_KEY_GENERIC_IMPL, true));
    }

    @Override
    protected void editUndo() {
        this.getCurrentQuery().undo();
        this.updateActions();
    }

    @Override
    protected void editRedo() {
        this.getCurrentQuery().redo();
        this.updateActions();
    }

    @Override
    protected void editCut() {
        this.getCurrentQuery().cut();
        this.updateActions();
    }

    @Override
    protected void editCopy() {
        this.getCurrentQuery().copy();
        this.updateActions();
    }

    @Override
    protected void editPaste() {
        this.getCurrentQuery().paste();
        this.updateActions();
    }

    @Override
    protected void updateActions() {
        this.setModified(this.getCurrentQuery() != null && this.getCurrentQuery().isModified());
        this.fileCloseAction.setEnabled(this.getCurrentQuery() != null);
        this.fileSaveAction.setEnabled(this.getCurrentQuery() != null && this.isModified());
        this.fileSaveAsAction.setEnabled(this.getCurrentQuery() != null);
        this.filePrintAction.setEnabled(false);
        this.recentGraphsMenu.setEnabled(!this.graphLoading);
        this.editUndoAction.setEnabled(this.getCurrentQuery() != null && this.getCurrentQuery().canUndo());
        this.editRedoAction.setEnabled(this.getCurrentQuery() != null && this.getCurrentQuery().canRedo());
        this.editCutAction.setEnabled(this.getCurrentQuery() != null);
        this.editCopyAction.setEnabled(this.getCurrentQuery() != null);
        this.editPasteAction.setEnabled(this.getCurrentQuery() != null);
        this.insertJavaQuotesAction.setEnabled(this.getCurrentQuery() != null);
        this.removeJavaQuotesAction.setEnabled(this.getCurrentQuery() != null);
        this.loadGraphAction.setEnabled(!this.evaluating && !this.graphLoading);
        this.unloadGraphAction.setEnabled(!this.evaluating && !this.graphLoading && this.graph != null);
        this.evaluateQueryAction.setEnabled(this.getCurrentQuery() != null && !this.evaluating && !this.graphLoading);
        this.showQueryGraphAction.setEnabled(this.getCurrentQuery() != null && !this.evaluating && !this.graphLoading);
        this.stopEvaluationAction.setEnabled(this.evaluating);
        this.enableOptimizerAction.setEnabled(!this.evaluating);
        this.debugOptimizerAction.setEnabled(!this.evaluating);
        this.setTitle(MessageFormat.format(this.getMessage("Application.mainwindow.title"), this.getCurrentQuery() != null ? this.getCurrentQuery().getFileName() : this.getMessage("GreqlGui.NoQuery.Title")));
        if (this.getCurrentQuery() != null) {
            this.editorPane.setTitleAt(this.editorPane.getSelectedIndex(), (this.getCurrentQuery().isModified() ? "*" : "") + this.getCurrentQuery().getFileName());
        }
        if (this.getCurrentQuery() != null) {
            this.getCurrentQuery().requestFocus();
        }
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.loadGraphAction = new AbstractAction(this.getMessage("GreqlGui.Action.LoadGraph")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, GreqlGui.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GreqlGui.this.loadGraph();
            }
        };
        this.clearRecentGraphsAction = new AbstractAction(this.getMessage("GreqlGui.Action.ClearRecentGraphList")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GreqlGui.this.recentGraphList.clear();
            }
        };
        this.unloadGraphAction = new AbstractAction(this.getMessage("GreqlGui.Action.UnloadGraph")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GreqlGui.this.unloadGraph();
            }
        };
        this.genericImplementaionAction = new AbstractAction(this.getMessage("GreqlGui.Action.GenericImplementation")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GreqlGui.this.saveCheckBoxSettings();
            }
        };
        this.evaluateQueryAction = new AbstractAction(this.getMessage("GreqlGui.Action.EvaluateQuery")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, GreqlGui.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GreqlGui.this.evaluateQuery();
            }
        };
        this.showQueryGraphAction = new AbstractAction(this.getMessage("GreqlGui.Action.ShowQueryGraph")){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, GreqlGui.this.menuEventMask));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GreqlGui.this.showQueryGraph();
            }
        };
        this.stopEvaluationAction = new AbstractAction(this.getMessage("GreqlGui.Action.StopEvaluation")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GreqlGui.this.stopEvaluation();
            }
        };
        this.insertJavaQuotesAction = new AbstractAction(this.getMessage("GreqlGui.Action.InsertJavaQuotes")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GreqlGui.this.insertJavaQuotes();
            }
        };
        this.removeJavaQuotesAction = new AbstractAction(this.getMessage("GreqlGui.Action.RemoveJavaQuotes")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GreqlGui.this.removeJavaQuotes();
            }
        };
        this.enableOptimizerAction = new AbstractAction(this.getMessage("GreqlGui.Action.EnableOptimizer")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GreqlGui.this.saveCheckBoxSettings();
            }
        };
        this.debugOptimizerAction = new AbstractAction(this.getMessage("GreqlGui.Action.DebugOptimizer")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GreqlGui.this.saveCheckBoxSettings();
            }
        };
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = super.createMenuBar();
        JMenu jMenu = new JMenu(this.getMessage("GreqlGui.Menu.Graph"));
        jMenu.add(this.loadGraphAction);
        this.recentGraphsMenu = new JMenu(this.getMessage("GreqlGui.Menu.RecentGraphs"));
        this.recentGraphsMenu.addSeparator();
        this.recentGraphsMenu.add(this.clearRecentGraphsAction);
        jMenu.add(this.recentGraphsMenu);
        jMenu.addSeparator();
        this.genericImplementationCheckBoxItem = new JCheckBoxMenuItem(this.genericImplementaionAction);
        jMenu.add(this.genericImplementationCheckBoxItem);
        jMenu.add(this.unloadGraphAction);
        jMenuBar.add((Component)jMenu, jMenuBar.getComponentIndex(this.helpMenu));
        JMenu jMenu2 = new JMenu(this.getMessage("GreqlGui.Menu.Query"));
        jMenu2.add(this.evaluateQueryAction);
        jMenu2.add(this.stopEvaluationAction);
        jMenu2.addSeparator();
        jMenu2.add(this.insertJavaQuotesAction);
        jMenu2.add(this.removeJavaQuotesAction);
        jMenu2.addSeparator();
        this.enableOptimizerCheckBoxItem = new JCheckBoxMenuItem(this.enableOptimizerAction);
        this.enableOptimizerCheckBoxItem.setSelected(true);
        jMenu2.add(this.enableOptimizerCheckBoxItem);
        this.debugOptimizerCheckBoxItem = new JCheckBoxMenuItem(this.debugOptimizerAction);
        jMenu2.add(this.debugOptimizerCheckBoxItem);
        jMenu2.add(this.showQueryGraphAction);
        jMenuBar.add((Component)jMenu2, jMenuBar.getComponentIndex(jMenu));
        return jMenuBar;
    }

    @Override
    protected JPanel createToolBar() {
        JPanel jPanel = super.createToolBar();
        jPanel.add(new JButton(this.loadGraphAction));
        jPanel.add(new JButton(this.evaluateQueryAction));
        jPanel.add(new JButton(this.stopEvaluationAction));
        jPanel.add(new JButton(this.insertJavaQuotesAction));
        jPanel.add(new JButton(this.removeJavaQuotesAction));
        return jPanel;
    }

    @Override
    protected Component createContent() {
        this.queries = new ArrayList<QueryEditorPanel>();
        this.editorPane = new JTabbedPane();
        this.editorPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GreqlGui.this.updateActions();
            }
        });
        this.resultPane = new JTextPane();
        this.resultPane.setEditable(false);
        this.resultPane.addPropertyChangeListener("page", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GreqlGui.this.setResultFont(GreqlGui.this.resultFont);
                GreqlGui.this.getStatusBar().setText(MessageFormat.format(GreqlGui.this.getMessage("GreqlGui.StatusMessage.ResultComplete"), GreqlGui.this.parseTime, GreqlGui.this.evaluationTime));
            }
        });
        this.resultScrollPane = new JScrollPane(this.resultPane);
        this.resultScrollPane.setPreferredSize(new Dimension(200, 200));
        this.brm = new DefaultBoundedRangeModel();
        this.progressBar = new JProgressBar();
        this.progressBar.setModel(this.brm);
        this.progressBar.setStringPainted(true);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        if (RUNS_ON_MAC_OS_X) {
            this.progressBar.putClientProperty("JComponent.sizeVariant", "small");
        }
        this.consoleOutputArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.consoleOutputArea);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        System.setOut(new ConsoleOutputStream());
        System.setErr(new ConsoleOutputStream());
        this.outputPane = new JTabbedPane();
        this.outputPane.addTab(this.getMessage("GreqlGui.Result.Title"), this.resultScrollPane);
        this.outputPane.addTab(this.getMessage("GreqlGui.Console.Title"), jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.editorPane, "Center");
        jPanel.add((Component)this.progressBar, "South");
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.add((Component)jPanel, "top");
        jSplitPane.add((Component)this.outputPane, "bottom");
        this.fileNew();
        return jSplitPane;
    }

    protected String getPrefString(String string, String string2) {
        Preferences preferences = Preferences.userNodeForPackage(GreqlGui.class);
        return preferences.get(string, string2);
    }

    protected void setPrefString(String string, String string2) {
        Preferences preferences = Preferences.userNodeForPackage(GreqlGui.class);
        preferences.put(string, string2);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openFile(File file) {
        for (QueryEditorPanel queryEditorPanel : this.queries) {
            if (!file.equals(queryEditorPanel.getQueryFile())) continue;
            this.editorPane.setSelectedComponent(queryEditorPanel);
            return;
        }
        try {
            if (this.getCurrentQuery() != null && this.getCurrentQuery().getQueryFile() == null && !this.getCurrentQuery().isModified()) {
                this.getCurrentQuery().loadFromFile(file);
            } else {
                QueryEditorPanel queryEditorPanel = new QueryEditorPanel(this, file);
                this.queries.add(queryEditorPanel);
                this.editorPane.addTab("", queryEditorPanel);
                this.editorPane.setSelectedComponent(queryEditorPanel);
            }
            this.recentQueryList.rememberFile(file);
            this.setPrefString(PREFS_KEY_LAST_QUERY_DIRECTORY, file.getParentFile().getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.updateActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveFile(File file) {
        try {
            this.getCurrentQuery().saveToFile(file);
            this.setPrefString(PREFS_KEY_LAST_QUERY_DIRECTORY, file.getParentFile().getCanonicalPath());
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.updateActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fileNew() {
        try {
            QueryEditorPanel queryEditorPanel = new QueryEditorPanel(this);
            this.queries.add(queryEditorPanel);
            this.editorPane.addTab("", queryEditorPanel);
            this.editorPane.setSelectedComponent(queryEditorPanel);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.updateActions();
        }
    }

    @Override
    protected void fileOpen() {
        String string = this.getPrefString(PREFS_KEY_LAST_QUERY_DIRECTORY, System.getProperty("user.dir"));
        this.fd.setDirectory(new File(string));
        File file = this.fd.showFileOpenDialog(this, this.getMessage("GreqlGui.FileOpenDialog.Title"), DOCUMENT_EXTENSION, this.getMessage("GreqlGui.FileOpenDialog.FilterName"));
        if (file != null) {
            this.openFile(file);
        }
    }

    @Override
    protected boolean confirmClose() {
        if (!this.isModified()) {
            return true;
        }
        switch (JOptionPane.showConfirmDialog(this, this.getMessage("GreqlGui.ConfirmUnsaved"), this.getMessage("Application.name"), 1, 3)) {
            case 0: {
                if (this.getCurrentQuery().getQueryFile() != null) {
                    return this.saveFile(this.getCurrentQuery().getQueryFile());
                }
                return this.fileSaveAs();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean confirmExit() {
        for (QueryEditorPanel queryEditorPanel : this.queries) {
            if (!queryEditorPanel.isModified()) continue;
            this.editorPane.setSelectedComponent(queryEditorPanel);
            if (this.confirmClose()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void fileClose() {
        if (this.confirmClose()) {
            QueryEditorPanel queryEditorPanel = this.getCurrentQuery();
            this.editorPane.remove(queryEditorPanel);
            this.queries.remove(queryEditorPanel);
        }
    }

    @Override
    protected void fileSave() {
        if (this.getCurrentQuery().getQueryFile() == null) {
            this.fileSaveAs();
        } else {
            this.saveFile(this.getCurrentQuery().getQueryFile());
        }
    }

    @Override
    protected boolean fileSaveAs() {
        File file = this.fd.showFileSaveAsDialog(this, this.getMessage("GreqlGui.FileSaveAsDialog.Title"), DOCUMENT_EXTENSION, this.getCurrentQuery().getQueryFile());
        if (file == null) {
            return false;
        }
        return this.saveFile(file);
    }

    @Override
    protected void fileClearRecentFiles() {
        this.recentQueryList.clear();
    }

    @Override
    protected void editPreferences() {
        new SettingsDialog(this, this.queryFont, this.resultFont, this.greqlFunctionList.getEntries());
    }

    private void loadGraph(File file) {
        try {
            this.setPrefString(PREFS_KEY_LAST_GRAPH_DIRECTORY, file.getParentFile().getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.graphLoading = true;
        this.updateActions();
        new GraphLoader(this.brm, file).start();
    }

    public synchronized Graph getGraph() {
        return this.graph;
    }

    private void loadGreqlFunctions() {
        if (this.greqlFunctionList.size() == 0) {
            return;
        }
        new GreqlFunctionLoader(this.brm).start();
    }

    private void loadGraph() {
        String string = this.getPrefString(PREFS_KEY_LAST_GRAPH_DIRECTORY, System.getProperty("user.dir"));
        this.fd.setDirectory(new File(string));
        File file = this.fd.showFileOpenDialog(this, this.getMessage("GreqlGui.GraphOpenDialog.Title"), GRAPH_EXTENSION, this.getMessage("GreqlGui.GraphOpenDialog.FilterName"));
        if (file != null) {
            this.loadGraph(file);
        }
    }

    private void showQueryGraph() {
        String string = this.getCurrentQuery().getText();
        GreqlQuery greqlQuery = GreqlQuery.createQuery(string, this.enableOptimizerCheckBoxItem.isSelected() ? new DefaultOptimizer(new DefaultOptimizerInfo(this.graph != null ? this.graph.getSchema() : null)) : null);
        new GraphViewer(this, greqlQuery.getQueryGraph(), GreqlSerializer.serializeGraph(greqlQuery.getQueryGraph())).setVisible(true);
    }

    private synchronized void unloadGraph() {
        this.graph = null;
        this.getStatusBar().setText(this.getMessage("GreqlGui.StatusMessage.GraphUnloaded"));
        this.updateActions();
    }

    private void insertJavaQuotes() {
        this.getCurrentQuery().insertJavaQuotes();
        this.updateActions();
    }

    private void removeJavaQuotes() {
        this.getCurrentQuery().removeJavaQuotes();
        this.updateActions();
    }

    private void evaluateQuery() {
        this.evaluating = true;
        this.brm.setValue(this.brm.getMinimum());
        this.evaluator = new Evaluator(this.brm, this.getCurrentQuery().getText());
        this.updateActions();
        this.evaluator.start();
    }

    private void stopEvaluation() {
        if (this.evaluating) {
            this.evaluator.interrupt();
        }
    }

    public String getEvaluateQueryShortcut() {
        KeyStroke keyStroke = (KeyStroke)this.evaluateQueryAction.getValue("AcceleratorKey");
        return this.getKeyStrokeAsString(keyStroke);
    }

    private QueryEditorPanel getCurrentQuery() {
        return (QueryEditorPanel)this.editorPane.getSelectedComponent();
    }

    private void setQueryFont(Font font) {
        this.queryFont = font;
        for (QueryEditorPanel queryEditorPanel : this.queries) {
            queryEditorPanel.setQueryFont(this.queryFont);
        }
    }

    public Font getQueryFont() {
        return this.queryFont;
    }

    private void setResultFont(Font font) {
        this.resultFont = font;
        this.resultPane.setContentType("text/html");
        String string = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.resultPane.getDocument()).getStyleSheet().addRule(string);
        this.resultPane.setCaretPosition(0);
    }

    public void saveSettings(SettingsDialog settingsDialog) {
        this.setQueryFont(settingsDialog.getQueryFont());
        if (this.queryFont == null) {
            this.prefs.remove(PREFS_KEY_QUERY_FONT);
        } else {
            this.prefs.put(PREFS_KEY_QUERY_FONT, FontSelectionDialog.getInternalFontName(this.queryFont));
        }
        this.setResultFont(settingsDialog.getResultFont());
        if (this.resultFont == null) {
            this.prefs.remove(PREFS_KEY_RESULT_FONT);
        } else {
            this.prefs.put(PREFS_KEY_RESULT_FONT, FontSelectionDialog.getInternalFontName(this.resultFont));
        }
        this.greqlFunctionList.setEntries(settingsDialog.getGreqlFunctionList());
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    private void saveCheckBoxSettings() {
        this.prefs.putBoolean(PREFS_KEY_DEBUG_OPTIMIZER, this.debugOptimizerCheckBoxItem.isSelected());
        this.prefs.putBoolean(PREFS_KEY_ENABLE_OPTIMIZER, this.enableOptimizerCheckBoxItem.isSelected());
        this.prefs.putBoolean(PREFS_KEY_GENERIC_IMPL, this.genericImplementationCheckBoxItem.isSelected());
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        SwingApplication.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GreqlGui().setVisible(true);
            }
        });
    }

    private class ConsoleOutputStream
    extends PrintStream {
        public ConsoleOutputStream() {
            super(new ByteArrayOutputStream());
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            final String string = new String(byArray, n, n2);
            SwingApplication.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GreqlGui.this.consoleOutputArea.append(string);
                }
            });
        }
    }

    class Evaluator
    extends Worker {
        private final String queryString;
        private GreqlQuery query;
        private Object queryResult;

        Evaluator(BoundedRangeModel boundedRangeModel, String string) {
            super("EvaluatorThread", boundedRangeModel);
            this.queryString = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SwingApplication.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GreqlGui.this.progressBar.setIndeterminate(true);
                }
            });
            this.queryResult = null;
            try {
                GreqlGui.this.parseTime = System.currentTimeMillis();
                GreqlQueryImpl.DEBUG_OPTIMIZATION = GreqlGui.this.debugOptimizerCheckBoxItem.isSelected();
                try {
                    this.query = GreqlQuery.createQuery(this.queryString, GreqlGui.this.enableOptimizerCheckBoxItem.isSelected() ? new DefaultOptimizer(new DefaultOptimizerInfo(GreqlGui.this.graph != null ? GreqlGui.this.graph.getSchema() : null)) : null);
                }
                catch (Exception exception) {
                    this.ex = exception;
                }
                if (this.ex == null) {
                    GreqlGui.this.evaluationTime = System.currentTimeMillis();
                    GreqlGui.this.parseTime = (GreqlGui.this.evaluationTime - GreqlGui.this.parseTime) / 1000.0;
                    try {
                        this.queryResult = this.query.evaluate(GreqlGui.this.graph, new GreqlEnvironmentAdapter(), this);
                    }
                    catch (Exception exception) {
                        this.ex = exception;
                    }
                    finally {
                        GreqlGui.this.evaluationTime = ((double)System.currentTimeMillis() - GreqlGui.this.evaluationTime) / 1000.0;
                    }
                }
                if (this.ex != null && !(this.ex instanceof EvaluationInterruptedException)) {
                    SwingApplication.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            GreqlGui.this.evaluating = false;
                            Evaluator.this.brm.setValue(Evaluator.this.brm.getMinimum());
                            GreqlGui.this.getStatusBar().setText(GreqlGui.this.getMessage("GreqlGui.StatusMessage.EvaluationFailed"));
                            String string = Evaluator.this.ex.getMessage();
                            if (string == null) {
                                string = Evaluator.this.ex.getCause() != null ? Evaluator.this.ex.getCause().toString() : Evaluator.this.ex.toString();
                            }
                            Evaluator.this.ex.printStackTrace();
                            if (Evaluator.this.ex instanceof QuerySourceException) {
                                QuerySourceException querySourceException = (QuerySourceException)Evaluator.this.ex;
                                List<SourcePosition> list = querySourceException.getSourcePositions();
                                if (list.size() > 0) {
                                    SourcePosition sourcePosition = list.get(0);
                                    GreqlGui.this.getCurrentQuery().setSelection(sourcePosition.get_offset(), sourcePosition.get_length());
                                }
                            } else if (Evaluator.this.ex instanceof ParsingException) {
                                ParsingException parsingException = (ParsingException)Evaluator.this.ex;
                                GreqlGui.this.getCurrentQuery().setSelection(parsingException.getOffset(), parsingException.getLength());
                            }
                            GreqlGui.this.resultPane.setText(Evaluator.this.ex.getClass().getSimpleName() + ": " + string);
                            GreqlGui.this.setResultFont(GreqlGui.this.resultFont);
                            GreqlGui.this.updateActions();
                        }
                    });
                }
                if (this.ex == null) {
                    SwingApplication.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultWriter defaultWriter;
                            File file;
                            GreqlGui.this.getStatusBar().setText(MessageFormat.format(GreqlGui.this.getMessage("GreqlGui.StatusMessage.EvaluationFinished"), GreqlGui.this.evaluationTime));
                            GreqlGui.this.evaluating = false;
                            GreqlGui.this.updateActions();
                            try {
                                file = new File("greqlQueryResult.xml");
                                defaultWriter = new XMLOutputWriter(GreqlGui.this.graph);
                                ((XMLOutputWriter)defaultWriter).writeValue(Evaluator.this.queryResult, file);
                            }
                            catch (SerialisingException serialisingException) {
                                JOptionPane.showMessageDialog(GreqlGui.this, "Exception during XML output of result: " + serialisingException.toString());
                            }
                            catch (XMLStreamException xMLStreamException) {
                                JOptionPane.showMessageDialog(GreqlGui.this, "Exception during XML output of result: " + xMLStreamException.toString());
                            }
                            try {
                                file = new File("greqlQueryResult.html");
                                defaultWriter = new HTMLOutputWriter(GreqlGui.this.graph);
                                ((HTMLOutputWriter)defaultWriter).setUseCss(false);
                                ((HTMLOutputWriter)defaultWriter).writeValue(Evaluator.this.queryResult, file);
                                Document document = GreqlGui.this.resultPane.getDocument();
                                document.putProperty("stream", null);
                                GreqlGui.this.outputPane.setSelectedComponent(GreqlGui.this.resultScrollPane);
                                GreqlGui.this.resultPane.setPage(new URL("file", "localhost", file.getCanonicalPath()));
                            }
                            catch (SerialisingException serialisingException) {
                                JOptionPane.showMessageDialog(GreqlGui.this, "Exception during HTML output of result: " + serialisingException.toString());
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(GreqlGui.this, "Exception during HTML output of result: " + iOException.toString());
                            }
                        }
                    });
                }
            }
            finally {
                this.finished();
            }
        }

        @Override
        public void init(long l) {
            super.init(l);
            SwingApplication.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GreqlGui.this.getStatusBar().setText(GreqlGui.this.getMessage("GreqlGui.StatusMessage.Evaluating"));
                }
            });
        }

        @Override
        public void finish() {
            super.finish();
            GreqlGui.this.evaluator = null;
            GreqlGui.this.evaluating = false;
            if (this.ex != null && this.ex instanceof EvaluationInterruptedException) {
                GreqlGui.this.resultPane.setText(GreqlGui.this.getMessage("GreqlGui.StatusMessage.QueryAborted"));
                GreqlGui.this.setResultFont(GreqlGui.this.resultFont);
                GreqlGui.this.getStatusBar().setText(GreqlGui.this.getMessage("GreqlGui.StatusMessage.QueryAborted"));
            }
            GreqlGui.this.updateActions();
        }
    }

    class GraphLoader
    extends Worker {
        private final File file;

        GraphLoader(BoundedRangeModel boundedRangeModel, File file) {
            super("GraphLoaderThread", boundedRangeModel);
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                GreqlGui.this.progressBar.setIndeterminate(true);
                GreqlGui.this.graph = GraphIO.loadGraphFromFile(this.file.getCanonicalPath(), GreqlGui.this.genericImplementationCheckBoxItem.isSelected() ? ImplementationType.GENERIC : ImplementationType.STANDARD, (ProgressFunction)this);
                GreqlGui.this.recentGraphList.rememberFile(this.file);
            }
            catch (Exception exception) {
                this.brm.setValue(this.brm.getMinimum());
                GreqlGui.this.progressBar.setIndeterminate(false);
                GreqlGui.this.graph = null;
                this.ex = exception;
            }
            finally {
                GreqlGui.this.graphLoading = false;
            }
            SwingApplication.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (GreqlGui.this.graph == null) {
                        String string = "Can't load ";
                        try {
                            string = string + GraphLoader.this.file.getCanonicalPath() + "\n" + GraphLoader.this.ex.getMessage();
                        }
                        catch (IOException iOException) {
                            string = string + "graph\n";
                        }
                        Throwable throwable = GraphLoader.this.ex.getCause();
                        if (throwable != null) {
                            string = string + "\ncaused by " + throwable;
                        }
                        JOptionPane.showMessageDialog(GreqlGui.this, string, GraphLoader.this.ex.getClass().getSimpleName(), 0);
                        GreqlGui.this.getStatusBar().setText(GreqlGui.this.getMessage("GreqlGui.StatusMessage.GraphLoadingFailed"));
                    } else {
                        GreqlGui.this.getStatusBar().setText(MessageFormat.format(GreqlGui.this.getMessage("GreqlGui.StatusMessage.GraphLoadingFinished"), GreqlGui.this.graph.getId()));
                    }
                    GreqlGui.this.updateActions();
                }
            });
        }

        @Override
        public void init(long l) {
            super.init(l);
            SwingApplication.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GreqlGui.this.getStatusBar().setText(GreqlGui.this.getMessage("GreqlGui.StatusMessage.GraphLoading"));
                }
            });
        }
    }

    class GreqlFunctionLoader
    extends Worker {
        boolean errors;

        GreqlFunctionLoader(BoundedRangeModel boundedRangeModel) {
            super("GreqlFunctionLoaderThread", boundedRangeModel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.init(GreqlGui.this.greqlFunctionList.size());
            try {
                this.errors = false;
                for (String string : GreqlGui.this.greqlFunctionList.getEntries()) {
                    try {
                        FunLib.register(string);
                    }
                    catch (GreqlException greqlException) {
                        System.err.println(MessageFormat.format(GreqlGui.this.getMessage("GreqlGui.StatusMessage.FunctionGreqlException"), string, greqlException.getMessage()));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.errors = true;
                        System.err.println(MessageFormat.format(GreqlGui.this.getMessage("GreqlGui.StatusMessage.FunctionNotFound"), string));
                    }
                    catch (ClassCastException classCastException) {
                        this.errors = true;
                        System.err.println(MessageFormat.format(GreqlGui.this.getMessage("GreqlGui.StatusMessage.FunctionWrongType"), string));
                    }
                    this.progress(1L);
                }
            }
            finally {
                this.finished();
            }
        }

        @Override
        public void init(long l) {
            super.init(l);
            SwingApplication.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GreqlGui.this.getStatusBar().setText(GreqlGui.this.getMessage("GreqlGui.StatusMessage.FunctionsLoading"));
                }
            });
        }

        @Override
        public void finished() {
            super.finished();
            SwingApplication.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GreqlGui.this.getStatusBar().setText(GreqlGui.this.getMessage(GreqlFunctionLoader.this.errors ? "GreqlGui.StatusMessage.FunctionsLoadedWithErrors" : "GreqlGui.StatusMessage.FunctionsLoaded"));
                }
            });
        }
    }

    class Worker
    extends Thread
    implements ProgressFunction {
        BoundedRangeModel brm;
        private long totalElements;
        Exception ex;

        Worker(String string, BoundedRangeModel boundedRangeModel) {
            super(string);
            this.brm = boundedRangeModel;
        }

        protected void finish() {
            GreqlGui.this.progressBar.setIndeterminate(false);
            GreqlGui.this.progressBar.setStringPainted(false);
            this.brm.setValue(this.brm.getMinimum());
        }

        @Override
        public void finished() {
            SwingApplication.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Worker.this.finish();
                }
            });
        }

        @Override
        public long getUpdateInterval() {
            return (long)this.brm.getMaximum() > this.totalElements ? 1L : this.totalElements / (long)this.brm.getMaximum();
        }

        @Override
        public void init(long l) {
            this.totalElements = l;
            SwingApplication.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Worker.this.brm.setValue(Worker.this.brm.getMinimum());
                }
            });
        }

        @Override
        public void progress(long l) {
            SwingApplication.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GreqlGui.this.progressBar.setIndeterminate(false);
                    GreqlGui.this.progressBar.setStringPainted(true);
                    Worker.this.brm.setValue(Worker.this.brm.getValue() + 1);
                }
            });
        }
    }
}

